/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.search.result.facets;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.java.search.util.SearchUtils;
import java.util.Date;

@InterfaceStability.Experimental
@InterfaceAudience.Public
public class DateRange {
    private final String name;
    private final Date start;
    private final Date end;
    private final long count;

    public DateRange(String name, String start, String end, long count) {
        this.name = name;
        this.count = count;
        this.start = SearchUtils.fromFtsString(start);
        this.end = SearchUtils.fromFtsString(end);
    }

    public String name() {
        return this.name;
    }

    public Date start() {
        return this.start;
    }

    public Date end() {
        return this.end;
    }

    public long count() {
        return this.count;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        sb.append("name='").append(this.name).append('\'');
        if (this.start != null) {
            sb.append(", start='").append(this.start).append('\'');
        }
        if (this.end != null) {
            sb.append(", end='").append(this.end).append('\'');
        }
        sb.append(", count=").append(this.count);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DateRange dateRange = (DateRange)o;
        if (this.count != dateRange.count) {
            return false;
        }
        if (!this.name.equals(dateRange.name)) {
            return false;
        }
        if (this.start != null ? !this.start.equals(dateRange.start) : dateRange.start != null) {
            return false;
        }
        return this.end != null ? this.end.equals(dateRange.end) : dateRange.end == null;
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (this.start != null ? this.start.hashCode() : 0);
        result = 31 * result + (this.end != null ? this.end.hashCode() : 0);
        result = 31 * result + (int)(this.count ^ this.count >>> 32);
        return result;
    }
}

