/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.event.consumers;

import com.couchbase.client.core.event.CouchbaseEvent;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.utils.Events;
import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.document.RawJsonDocument;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Func1;

public class BucketConsumer
extends Subscriber<CouchbaseEvent> {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(BucketConsumer.class);
    private final Bucket bucket;
    private final StoreType storeType;

    private BucketConsumer(Bucket bucket, StoreType storeType) {
        this.bucket = bucket;
        this.storeType = storeType;
    }

    public static BucketConsumer create(Bucket bucket) {
        return BucketConsumer.create(bucket, StoreType.UPSERT);
    }

    public static BucketConsumer create(Bucket bucket, StoreType storeType) {
        return new BucketConsumer(bucket, storeType);
    }

    public void onCompleted() {
        LOGGER.trace("Event stream completed in bucket consumer.");
    }

    public void onError(Throwable ex) {
        LOGGER.warn("Received error in bucket consumer.", ex);
    }

    public void onNext(CouchbaseEvent event) {
        Observable<RawJsonDocument> stored;
        RawJsonDocument doc = RawJsonDocument.create(this.generateKey(event), Events.toJson((CouchbaseEvent)event, (boolean)false));
        if (this.storeType == StoreType.INSERT) {
            stored = this.bucket.async().insert(doc);
        } else if (this.storeType == StoreType.UPSERT) {
            stored = this.bucket.async().upsert(doc);
        } else {
            throw new UnsupportedOperationException("Store type " + (Object)((Object)this.storeType) + " is not supported");
        }
        stored.onErrorResumeNext((Func1)new Func1<Throwable, Observable<? extends RawJsonDocument>>(){

            public Observable<? extends RawJsonDocument> call(Throwable ex) {
                LOGGER.warn("Received error while storing document in bucket consumer.", ex);
                return Observable.empty();
            }
        }).subscribe();
    }

    protected String generateKey(CouchbaseEvent event) {
        return System.nanoTime() + "-" + event.getClass().getSimpleName();
    }

    public static enum StoreType {
        UPSERT,
        INSERT;

    }
}

