/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.search;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.java.MutationState;
import com.couchbase.client.java.document.Document;
import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.search.HighlightStyle;
import com.couchbase.client.java.search.SearchConsistency;
import com.couchbase.client.java.search.facet.SearchFacet;
import com.couchbase.client.java.search.queries.AbstractFtsQuery;
import com.couchbase.client.java.search.queries.BooleanFieldQuery;
import com.couchbase.client.java.search.queries.BooleanQuery;
import com.couchbase.client.java.search.queries.ConjunctionQuery;
import com.couchbase.client.java.search.queries.DateRangeQuery;
import com.couchbase.client.java.search.queries.DisjunctionQuery;
import com.couchbase.client.java.search.queries.DocIdQuery;
import com.couchbase.client.java.search.queries.GeoBoundingBoxQuery;
import com.couchbase.client.java.search.queries.GeoDistanceQuery;
import com.couchbase.client.java.search.queries.MatchAllQuery;
import com.couchbase.client.java.search.queries.MatchNoneQuery;
import com.couchbase.client.java.search.queries.MatchPhraseQuery;
import com.couchbase.client.java.search.queries.MatchQuery;
import com.couchbase.client.java.search.queries.NumericRangeQuery;
import com.couchbase.client.java.search.queries.PhraseQuery;
import com.couchbase.client.java.search.queries.PrefixQuery;
import com.couchbase.client.java.search.queries.QueryStringQuery;
import com.couchbase.client.java.search.queries.RegexpQuery;
import com.couchbase.client.java.search.queries.TermQuery;
import com.couchbase.client.java.search.queries.TermRangeQuery;
import com.couchbase.client.java.search.queries.WildcardQuery;
import com.couchbase.client.java.search.sort.SearchSort;
import com.couchbase.client.java.subdoc.DocumentFragment;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@InterfaceStability.Committed
@InterfaceAudience.Public
public class SearchQuery {
    private final String indexName;
    private final AbstractFtsQuery queryPart;
    private Integer limit;
    private Integer skip;
    private Boolean explain;
    private HighlightStyle highlightStyle;
    private String[] highlightFields;
    private String[] fields;
    private JsonArray sort;
    private Map<String, SearchFacet> facets;
    private Long serverSideTimeout;
    private SearchConsistency consistency;
    private MutationState mutationState;

    public SearchQuery(String indexName, AbstractFtsQuery queryPart) {
        this.indexName = indexName;
        this.queryPart = queryPart;
        this.highlightFields = new String[0];
        this.fields = new String[0];
        this.sort = JsonArray.empty();
        this.facets = new HashMap<String, SearchFacet>();
        this.consistency = null;
        this.mutationState = null;
    }

    public String indexName() {
        return this.indexName;
    }

    public AbstractFtsQuery query() {
        return this.queryPart;
    }

    public JsonObject export() {
        JsonObject result = JsonObject.create();
        this.injectParams(result);
        JsonObject queryJson = JsonObject.create();
        this.queryPart.injectParamsAndBoost(queryJson);
        return result.put("query", queryJson);
    }

    public void injectParams(JsonObject queryJson) {
        if (this.limit != null && this.limit >= 0) {
            queryJson.put("size", this.limit);
        }
        if (this.skip != null && this.skip >= 0) {
            queryJson.put("from", this.skip);
        }
        if (this.explain != null) {
            queryJson.put("explain", this.explain);
        }
        if (this.highlightStyle != null) {
            JsonObject highlight = JsonObject.create();
            if (this.highlightStyle != HighlightStyle.SERVER_DEFAULT) {
                highlight.put("style", this.highlightStyle.name().toLowerCase());
            }
            if (this.highlightFields != null && this.highlightFields.length > 0) {
                highlight.put("fields", JsonArray.from(this.highlightFields));
            }
            queryJson.put("highlight", highlight);
        }
        if (this.fields != null && this.fields.length > 0) {
            queryJson.put("fields", JsonArray.from(this.fields));
        }
        if (!this.sort.isEmpty()) {
            queryJson.put("sort", this.sort);
        }
        if (!this.facets.isEmpty()) {
            JsonObject facets = JsonObject.create();
            for (Map.Entry<String, SearchFacet> entry : this.facets.entrySet()) {
                JsonObject facetJson = JsonObject.create();
                entry.getValue().injectParams(facetJson);
                facets.put(entry.getKey(), facetJson);
            }
            queryJson.put("facets", facets);
        }
        JsonObject control = JsonObject.empty();
        if (this.serverSideTimeout != null) {
            control.put("timeout", this.serverSideTimeout);
        }
        if (this.consistency != null || this.mutationState != null) {
            JsonObject consistencyJson = JsonObject.create();
            if (this.consistency == SearchConsistency.NOT_BOUNDED) {
                consistencyJson.put("level", "");
            } else if (this.mutationState != null) {
                consistencyJson.put("level", "at_plus");
                consistencyJson.put("vectors", JsonObject.create().put(this.indexName, this.mutationState.exportForFts()));
            }
            control.put("consistency", consistencyJson);
        }
        if (!control.isEmpty()) {
            queryJson.put("ctl", control);
        }
    }

    public SearchQuery limit(int limit) {
        this.limit = limit;
        return this;
    }

    public SearchQuery skip(int skip) {
        this.skip = skip;
        return this;
    }

    public SearchQuery explain() {
        return this.explain(true);
    }

    public SearchQuery explain(boolean explain) {
        this.explain = explain;
        return this;
    }

    public SearchQuery highlight(HighlightStyle style, String ... fields) {
        this.highlightStyle = style;
        if (fields != null && fields.length > 0) {
            this.highlightFields = fields;
        }
        return this;
    }

    public SearchQuery highlight(String ... fields) {
        return this.highlight(HighlightStyle.SERVER_DEFAULT, fields);
    }

    public SearchQuery highlight() {
        return this.highlight(HighlightStyle.SERVER_DEFAULT, new String[0]);
    }

    public SearchQuery clearHighlight() {
        this.highlightStyle = null;
        this.highlightFields = null;
        return this;
    }

    public SearchQuery fields(String ... fields) {
        if (fields != null) {
            this.fields = fields;
        }
        return this;
    }

    public SearchQuery sort(Object ... sort) {
        if (sort != null) {
            for (Object o : sort) {
                if (o instanceof String) {
                    this.sort.add((String)o);
                    continue;
                }
                if (o instanceof SearchSort) {
                    JsonObject params = JsonObject.create();
                    ((SearchSort)o).injectParams(params);
                    this.sort.add(params);
                    continue;
                }
                if (o instanceof JsonObject) {
                    this.sort.add(o);
                    continue;
                }
                throw new IllegalArgumentException("Only String ort SearchSort instances are allowed as sort arguments!");
            }
        }
        return this;
    }

    public SearchQuery addFacet(String facetName, SearchFacet facet) {
        if (facet == null || facetName == null) {
            throw new NullPointerException("Facet name and description must not be null");
        }
        this.facets.put(facetName, facet);
        return this;
    }

    public SearchQuery clearFacets() {
        this.facets.clear();
        return this;
    }

    public SearchQuery serverSideTimeout(long timeout, TimeUnit unit) {
        this.serverSideTimeout = unit.toMillis(timeout);
        return this;
    }

    public SearchQuery searchConsistency(SearchConsistency consistency) {
        this.consistency = consistency;
        this.mutationState = null;
        return this;
    }

    public SearchQuery consistentWith(Document ... docs) {
        this.consistency = null;
        this.mutationState = MutationState.from(docs);
        return this;
    }

    public SearchQuery consistentWith(DocumentFragment ... fragments) {
        this.consistency = null;
        this.mutationState = MutationState.from(fragments);
        return this;
    }

    public SearchQuery consistentWith(MutationState mutationState) {
        this.consistency = null;
        this.mutationState = mutationState;
        return this;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Integer getSkip() {
        return this.skip;
    }

    public HighlightStyle getHighlightStyle() {
        return this.highlightStyle;
    }

    public String[] getHighlightFields() {
        return this.highlightFields;
    }

    public String[] getFields() {
        return this.fields;
    }

    public Map<String, SearchFacet> getFacets() {
        return this.facets;
    }

    public Long getServerSideTimeout() {
        return this.serverSideTimeout;
    }

    public static QueryStringQuery queryString(String query) {
        return new QueryStringQuery(query);
    }

    public static MatchQuery match(String match) {
        return new MatchQuery(match);
    }

    public static MatchPhraseQuery matchPhrase(String matchPhrase) {
        return new MatchPhraseQuery(matchPhrase);
    }

    public static PrefixQuery prefix(String prefix) {
        return new PrefixQuery(prefix);
    }

    public static RegexpQuery regexp(String regexp) {
        return new RegexpQuery(regexp);
    }

    public static TermRangeQuery termRange() {
        return new TermRangeQuery();
    }

    public static NumericRangeQuery numericRange() {
        return new NumericRangeQuery();
    }

    public static DateRangeQuery dateRange() {
        return new DateRangeQuery();
    }

    public static DisjunctionQuery disjuncts(AbstractFtsQuery ... queries) {
        return new DisjunctionQuery(queries);
    }

    public static ConjunctionQuery conjuncts(AbstractFtsQuery ... queries) {
        return new ConjunctionQuery(queries);
    }

    public static BooleanQuery booleans() {
        return new BooleanQuery();
    }

    public static WildcardQuery wildcard(String wildcard) {
        return new WildcardQuery(wildcard);
    }

    public static DocIdQuery docId(String ... docIds) {
        return new DocIdQuery(docIds);
    }

    public static BooleanFieldQuery booleanField(boolean value) {
        return new BooleanFieldQuery(value);
    }

    public static TermQuery term(String term) {
        return new TermQuery(term);
    }

    public static PhraseQuery phrase(String ... terms) {
        return new PhraseQuery(terms);
    }

    public static MatchAllQuery matchAll() {
        return new MatchAllQuery();
    }

    public static MatchNoneQuery matchNone() {
        return new MatchNoneQuery();
    }

    public static GeoBoundingBoxQuery geoBoundingBox(double topLeftLon, double topLeftLat, double bottomRightLon, double bottomRightLat) {
        return new GeoBoundingBoxQuery(topLeftLon, topLeftLat, bottomRightLon, bottomRightLat);
    }

    public static GeoDistanceQuery geoDistance(double locationLon, double locationLat, String distance) {
        return new GeoDistanceQuery(locationLon, locationLat, distance);
    }
}

