/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.analytics;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.document.json.JsonValue;
import com.couchbase.client.java.query.N1qlParams;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@InterfaceStability.Committed
@InterfaceAudience.Public
public class AnalyticsParams
implements Serializable {
    private static final long serialVersionUID = 8888370260267213836L;
    private String serverSideTimeout;
    private String clientContextId;
    private Map<String, Object> rawParams;
    private boolean pretty = false;
    private int priority = 0;

    private AnalyticsParams() {
    }

    public void injectParams(JsonObject queryJson) {
        if (this.serverSideTimeout != null) {
            queryJson.put("timeout", this.serverSideTimeout);
        }
        if (this.clientContextId != null) {
            queryJson.put("client_context_id", this.clientContextId);
        }
        if (this.pretty) {
            queryJson.put("pretty", true);
        }
        if (this.rawParams != null) {
            for (Map.Entry<String, Object> entry : this.rawParams.entrySet()) {
                queryJson.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public AnalyticsParams withContextId(String clientContextId) {
        this.clientContextId = clientContextId;
        return this;
    }

    public AnalyticsParams serverSideTimeout(long timeout, TimeUnit unit) {
        this.serverSideTimeout = N1qlParams.durationToN1qlFormat(timeout, unit);
        return this;
    }

    @InterfaceStability.Uncommitted
    public AnalyticsParams rawParam(String name, Object value) {
        if (this.rawParams == null) {
            this.rawParams = new HashMap<String, Object>();
        }
        if (!JsonValue.checkType(value)) {
            throw new IllegalArgumentException("Only JSON types are supported.");
        }
        this.rawParams.put(name, value);
        return this;
    }

    public AnalyticsParams pretty(boolean pretty) {
        this.pretty = pretty;
        return this;
    }

    public AnalyticsParams priority(boolean priority) {
        return this.priority(priority ? -1 : 0);
    }

    private AnalyticsParams priority(int priority) {
        this.priority = priority;
        return this;
    }

    @InterfaceAudience.Private
    public int priority() {
        return this.priority;
    }

    public boolean hasServerSideTimeout() {
        return this.serverSideTimeout != null;
    }

    public String clientContextId() {
        return this.clientContextId;
    }

    public static AnalyticsParams build() {
        return new AnalyticsParams();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnalyticsParams that = (AnalyticsParams)o;
        if (this.pretty != that.pretty) {
            return false;
        }
        if (this.priority != that.priority) {
            return false;
        }
        if (this.serverSideTimeout != null ? !this.serverSideTimeout.equals(that.serverSideTimeout) : that.serverSideTimeout != null) {
            return false;
        }
        if (this.clientContextId != null ? !this.clientContextId.equals(that.clientContextId) : that.clientContextId != null) {
            return false;
        }
        return this.rawParams != null ? this.rawParams.equals(that.rawParams) : that.rawParams == null;
    }

    public int hashCode() {
        int result = this.serverSideTimeout != null ? this.serverSideTimeout.hashCode() : 0;
        result = 31 * result + (this.clientContextId != null ? this.clientContextId.hashCode() : 0);
        result = 31 * result + (this.rawParams != null ? this.rawParams.hashCode() : 0);
        result = 31 * result + (this.pretty ? 1 : 0);
        result = 31 * result + this.priority;
        return result;
    }

    public String toString() {
        return "AnalyticsParams{serverSideTimeout='" + this.serverSideTimeout + '\'' + ", clientContextId='" + this.clientContextId + '\'' + ", rawParams=" + this.rawParams + ", pretty=" + this.pretty + ", priority=" + this.priority + '}';
    }
}

