/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.cluster;

import com.couchbase.client.core.ClusterFacade;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.utils.Blocking;
import com.couchbase.client.core.utils.ConnectionString;
import com.couchbase.client.java.cluster.AsyncClusterManager;
import com.couchbase.client.java.cluster.BucketSettings;
import com.couchbase.client.java.cluster.ClusterInfo;
import com.couchbase.client.java.cluster.ClusterManager;
import com.couchbase.client.java.cluster.DefaultAsyncClusterManager;
import com.couchbase.client.java.cluster.api.ClusterApiClient;
import com.couchbase.client.java.env.CouchbaseEnvironment;
import java.util.List;
import java.util.concurrent.TimeUnit;
import rx.Observable;

public class DefaultClusterManager
implements ClusterManager {
    private static final TimeUnit TIMEOUT_UNIT = TimeUnit.MILLISECONDS;
    private final DefaultAsyncClusterManager asyncClusterManager;
    private final long timeout;

    DefaultClusterManager(String username, String password, ConnectionString connectionString, CouchbaseEnvironment environment, ClusterFacade core) {
        this.asyncClusterManager = DefaultAsyncClusterManager.create(username, password, connectionString, environment, core);
        this.timeout = environment.managementTimeout();
    }

    public static DefaultClusterManager create(String username, String password, ConnectionString connectionString, CouchbaseEnvironment environment, ClusterFacade core) {
        return new DefaultClusterManager(username, password, connectionString, environment, core);
    }

    @Override
    public AsyncClusterManager async() {
        return this.asyncClusterManager;
    }

    @Override
    public ClusterInfo info() {
        return this.info(this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public ClusterInfo info(long timeout, TimeUnit timeUnit) {
        return (ClusterInfo)Blocking.blockForSingle((Observable)this.asyncClusterManager.info().single(), (long)timeout, (TimeUnit)timeUnit);
    }

    @Override
    public List<BucketSettings> getBuckets() {
        return this.getBuckets(this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public List<BucketSettings> getBuckets(long timeout, TimeUnit timeUnit) {
        return (List)Blocking.blockForSingle((Observable)this.asyncClusterManager.getBuckets().toList(), (long)timeout, (TimeUnit)timeUnit);
    }

    @Override
    public BucketSettings getBucket(String name) {
        return this.getBucket(name, this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public BucketSettings getBucket(String name, long timeout, TimeUnit timeUnit) {
        return (BucketSettings)Blocking.blockForSingle((Observable)this.asyncClusterManager.getBucket(name).singleOrDefault(null), (long)timeout, (TimeUnit)timeUnit);
    }

    @Override
    public Boolean hasBucket(String name) {
        return this.hasBucket(name, this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public Boolean hasBucket(String name, long timeout, TimeUnit timeUnit) {
        return (Boolean)Blocking.blockForSingle((Observable)this.asyncClusterManager.hasBucket(name).single(), (long)timeout, (TimeUnit)timeUnit);
    }

    @Override
    public BucketSettings insertBucket(BucketSettings settings) {
        return this.insertBucket(settings, this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public BucketSettings insertBucket(BucketSettings settings, long timeout, TimeUnit timeUnit) {
        return (BucketSettings)Blocking.blockForSingle((Observable)this.asyncClusterManager.insertBucket(settings).single(), (long)timeout, (TimeUnit)timeUnit);
    }

    @Override
    public BucketSettings updateBucket(BucketSettings settings) {
        return this.updateBucket(settings, this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public BucketSettings updateBucket(BucketSettings settings, long timeout, TimeUnit timeUnit) {
        return (BucketSettings)Blocking.blockForSingle((Observable)this.asyncClusterManager.updateBucket(settings).single(), (long)timeout, (TimeUnit)timeUnit);
    }

    @Override
    public Boolean removeBucket(String name) {
        return this.removeBucket(name, this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public Boolean removeBucket(String name, long timeout, TimeUnit timeUnit) {
        return (Boolean)Blocking.blockForSingle((Observable)this.asyncClusterManager.removeBucket(name).single(), (long)timeout, (TimeUnit)timeUnit);
    }

    @Override
    @InterfaceStability.Experimental
    public ClusterApiClient apiClient() {
        return new ClusterApiClient(this.asyncClusterManager.username, this.asyncClusterManager.password, this.asyncClusterManager.core, this.timeout, TIMEOUT_UNIT);
    }
}

