/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.transcoder;

import com.couchbase.client.core.lang.Tuple2;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.message.ResponseStatus;
import com.couchbase.client.core.message.kv.MutationToken;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.deps.io.netty.util.CharsetUtil;
import com.couchbase.client.java.document.Document;
import com.couchbase.client.java.error.TranscodingException;
import com.couchbase.client.java.transcoder.Transcoder;

public abstract class AbstractTranscoder<D extends Document<T>, T>
implements Transcoder<D, T> {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(AbstractTranscoder.class);

    @Override
    public D decode(String id, ByteBuf content, long cas, int expiry, int flags, ResponseStatus status) {
        try {
            D result = this.doDecode(id, content, cas, expiry, flags, status);
            if (content != null && this.shouldAutoReleaseOnDecode()) {
                content.release();
            }
            return result;
        }
        catch (Exception ex) {
            LOGGER.warn("Decoding of document with {} failed. exception: {}, id: \"{}\", cas: {}, expiry: {}, flags: {}, status: {}, content size: {} bytes, content: \"{}\"", new Object[]{this.getClass().getSimpleName(), ex.getMessage(), id, cas, expiry, "0x" + Integer.toHexString(flags), status, content == null ? 0 : content.readableBytes(), content == null ? "null" : content.toString(CharsetUtil.UTF_8)});
            if (content != null && this.shouldAutoReleaseOnError()) {
                content.release();
            }
            if (ex instanceof TranscodingException) {
                throw (TranscodingException)((Object)ex);
            }
            throw new TranscodingException("Could not decode document with ID " + id, ex);
        }
    }

    @Override
    public Tuple2<ByteBuf, Integer> encode(D document) {
        try {
            return this.doEncode(document);
        }
        catch (Exception ex) {
            if (ex instanceof TranscodingException) {
                throw (TranscodingException)((Object)ex);
            }
            throw new TranscodingException("Could not encode document with ID " + document.id(), ex);
        }
    }

    protected abstract D doDecode(String var1, ByteBuf var2, long var3, int var5, int var6, ResponseStatus var7) throws Exception;

    protected abstract Tuple2<ByteBuf, Integer> doEncode(D var1) throws Exception;

    protected boolean shouldAutoReleaseOnDecode() {
        return true;
    }

    protected boolean shouldAutoReleaseOnError() {
        return true;
    }

    @Override
    public D newDocument(String id, int expiry, T content, long cas, MutationToken mutationToken) {
        LOGGER.warn("This transcoder ({}) does not support mutation tokens - this method is a stub and needs to be implemented on custom transcoders.", (Object)this.getClass().getSimpleName());
        return this.newDocument(id, expiry, content, cas);
    }
}

