/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.util.retry;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.lang.Tuple;
import com.couchbase.client.core.lang.Tuple2;
import com.couchbase.client.core.time.Delay;
import com.couchbase.client.java.util.retry.RetryWhenFunction;
import com.couchbase.client.java.util.retry.RetryWithDelayHandler;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.functions.Func1;
import rx.functions.Func2;

@InterfaceStability.Committed
@InterfaceAudience.Public
public class Retry {
    public static final Delay DEFAULT_DELAY = Delay.fixed((long)1L, (TimeUnit)TimeUnit.MILLISECONDS);

    public static <T> Observable<T> wrapForRetry(Observable<T> source, int maxAttempts) {
        return Retry.wrapForRetry(source, new RetryWithDelayHandler(maxAttempts, DEFAULT_DELAY));
    }

    public static <T> Observable<T> wrapForRetry(Observable<T> source, int maxAttempts, Delay retryDelay) {
        return Retry.wrapForRetry(source, new RetryWithDelayHandler(maxAttempts, retryDelay));
    }

    public static <T> Observable<T> wrapForRetry(Observable<T> source, RetryWithDelayHandler handler) {
        return source.retryWhen((Func1)new RetryWhenFunction(handler));
    }

    protected static Observable<Tuple2<Integer, Throwable>> errorsWithAttempts(Observable<? extends Throwable> errors, int expectedAttempts) {
        return errors.zipWith(Observable.range((int)1, (int)expectedAttempts), (Func2)new Func2<Throwable, Integer, Tuple2<Integer, Throwable>>(){

            public Tuple2<Integer, Throwable> call(Throwable error, Integer attempt) {
                return Tuple.create((Object)attempt, (Object)error);
            }
        });
    }
}

