/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.subdoc;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.message.kv.subdoc.multi.Lookup;
import com.couchbase.client.java.subdoc.AsyncLookupInBuilder;
import com.couchbase.client.java.subdoc.DocumentFragment;
import com.couchbase.client.java.util.Blocking;
import java.util.concurrent.TimeUnit;

@InterfaceStability.Experimental
@InterfaceAudience.Public
public class LookupInBuilder {
    private final AsyncLookupInBuilder async;
    private final long defaultTimeout;
    private final TimeUnit defaultTimeUnit;

    @InterfaceAudience.Private
    public LookupInBuilder(AsyncLookupInBuilder async, long defaultTimeout, TimeUnit defaultTimeUnit) {
        this.async = async;
        this.defaultTimeout = defaultTimeout;
        this.defaultTimeUnit = defaultTimeUnit;
    }

    public DocumentFragment<Lookup> doLookup() {
        return this.doLookup(this.defaultTimeout, this.defaultTimeUnit);
    }

    public DocumentFragment<Lookup> doLookup(long timeout, TimeUnit timeUnit) {
        return Blocking.blockForSingle(this.async.doLookup(), timeout, timeUnit);
    }

    public LookupInBuilder get(String path) {
        this.async.get(path);
        return this;
    }

    public LookupInBuilder exists(String path) {
        this.async.exists(path);
        return this;
    }

    public String toString() {
        return this.async.toString();
    }
}

