/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.bucket;

import com.couchbase.client.core.ClusterFacade;
import com.couchbase.client.java.bucket.AsyncBucketManager;
import com.couchbase.client.java.bucket.BucketInfo;
import com.couchbase.client.java.bucket.BucketManager;
import com.couchbase.client.java.bucket.DefaultAsyncBucketManager;
import com.couchbase.client.java.env.CouchbaseEnvironment;
import com.couchbase.client.java.query.util.IndexInfo;
import com.couchbase.client.java.util.Blocking;
import com.couchbase.client.java.view.DesignDocument;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class DefaultBucketManager
implements BucketManager {
    private static final TimeUnit TIMEOUT_UNIT = TimeUnit.MILLISECONDS;
    private final AsyncBucketManager asyncBucketManager;
    private final long timeout;

    DefaultBucketManager(CouchbaseEnvironment environment, String bucket, String password, ClusterFacade core) {
        this.asyncBucketManager = DefaultAsyncBucketManager.create(bucket, password, core);
        this.timeout = environment.managementTimeout();
    }

    public static DefaultBucketManager create(CouchbaseEnvironment environment, String bucket, String password, ClusterFacade core) {
        return new DefaultBucketManager(environment, bucket, password, core);
    }

    @Override
    public AsyncBucketManager async() {
        return this.asyncBucketManager;
    }

    @Override
    public BucketInfo info() {
        return this.info(this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public Boolean flush() {
        return this.flush(this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public List<DesignDocument> getDesignDocuments() {
        return this.getDesignDocuments(this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public List<DesignDocument> getDesignDocuments(boolean development) {
        return this.getDesignDocuments(development, this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public DesignDocument getDesignDocument(String name) {
        return this.getDesignDocument(name, this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public DesignDocument getDesignDocument(String name, boolean development) {
        return this.getDesignDocument(name, development, this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public DesignDocument insertDesignDocument(DesignDocument designDocument) {
        return this.insertDesignDocument(designDocument, this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public DesignDocument insertDesignDocument(DesignDocument designDocument, boolean development) {
        return this.insertDesignDocument(designDocument, development, this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public DesignDocument upsertDesignDocument(DesignDocument designDocument) {
        return this.upsertDesignDocument(designDocument, this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public DesignDocument upsertDesignDocument(DesignDocument designDocument, boolean development) {
        return this.upsertDesignDocument(designDocument, development, this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public Boolean removeDesignDocument(String name) {
        return this.removeDesignDocument(name, this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public Boolean removeDesignDocument(String name, boolean development) {
        return this.removeDesignDocument(name, development, this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public DesignDocument publishDesignDocument(String name) {
        return this.publishDesignDocument(name, this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public DesignDocument publishDesignDocument(String name, boolean overwrite) {
        return this.publishDesignDocument(name, overwrite, this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public BucketInfo info(long timeout, TimeUnit timeUnit) {
        return (BucketInfo)Blocking.blockForSingle(this.asyncBucketManager.info().single(), timeout, timeUnit);
    }

    @Override
    public Boolean flush(long timeout, TimeUnit timeUnit) {
        return (Boolean)Blocking.blockForSingle(this.asyncBucketManager.flush().single(), timeout, timeUnit);
    }

    @Override
    public List<DesignDocument> getDesignDocuments(long timeout, TimeUnit timeUnit) {
        return (List)Blocking.blockForSingle(this.asyncBucketManager.getDesignDocuments().toList(), timeout, timeUnit);
    }

    @Override
    public List<DesignDocument> getDesignDocuments(boolean development, long timeout, TimeUnit timeUnit) {
        return (List)Blocking.blockForSingle(this.asyncBucketManager.getDesignDocuments(development).toList(), timeout, timeUnit);
    }

    @Override
    public DesignDocument getDesignDocument(String name, long timeout, TimeUnit timeUnit) {
        return (DesignDocument)Blocking.blockForSingle(this.asyncBucketManager.getDesignDocument(name).singleOrDefault(null), timeout, timeUnit);
    }

    @Override
    public DesignDocument getDesignDocument(String name, boolean development, long timeout, TimeUnit timeUnit) {
        return (DesignDocument)Blocking.blockForSingle(this.asyncBucketManager.getDesignDocument(name, development).singleOrDefault(null), timeout, timeUnit);
    }

    @Override
    public DesignDocument insertDesignDocument(DesignDocument designDocument, long timeout, TimeUnit timeUnit) {
        return (DesignDocument)Blocking.blockForSingle(this.asyncBucketManager.insertDesignDocument(designDocument).single(), timeout, timeUnit);
    }

    @Override
    public DesignDocument insertDesignDocument(DesignDocument designDocument, boolean development, long timeout, TimeUnit timeUnit) {
        return (DesignDocument)Blocking.blockForSingle(this.asyncBucketManager.insertDesignDocument(designDocument, development).single(), timeout, timeUnit);
    }

    @Override
    public DesignDocument upsertDesignDocument(DesignDocument designDocument, long timeout, TimeUnit timeUnit) {
        return (DesignDocument)Blocking.blockForSingle(this.asyncBucketManager.upsertDesignDocument(designDocument).single(), timeout, timeUnit);
    }

    @Override
    public DesignDocument upsertDesignDocument(DesignDocument designDocument, boolean development, long timeout, TimeUnit timeUnit) {
        return (DesignDocument)Blocking.blockForSingle(this.asyncBucketManager.upsertDesignDocument(designDocument, development).single(), timeout, timeUnit);
    }

    @Override
    public Boolean removeDesignDocument(String name, long timeout, TimeUnit timeUnit) {
        return (Boolean)Blocking.blockForSingle(this.asyncBucketManager.removeDesignDocument(name).single(), timeout, timeUnit);
    }

    @Override
    public Boolean removeDesignDocument(String name, boolean development, long timeout, TimeUnit timeUnit) {
        return (Boolean)Blocking.blockForSingle(this.asyncBucketManager.removeDesignDocument(name, development).single(), timeout, timeUnit);
    }

    @Override
    public DesignDocument publishDesignDocument(String name, long timeout, TimeUnit timeUnit) {
        return (DesignDocument)Blocking.blockForSingle(this.asyncBucketManager.publishDesignDocument(name).single(), timeout, timeUnit);
    }

    @Override
    public DesignDocument publishDesignDocument(String name, boolean overwrite, long timeout, TimeUnit timeUnit) {
        return (DesignDocument)Blocking.blockForSingle(this.asyncBucketManager.publishDesignDocument(name, overwrite).single(), timeout, timeUnit);
    }

    @Override
    public List<IndexInfo> listIndexes() {
        return this.listIndexes(this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public List<IndexInfo> listIndexes(long timeout, TimeUnit timeUnit) {
        return (List)Blocking.blockForSingle(this.asyncBucketManager.listIndexes().toList(), timeout, timeUnit);
    }

    @Override
    public boolean createPrimaryIndex(boolean ignoreIfExist, boolean defer) {
        return this.createPrimaryIndex(ignoreIfExist, defer, this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public boolean createPrimaryIndex(boolean ignoreIfExist, boolean defer, long timeout, TimeUnit timeUnit) {
        return Blocking.blockForSingle(this.asyncBucketManager.createPrimaryIndex(ignoreIfExist, defer), timeout, timeUnit);
    }

    private boolean createIndex(String indexName, boolean ignoreIfExist, boolean defer, long timeout, TimeUnit timeUnit, Object ... fields) {
        return Blocking.blockForSingle(this.asyncBucketManager.createIndex(indexName, ignoreIfExist, defer, fields), timeout, timeUnit);
    }

    @Override
    public boolean createIndex(String indexName, boolean ignoreIfExist, boolean defer, Object ... fields) {
        return this.createIndex(indexName, ignoreIfExist, defer, this.timeout, TIMEOUT_UNIT, fields);
    }

    @Override
    public boolean createIndex(String indexName, List<Object> fields, boolean ignoreIfExist, boolean defer) {
        return this.createIndex(indexName, ignoreIfExist, defer, this.timeout, TIMEOUT_UNIT, fields.toArray());
    }

    @Override
    public boolean createIndex(String indexName, List<Object> fields, boolean ignoreIfExist, boolean defer, long timeout, TimeUnit timeUnit) {
        return this.createIndex(indexName, ignoreIfExist, defer, timeout, timeUnit, fields.toArray());
    }

    @Override
    public boolean dropPrimaryIndex(boolean ignoreIfNotExist) {
        return this.dropPrimaryIndex(ignoreIfNotExist, this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public boolean dropPrimaryIndex(boolean ignoreIfNotExist, long timeout, TimeUnit timeUnit) {
        return Blocking.blockForSingle(this.asyncBucketManager.dropPrimaryIndex(ignoreIfNotExist), timeout, timeUnit);
    }

    @Override
    public boolean dropIndex(String name, boolean ignoreIfNotExist) {
        return this.dropIndex(name, ignoreIfNotExist, this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public boolean dropIndex(String name, boolean ignoreIfNotExist, long timeout, TimeUnit timeUnit) {
        return Blocking.blockForSingle(this.asyncBucketManager.dropIndex(name, ignoreIfNotExist), timeout, timeUnit);
    }

    @Override
    public List<String> buildDeferredIndexes() {
        return this.buildDeferredIndexes(this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public List<String> buildDeferredIndexes(long timeout, TimeUnit timeUnit) {
        return Blocking.blockForSingle(this.asyncBucketManager.buildDeferredIndexes(), timeout, timeUnit);
    }

    @Override
    public List<IndexInfo> watchIndexes(List<String> watchList, boolean watchPrimary, long watchTimeout, TimeUnit watchTimeUnit) {
        return (List)this.asyncBucketManager.watchIndexes(watchList, watchPrimary, watchTimeout, watchTimeUnit).toList().toBlocking().single();
    }
}

