/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.transcoder.subdoc;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.deps.com.fasterxml.jackson.core.JsonProcessingException;
import com.couchbase.client.deps.com.fasterxml.jackson.databind.ObjectMapper;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.java.error.TranscodingException;
import com.couchbase.client.java.transcoder.TranscoderUtils;
import com.couchbase.client.java.transcoder.subdoc.FragmentTranscoder;
import java.io.IOException;

@InterfaceStability.Experimental
@InterfaceAudience.Private
public class JacksonFragmentTranscoder
implements FragmentTranscoder {
    private final ObjectMapper mapper;

    public JacksonFragmentTranscoder(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public <T> T decode(ByteBuf encoded, Class<? extends T> clazz) throws TranscodingException {
        return this.decodeWithMessage(encoded, clazz, null);
    }

    @Override
    public <T> T decodeWithMessage(ByteBuf encoded, Class<? extends T> clazz, String transcodingErrorMessage) throws TranscodingException {
        try {
            if (Object.class.equals(clazz)) {
                return (T)TranscoderUtils.byteBufToGenericObject(encoded, this.mapper);
            }
            return TranscoderUtils.byteBufToClass(encoded, clazz, this.mapper);
        }
        catch (IOException e) {
            throw new TranscodingException(transcodingErrorMessage, e);
        }
    }

    @Override
    public <T> ByteBuf encode(T value) throws TranscodingException {
        return this.encodeWithMessage(value, null);
    }

    @Override
    public <T> ByteBuf encodeWithMessage(T value, String transcodingErrorMessage) throws TranscodingException {
        try {
            return Unpooled.wrappedBuffer((byte[])this.mapper.writeValueAsBytes(value));
        }
        catch (JsonProcessingException e) {
            throw new TranscodingException(transcodingErrorMessage, e);
        }
    }
}

