/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.document.subdoc;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.message.kv.MutationToken;

@InterfaceStability.Experimental
@InterfaceAudience.Public
public class DocumentFragment<T> {
    private String id;
    private String path;
    private T fragment;
    private long cas;
    private int expiry;
    private MutationToken mutationToken;

    private DocumentFragment(String id, String path, int expiry, T fragment, long cas, MutationToken mutationToken) {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("The DocumentFragment ID must not be null or empty.");
        }
        if (id.getBytes().length > 250) {
            throw new IllegalArgumentException("The DocumentFragment ID must not be larger than 250 bytes");
        }
        if (expiry < 0) {
            throw new IllegalArgumentException("The DocumentFragment expiry must not be negative.");
        }
        this.id = id;
        this.path = path;
        this.fragment = fragment;
        this.cas = cas;
        this.expiry = expiry;
        this.mutationToken = mutationToken;
    }

    @InterfaceAudience.Private
    public static <T> DocumentFragment<T> create(String id, String path, int expiry, T fragment, long cas, MutationToken mutationToken) {
        return new DocumentFragment<T>(id, path, expiry, fragment, cas, mutationToken);
    }

    public static <T> DocumentFragment<T> create(String id, String path, int expiry, T fragment) {
        return new DocumentFragment<T>(id, path, expiry, fragment, 0L, null);
    }

    public static <T> DocumentFragment<T> create(String id, String path, T fragment, long cas) {
        return new DocumentFragment<T>(id, path, 0, fragment, cas, null);
    }

    public static <T> DocumentFragment<T> create(String id, String path, int expiry, T fragment, long cas) {
        return new DocumentFragment<T>(id, path, expiry, fragment, cas, null);
    }

    public static <T> DocumentFragment<T> create(String id, String path, T fragment) {
        return new DocumentFragment<T>(id, path, 0, fragment, 0L, null);
    }

    public String id() {
        return this.id;
    }

    public String path() {
        return this.path;
    }

    public T fragment() {
        return this.fragment;
    }

    public long cas() {
        return this.cas;
    }

    public int expiry() {
        return this.expiry;
    }

    public MutationToken mutationToken() {
        return this.mutationToken;
    }

    public String toString() {
        return "DocumentFragment{id='" + this.id + '\'' + ", path='" + this.path + '\'' + ", fragment=" + this.fragment + ", cas=" + this.cas + ", expiry=" + this.expiry + ", mutationToken=" + this.mutationToken + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentFragment that = (DocumentFragment)o;
        if (this.cas != that.cas) {
            return false;
        }
        if (this.expiry != that.expiry) {
            return false;
        }
        if (!this.id.equals(that.id)) {
            return false;
        }
        if (!this.path.equals(that.path)) {
            return false;
        }
        if (this.fragment != null ? !this.fragment.equals(that.fragment) : that.fragment != null) {
            return false;
        }
        return this.mutationToken != null ? this.mutationToken.equals((Object)that.mutationToken) : that.mutationToken == null;
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + this.path.hashCode();
        result = 31 * result + (this.fragment != null ? this.fragment.hashCode() : 0);
        result = 31 * result + (int)(this.cas ^ this.cas >>> 32);
        result = 31 * result + this.expiry;
        result = 31 * result + (this.mutationToken != null ? this.mutationToken.hashCode() : 0);
        return result;
    }
}

