/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.query;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.java.document.json.JsonObject;
import java.io.Serializable;

@InterfaceStability.Experimental
@InterfaceAudience.Public
public class QueryMetrics
implements Serializable {
    private static final long serialVersionUID = -1955101433653293743L;
    public static final QueryMetrics EMPTY_METRICS = new QueryMetrics();
    public static final String NO_TIME = "0s";
    private final JsonObject rawMetrics;
    private final int resultCount;
    private final int errorCount;
    private final int warningCount;
    private final int mutationCount;
    private final long resultSize;
    private final String elapsedTime;
    private final String executionTime;

    private QueryMetrics() {
        this(JsonObject.empty());
    }

    public QueryMetrics(JsonObject rawMetrics) {
        this.rawMetrics = rawMetrics;
        this.elapsedTime = rawMetrics.getString("elapsedTime") == null ? NO_TIME : rawMetrics.getString("elapsedTime");
        this.executionTime = rawMetrics.getString("executionTime") == null ? NO_TIME : rawMetrics.getString("executionTime");
        Integer resultCount = rawMetrics.getInt("resultCount");
        this.resultCount = resultCount == null ? 0 : resultCount;
        Integer errorCount = rawMetrics.getInt("errorCount");
        this.errorCount = errorCount == null ? 0 : errorCount;
        Integer warningCount = rawMetrics.getInt("warningCount");
        this.warningCount = warningCount == null ? 0 : warningCount;
        Integer mutationCount = rawMetrics.getInt("mutationCount");
        this.mutationCount = mutationCount == null ? 0 : mutationCount;
        Long resultSize = rawMetrics.getLong("resultSize");
        this.resultSize = resultSize == null ? 0L : resultSize;
    }

    public String elapsedTime() {
        return this.elapsedTime;
    }

    public String executionTime() {
        return this.executionTime;
    }

    public int resultCount() {
        return this.resultCount;
    }

    public long resultSize() {
        return this.resultSize;
    }

    public int mutationCount() {
        return this.mutationCount;
    }

    public int errorCount() {
        return this.errorCount;
    }

    public int warningCount() {
        return this.warningCount;
    }

    public JsonObject asJsonObject() {
        return this.rawMetrics;
    }
}

