/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java;

import com.couchbase.client.core.ClusterFacade;
import com.couchbase.client.java.AsyncBucket;
import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.ConnectionString;
import com.couchbase.client.java.CouchbaseAsyncCluster;
import com.couchbase.client.java.CouchbaseBucket;
import com.couchbase.client.java.cluster.AsyncClusterManager;
import com.couchbase.client.java.cluster.ClusterManager;
import com.couchbase.client.java.cluster.DefaultClusterManager;
import com.couchbase.client.java.document.Document;
import com.couchbase.client.java.env.CouchbaseEnvironment;
import com.couchbase.client.java.env.DefaultCouchbaseEnvironment;
import com.couchbase.client.java.transcoder.Transcoder;
import com.couchbase.client.java.util.Blocking;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import rx.functions.Func1;

public class CouchbaseCluster
implements Cluster {
    private static final TimeUnit TIMEOUT_UNIT = TimeUnit.MILLISECONDS;
    private static final String DEFAULT_BUCKET = "default";
    private static final String DEFAULT_HOST = "127.0.0.1";
    private final CouchbaseAsyncCluster couchbaseAsyncCluster;
    private final CouchbaseEnvironment environment;
    private final ConnectionString connectionString;

    public static CouchbaseCluster create() {
        return CouchbaseCluster.create(DEFAULT_HOST);
    }

    public static CouchbaseCluster create(CouchbaseEnvironment environment) {
        return CouchbaseCluster.create(environment, DEFAULT_HOST);
    }

    public static CouchbaseCluster create(String ... nodes) {
        return CouchbaseCluster.create(Arrays.asList(nodes));
    }

    public static CouchbaseCluster create(List<String> nodes) {
        return new CouchbaseCluster(DefaultCouchbaseEnvironment.create(), ConnectionString.fromHostnames(nodes), false);
    }

    public static CouchbaseCluster create(CouchbaseEnvironment environment, String ... nodes) {
        return CouchbaseCluster.create(environment, Arrays.asList(nodes));
    }

    public static CouchbaseCluster create(CouchbaseEnvironment environment, List<String> nodes) {
        return new CouchbaseCluster(environment, ConnectionString.fromHostnames(nodes), true);
    }

    public static CouchbaseCluster fromConnectionString(String connectionString) {
        return new CouchbaseCluster(DefaultCouchbaseEnvironment.create(), ConnectionString.create(connectionString), false);
    }

    public static CouchbaseCluster fromConnectionString(CouchbaseEnvironment environment, String connectionString) {
        return new CouchbaseCluster(environment, ConnectionString.create(connectionString), true);
    }

    CouchbaseCluster(CouchbaseEnvironment environment, ConnectionString connectionString, boolean sharedEnvironment) {
        this.couchbaseAsyncCluster = new CouchbaseAsyncCluster(environment, connectionString, sharedEnvironment);
        this.environment = environment;
        this.connectionString = connectionString;
    }

    @Override
    public Bucket openBucket() {
        return this.openBucket(DEFAULT_BUCKET);
    }

    @Override
    public Bucket openBucket(long timeout, TimeUnit timeUnit) {
        return this.openBucket(DEFAULT_BUCKET, timeout, timeUnit);
    }

    @Override
    public Bucket openBucket(String name) {
        return this.openBucket(name, null);
    }

    @Override
    public Bucket openBucket(String name, long timeout, TimeUnit timeUnit) {
        return this.openBucket(name, null, timeout, timeUnit);
    }

    @Override
    public Bucket openBucket(String name, String password) {
        return this.openBucket(name, password, null);
    }

    @Override
    public Bucket openBucket(String name, String password, long timeout, TimeUnit timeUnit) {
        return this.openBucket(name, password, null, timeout, timeUnit);
    }

    @Override
    public Bucket openBucket(String name, String password, List<Transcoder<? extends Document, ?>> transcoders) {
        return this.openBucket(name, password, transcoders, this.environment.connectTimeout(), TIMEOUT_UNIT);
    }

    @Override
    public Bucket openBucket(final String name, final String password, List<Transcoder<? extends Document, ?>> transcoders, long timeout, TimeUnit timeUnit) {
        final ArrayList trans = transcoders == null ? new ArrayList() : transcoders;
        return (Bucket)Blocking.blockForSingle(this.couchbaseAsyncCluster.openBucket(name, password, transcoders).map((Func1)new Func1<AsyncBucket, Bucket>(){

            public Bucket call(AsyncBucket asyncBucket) {
                return new CouchbaseBucket(CouchbaseCluster.this.environment, CouchbaseCluster.this.core(), name, password, trans);
            }
        }).single(), timeout, timeUnit);
    }

    @Override
    public ClusterManager clusterManager(final String username, final String password) {
        return (ClusterManager)this.couchbaseAsyncCluster.clusterManager(username, password).map((Func1)new Func1<AsyncClusterManager, ClusterManager>(){

            public ClusterManager call(AsyncClusterManager asyncClusterManager) {
                return DefaultClusterManager.create(username, password, CouchbaseCluster.this.connectionString, CouchbaseCluster.this.environment, CouchbaseCluster.this.core());
            }
        }).toBlocking().single();
    }

    @Override
    public Boolean disconnect() {
        return this.disconnect(this.environment.disconnectTimeout(), TIMEOUT_UNIT);
    }

    @Override
    public Boolean disconnect(long timeout, TimeUnit timeUnit) {
        return (Boolean)Blocking.blockForSingle(this.couchbaseAsyncCluster.disconnect().single(), timeout, timeUnit);
    }

    @Override
    public ClusterFacade core() {
        return (ClusterFacade)this.couchbaseAsyncCluster.core().toBlocking().single();
    }
}

