/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.transcoder;

import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.deps.io.netty.buffer.Unpooled;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class TranscoderUtils {
    public static final int COMMON_FORMAT_MASK = 0xF000000;
    public static final int PRIVATE_COMMON_FLAGS = TranscoderUtils.createCommonFlags(CommonFlags.PRIVATE.ordinal());
    public static final int JSON_COMMON_FLAGS = TranscoderUtils.createCommonFlags(CommonFlags.JSON.ordinal());
    public static final int BINARY_COMMON_FLAGS = TranscoderUtils.createCommonFlags(CommonFlags.BINARY.ordinal());
    public static final int STRING_COMMON_FLAGS = TranscoderUtils.createCommonFlags(CommonFlags.STRING.ordinal());
    public static final int SERIALIZED_LEGACY_FLAGS = 1;
    public static final int BINARY_LEGACY_FLAGS = 2048;
    public static final int STRING_LEGACY_FLAGS = 0;
    public static final int JSON_LEGACY_FLAGS = 0;
    public static final int BOOLEAN_LEGACY_FLAGS = 0;
    public static final int LONG_LEGACY_FLAGS = 0;
    public static final int DOUBLE_LEGACY_FLAGS = 0;
    public static final int SERIALIZED_COMPAT_FLAGS = PRIVATE_COMMON_FLAGS | 1;
    public static final int JSON_COMPAT_FLAGS = JSON_COMMON_FLAGS | 0;
    public static final int BINARY_COMPAT_FLAGS = BINARY_COMMON_FLAGS | 0x800;
    public static final int BOOLEAN_COMPAT_FLAGS = JSON_COMMON_FLAGS | 0;
    public static final int LONG_COMPAT_FLAGS = JSON_COMMON_FLAGS | 0;
    public static final int DOUBLE_COMPAT_FLAGS = JSON_COMMON_FLAGS | 0;
    public static final int STRING_COMPAT_FLAGS = STRING_COMMON_FLAGS | 0;

    public static boolean hasCommonFlags(int flags) {
        return flags >> 24 > 0;
    }

    public static boolean hasCompressionFlags(int flags) {
        return flags >> 29 > 0;
    }

    public static boolean hasCommonFormat(int flags, int expectedCommonFlag) {
        return TranscoderUtils.hasCommonFlags(flags) && (flags & 0xF000000) == expectedCommonFlag;
    }

    public static int extractCommonFlags(int flags) {
        return flags >> 24;
    }

    public static int createCommonFlags(int flags) {
        return flags << 24;
    }

    private static boolean hasFlags(int flags, int expectedCommonFlags, int expectedLegacyFlag) {
        return TranscoderUtils.hasCommonFormat(flags, expectedCommonFlags) || flags == expectedLegacyFlag;
    }

    public static boolean hasJsonFlags(int flags) {
        return TranscoderUtils.hasFlags(flags, JSON_COMMON_FLAGS, 0);
    }

    public static boolean hasStringFlags(int flags) {
        return TranscoderUtils.hasFlags(flags, STRING_COMMON_FLAGS, 0);
    }

    public static boolean hasSerializableFlags(int flags) {
        return TranscoderUtils.hasFlags(flags, PRIVATE_COMMON_FLAGS, 1);
    }

    public static boolean hasBinaryFlags(int flags) {
        return TranscoderUtils.hasFlags(flags, BINARY_COMMON_FLAGS, 2048);
    }

    public static Serializable deserialize(ByteBuf content) throws Exception {
        byte[] serialized = new byte[content.readableBytes()];
        content.getBytes(0, serialized);
        ByteArrayInputStream bis = new ByteArrayInputStream(serialized);
        ObjectInputStream is = new ObjectInputStream(bis);
        Serializable deserialized = (Serializable)is.readObject();
        is.close();
        bis.close();
        return deserialized;
    }

    public static ByteBuf serialize(Serializable serializable) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream os = new ObjectOutputStream(bos);
        os.writeObject(serializable);
        byte[] serialized = bos.toByteArray();
        os.close();
        bos.close();
        return Unpooled.buffer().writeBytes(serialized);
    }

    public static enum CommonFlags {
        RESERVED,
        PRIVATE,
        JSON,
        BINARY,
        STRING;

    }
}

