/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.query;

import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.query.consistency.ScanConsistency;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;

public class QueryParams
implements Serializable {
    private static final long serialVersionUID = 8888370260267213830L;
    private String serverSideTimeout;
    private ScanConsistency consistency;
    private String scanWait;
    private String clientContextId;

    private QueryParams() {
    }

    public void injectParams(JsonObject queryJson) {
        if (this.serverSideTimeout != null) {
            queryJson.put("timeout", this.serverSideTimeout);
        }
        if (this.consistency != null) {
            queryJson.put("scan_consistency", this.consistency.n1ql());
        }
        if (this.scanWait != null && (ScanConsistency.REQUEST_PLUS == this.consistency || ScanConsistency.STATEMENT_PLUS == this.consistency)) {
            queryJson.put("scan_wait", this.scanWait);
        }
        if (this.clientContextId != null) {
            queryJson.put("client_context_id", this.clientContextId);
        }
    }

    private static String durationToN1qlFormat(long duration, TimeUnit unit) {
        switch (unit) {
            case NANOSECONDS: {
                return duration + "ns";
            }
            case MICROSECONDS: {
                return duration + "us";
            }
            case MILLISECONDS: {
                return duration + "ms";
            }
            case SECONDS: {
                return duration + "s";
            }
            case MINUTES: {
                return duration + "m";
            }
            case HOURS: {
                return duration + "h";
            }
        }
        return unit.toHours(duration) + "h";
    }

    public static QueryParams build() {
        return new QueryParams();
    }

    public QueryParams serverSideTimeout(long timeout, TimeUnit unit) {
        this.serverSideTimeout = QueryParams.durationToN1qlFormat(timeout, unit);
        return this;
    }

    public QueryParams withContextId(String clientContextId) {
        this.clientContextId = clientContextId;
        return this;
    }

    public QueryParams consistency(ScanConsistency consistency) {
        this.consistency = consistency;
        if (consistency == ScanConsistency.NOT_BOUNDED) {
            this.scanWait = null;
        }
        return this;
    }

    public QueryParams scanWait(long wait, TimeUnit unit) {
        this.scanWait = this.consistency == ScanConsistency.NOT_BOUNDED ? null : QueryParams.durationToN1qlFormat(wait, unit);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryParams that = (QueryParams)o;
        if (this.clientContextId != null ? !this.clientContextId.equals(that.clientContextId) : that.clientContextId != null) {
            return false;
        }
        if (this.consistency != that.consistency) {
            return false;
        }
        if (this.scanWait != null ? !this.scanWait.equals(that.scanWait) : that.scanWait != null) {
            return false;
        }
        return !(this.serverSideTimeout != null ? !this.serverSideTimeout.equals(that.serverSideTimeout) : that.serverSideTimeout != null);
    }

    public int hashCode() {
        int result = this.serverSideTimeout != null ? this.serverSideTimeout.hashCode() : 0;
        result = 31 * result + (this.consistency != null ? this.consistency.hashCode() : 0);
        result = 31 * result + (this.scanWait != null ? this.scanWait.hashCode() : 0);
        result = 31 * result + (this.clientContextId != null ? this.clientContextId.hashCode() : 0);
        return result;
    }
}

