/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.query;

import com.couchbase.client.java.query.Query;
import com.couchbase.client.java.query.QueryPlan;
import com.couchbase.client.java.query.SerializableStatement;
import com.couchbase.client.java.query.Statement;

public class PrepareStatement
implements SerializableStatement {
    public static final String PREPARE_PREFIX = "PREPARE ";
    private static final long serialVersionUID = -3951622990579947393L;
    private final SerializableStatement toPrepare;

    private PrepareStatement(Statement toPrepare) {
        this.toPrepare = toPrepare instanceof SerializableStatement ? (SerializableStatement)toPrepare : new Query.RawStatement(toPrepare.toString());
    }

    public String toString() {
        return PREPARE_PREFIX + this.toPrepare.toString();
    }

    public static PrepareStatement prepare(Statement statement) {
        if (statement instanceof QueryPlan) {
            throw new IllegalArgumentException("QueryPlan cannot be prepared again");
        }
        if (statement instanceof PrepareStatement) {
            return (PrepareStatement)statement;
        }
        return new PrepareStatement(statement);
    }

    public static PrepareStatement prepare(String statement) {
        if (statement == null) {
            throw new NullPointerException("Statement to prepare cannot be null");
        }
        if (statement.startsWith(PREPARE_PREFIX)) {
            statement = statement.replaceFirst(PREPARE_PREFIX, "");
        }
        Query.RawStatement toPrepare = new Query.RawStatement(statement);
        return new PrepareStatement(toPrepare);
    }
}

