/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.query;

import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.query.AsyncQueryRow;
import com.couchbase.client.java.query.DefaultQueryRow;
import com.couchbase.client.java.query.QueryMetrics;
import com.couchbase.client.java.query.QueryResult;
import com.couchbase.client.java.query.QueryRow;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DefaultQueryResult
implements QueryResult {
    private final boolean finalSuccess;
    private final boolean parseSuccess;
    private final List<QueryRow> allRows;
    private final Object signature;
    private final QueryMetrics info;
    private final List<JsonObject> errors;
    private final String requestId;
    private final String clientContextId;

    public DefaultQueryResult(List<AsyncQueryRow> rows, Object signature, QueryMetrics info, List<JsonObject> errors, Boolean finalSuccess, boolean parseSuccess, String requestId, String clientContextId) {
        this.requestId = requestId;
        this.clientContextId = clientContextId;
        this.parseSuccess = parseSuccess;
        this.finalSuccess = finalSuccess != null && finalSuccess != false;
        this.allRows = new ArrayList<QueryRow>(rows.size());
        for (AsyncQueryRow row : rows) {
            this.allRows.add(new DefaultQueryRow(row.value()));
        }
        this.signature = signature;
        this.errors = errors;
        this.info = info;
    }

    @Override
    public List<QueryRow> allRows() {
        return this.allRows;
    }

    @Override
    public Iterator<QueryRow> rows() {
        return this.allRows.iterator();
    }

    @Override
    public Object signature() {
        return this.signature;
    }

    @Override
    public QueryMetrics info() {
        return this.info;
    }

    @Override
    public boolean parseSuccess() {
        return this.parseSuccess;
    }

    @Override
    public List<JsonObject> errors() {
        return this.errors;
    }

    @Override
    public boolean finalSuccess() {
        return this.finalSuccess;
    }

    @Override
    public Iterator<QueryRow> iterator() {
        return this.rows();
    }

    @Override
    public String requestId() {
        return this.requestId;
    }

    @Override
    public String clientContextId() {
        return this.clientContextId;
    }
}

