/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.document;

import com.couchbase.client.java.document.AbstractDocument;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class SerializableDocument
extends AbstractDocument<Serializable>
implements Serializable {
    private static final long serialVersionUID = 2153366534711753989L;

    public static SerializableDocument create(String id) {
        return new SerializableDocument(id, 0, null, 0L);
    }

    public static SerializableDocument create(String id, Serializable content) {
        return new SerializableDocument(id, 0, content, 0L);
    }

    public static SerializableDocument create(String id, Serializable content, long cas) {
        return new SerializableDocument(id, 0, content, cas);
    }

    public static SerializableDocument create(String id, int expiry, Serializable content) {
        return new SerializableDocument(id, expiry, content, 0L);
    }

    public static SerializableDocument create(String id, int expiry, Serializable content, long cas) {
        return new SerializableDocument(id, expiry, content, cas);
    }

    public static SerializableDocument from(SerializableDocument doc, String id) {
        return SerializableDocument.create(id, doc.expiry(), (Serializable)doc.content(), doc.cas());
    }

    public static SerializableDocument from(SerializableDocument doc, Long content) {
        return SerializableDocument.create(doc.id(), doc.expiry(), content, doc.cas());
    }

    public static SerializableDocument from(SerializableDocument doc, String id, Long content) {
        return SerializableDocument.create(id, doc.expiry(), content, doc.cas());
    }

    public static SerializableDocument from(SerializableDocument doc, long cas) {
        return SerializableDocument.create(doc.id(), doc.expiry(), (Serializable)doc.content(), cas);
    }

    private SerializableDocument(String id, int expiry, Serializable content, long cas) {
        super(id, expiry, content, cas);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        this.writeToSerializedStream(stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.readFromSerializedStream(stream);
    }
}

