/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java;

import com.couchbase.client.core.ClusterFacade;
import com.couchbase.client.java.AsyncBucket;
import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.CouchbaseAsyncBucket;
import com.couchbase.client.java.PersistTo;
import com.couchbase.client.java.ReplicaMode;
import com.couchbase.client.java.ReplicateTo;
import com.couchbase.client.java.bucket.AsyncBucketManager;
import com.couchbase.client.java.bucket.BucketManager;
import com.couchbase.client.java.bucket.DefaultBucketManager;
import com.couchbase.client.java.document.Document;
import com.couchbase.client.java.document.JsonDocument;
import com.couchbase.client.java.document.JsonLongDocument;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.env.CouchbaseEnvironment;
import com.couchbase.client.java.query.AsyncQueryResult;
import com.couchbase.client.java.query.AsyncQueryRow;
import com.couchbase.client.java.query.DefaultQueryResult;
import com.couchbase.client.java.query.Query;
import com.couchbase.client.java.query.QueryMetrics;
import com.couchbase.client.java.query.QueryPlan;
import com.couchbase.client.java.query.QueryResult;
import com.couchbase.client.java.query.Statement;
import com.couchbase.client.java.transcoder.Transcoder;
import com.couchbase.client.java.util.Blocking;
import com.couchbase.client.java.view.AsyncSpatialViewResult;
import com.couchbase.client.java.view.AsyncViewResult;
import com.couchbase.client.java.view.DefaultSpatialViewResult;
import com.couchbase.client.java.view.DefaultViewResult;
import com.couchbase.client.java.view.SpatialViewQuery;
import com.couchbase.client.java.view.SpatialViewResult;
import com.couchbase.client.java.view.ViewQuery;
import com.couchbase.client.java.view.ViewResult;
import java.util.List;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.functions.Func1;
import rx.functions.Func5;

public class CouchbaseBucket
implements Bucket {
    private static final TimeUnit TIMEOUT_UNIT = TimeUnit.MILLISECONDS;
    private final AsyncBucket asyncBucket;
    private final CouchbaseEnvironment environment;
    private final long kvTimeout;
    private final String name;
    private final String password;
    private final ClusterFacade core;

    public CouchbaseBucket(CouchbaseEnvironment env, ClusterFacade core, String name, String password, List<Transcoder<? extends Document, ?>> customTranscoders) {
        this.asyncBucket = new CouchbaseAsyncBucket(core, env, name, password, customTranscoders);
        this.environment = env;
        this.kvTimeout = env.kvTimeout();
        this.name = name;
        this.password = password;
        this.core = core;
    }

    @Override
    public AsyncBucket async() {
        return this.asyncBucket;
    }

    @Override
    public String name() {
        return this.asyncBucket.name();
    }

    @Override
    public ClusterFacade core() {
        return (ClusterFacade)this.asyncBucket.core().toBlocking().single();
    }

    @Override
    public JsonDocument get(String id) {
        return this.get(id, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public JsonDocument get(String id, long timeout, TimeUnit timeUnit) {
        return (JsonDocument)Blocking.blockForSingle(this.asyncBucket.get(id).singleOrDefault(null), timeout, timeUnit);
    }

    @Override
    public <D extends Document<?>> D get(D document) {
        return this.get(document, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> D get(D document, long timeout, TimeUnit timeUnit) {
        return (D)((Document)Blocking.blockForSingle(this.asyncBucket.get(document).singleOrDefault(null), timeout, timeUnit));
    }

    @Override
    public <D extends Document<?>> D get(String id, Class<D> target) {
        return this.get(id, target, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> D get(String id, Class<D> target, long timeout, TimeUnit timeUnit) {
        return (D)((Document)Blocking.blockForSingle(this.asyncBucket.get(id, target).singleOrDefault(null), timeout, timeUnit));
    }

    @Override
    public List<JsonDocument> getFromReplica(String id, ReplicaMode type) {
        return this.getFromReplica((Document)((Object)id), type, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public List<JsonDocument> getFromReplica(String id, ReplicaMode type, long timeout, TimeUnit timeUnit) {
        return (List)Blocking.blockForSingle(this.asyncBucket.getFromReplica(id, type).toList(), timeout, timeUnit);
    }

    @Override
    public <D extends Document<?>> List<D> getFromReplica(D document, ReplicaMode type) {
        return this.getFromReplica(document, type, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> List<D> getFromReplica(D document, ReplicaMode type, long timeout, TimeUnit timeUnit) {
        return (List)Blocking.blockForSingle(this.asyncBucket.getFromReplica(document, type).toList(), timeout, timeUnit);
    }

    @Override
    public <D extends Document<?>> List<D> getFromReplica(String id, ReplicaMode type, Class<D> target) {
        return this.getFromReplica(id, type, target, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> List<D> getFromReplica(String id, ReplicaMode type, Class<D> target, long timeout, TimeUnit timeUnit) {
        return (List)Blocking.blockForSingle(this.asyncBucket.getFromReplica(id, type, target).toList(), timeout, timeUnit);
    }

    @Override
    public JsonDocument getAndLock(String id, int lockTime) {
        return this.getAndLock(id, lockTime, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public JsonDocument getAndLock(String id, int lockTime, long timeout, TimeUnit timeUnit) {
        return (JsonDocument)Blocking.blockForSingle(this.asyncBucket.getAndLock(id, lockTime).singleOrDefault(null), timeout, timeUnit);
    }

    @Override
    public <D extends Document<?>> D getAndLock(D document, int lockTime) {
        return this.getAndLock(document, lockTime, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> D getAndLock(D document, int lockTime, long timeout, TimeUnit timeUnit) {
        return (D)((Document)Blocking.blockForSingle(this.asyncBucket.getAndLock(document, lockTime).singleOrDefault(null), timeout, timeUnit));
    }

    @Override
    public <D extends Document<?>> D getAndLock(String id, int lockTime, Class<D> target) {
        return this.getAndLock(id, lockTime, target, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> D getAndLock(String id, int lockTime, Class<D> target, long timeout, TimeUnit timeUnit) {
        return (D)((Document)Blocking.blockForSingle(this.asyncBucket.getAndLock(id, lockTime, target).singleOrDefault(null), timeout, timeUnit));
    }

    @Override
    public JsonDocument getAndTouch(String id, int expiry) {
        return this.getAndTouch(id, expiry, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public JsonDocument getAndTouch(String id, int expiry, long timeout, TimeUnit timeUnit) {
        return (JsonDocument)Blocking.blockForSingle(this.asyncBucket.getAndTouch(id, expiry).singleOrDefault(null), timeout, timeUnit);
    }

    @Override
    public <D extends Document<?>> D getAndTouch(D document) {
        return this.getAndTouch(document, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> D getAndTouch(D document, long timeout, TimeUnit timeUnit) {
        return (D)((Document)Blocking.blockForSingle(this.asyncBucket.getAndTouch(document).singleOrDefault(null), timeout, timeUnit));
    }

    @Override
    public <D extends Document<?>> D getAndTouch(String id, int expiry, Class<D> target) {
        return this.getAndTouch(id, expiry, target, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> D getAndTouch(String id, int expiry, Class<D> target, long timeout, TimeUnit timeUnit) {
        return (D)((Document)Blocking.blockForSingle(this.asyncBucket.getAndTouch(id, expiry, target).singleOrDefault(null), timeout, timeUnit));
    }

    @Override
    public <D extends Document<?>> D insert(D document) {
        return this.insert(document, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> D insert(D document, long timeout, TimeUnit timeUnit) {
        return (D)((Document)Blocking.blockForSingle(this.asyncBucket.insert(document).single(), timeout, timeUnit));
    }

    @Override
    public <D extends Document<?>> D insert(D document, PersistTo persistTo, ReplicateTo replicateTo) {
        return this.insert(document, persistTo, replicateTo, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> D insert(D document, PersistTo persistTo, ReplicateTo replicateTo, long timeout, TimeUnit timeUnit) {
        return (D)((Document)Blocking.blockForSingle(this.asyncBucket.insert(document, persistTo, replicateTo).single(), timeout, timeUnit));
    }

    @Override
    public <D extends Document<?>> D insert(D document, PersistTo persistTo) {
        return this.insert(document, persistTo, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> D insert(D document, PersistTo persistTo, long timeout, TimeUnit timeUnit) {
        return (D)((Document)Blocking.blockForSingle(this.asyncBucket.insert(document, persistTo).single(), timeout, timeUnit));
    }

    @Override
    public <D extends Document<?>> D insert(D document, ReplicateTo replicateTo) {
        return this.insert(document, replicateTo, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> D insert(D document, ReplicateTo replicateTo, long timeout, TimeUnit timeUnit) {
        return (D)((Document)Blocking.blockForSingle(this.asyncBucket.insert(document, replicateTo).single(), timeout, timeUnit));
    }

    @Override
    public <D extends Document<?>> D upsert(D document) {
        return this.upsert(document, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> D upsert(D document, long timeout, TimeUnit timeUnit) {
        return (D)((Document)Blocking.blockForSingle(this.asyncBucket.upsert(document).single(), timeout, timeUnit));
    }

    @Override
    public <D extends Document<?>> D upsert(D document, PersistTo persistTo, ReplicateTo replicateTo) {
        return this.upsert(document, persistTo, replicateTo, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> D upsert(D document, PersistTo persistTo, ReplicateTo replicateTo, long timeout, TimeUnit timeUnit) {
        return (D)((Document)Blocking.blockForSingle(this.asyncBucket.upsert(document, persistTo, replicateTo).single(), timeout, timeUnit));
    }

    @Override
    public <D extends Document<?>> D upsert(D document, PersistTo persistTo) {
        return this.upsert(document, persistTo, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> D upsert(D document, PersistTo persistTo, long timeout, TimeUnit timeUnit) {
        return (D)((Document)Blocking.blockForSingle(this.asyncBucket.upsert(document, persistTo).single(), timeout, timeUnit));
    }

    @Override
    public <D extends Document<?>> D upsert(D document, ReplicateTo replicateTo) {
        return this.upsert(document, replicateTo, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> D upsert(D document, ReplicateTo replicateTo, long timeout, TimeUnit timeUnit) {
        return (D)((Document)Blocking.blockForSingle(this.asyncBucket.upsert(document, replicateTo).single(), timeout, timeUnit));
    }

    @Override
    public <D extends Document<?>> D replace(D document) {
        return this.replace(document, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> D replace(D document, long timeout, TimeUnit timeUnit) {
        return (D)((Document)Blocking.blockForSingle(this.asyncBucket.replace(document).single(), timeout, timeUnit));
    }

    @Override
    public <D extends Document<?>> D replace(D document, PersistTo persistTo, ReplicateTo replicateTo) {
        return this.replace(document, persistTo, replicateTo, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> D replace(D document, PersistTo persistTo, ReplicateTo replicateTo, long timeout, TimeUnit timeUnit) {
        return (D)((Document)Blocking.blockForSingle(this.asyncBucket.replace(document, persistTo, replicateTo).single(), timeout, timeUnit));
    }

    @Override
    public <D extends Document<?>> D replace(D document, PersistTo persistTo) {
        return this.replace(document, persistTo, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> D replace(D document, PersistTo persistTo, long timeout, TimeUnit timeUnit) {
        return (D)((Document)Blocking.blockForSingle(this.asyncBucket.replace(document, persistTo).single(), timeout, timeUnit));
    }

    @Override
    public <D extends Document<?>> D replace(D document, ReplicateTo replicateTo) {
        return this.replace(document, replicateTo, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> D replace(D document, ReplicateTo replicateTo, long timeout, TimeUnit timeUnit) {
        return (D)((Document)Blocking.blockForSingle(this.asyncBucket.replace(document, replicateTo).single(), timeout, timeUnit));
    }

    @Override
    public <D extends Document<?>> D remove(D document) {
        return this.remove(document, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> D remove(D document, PersistTo persistTo, ReplicateTo replicateTo) {
        return this.remove(document, persistTo, replicateTo, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> D remove(D document, PersistTo persistTo) {
        return this.remove(document, persistTo, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> D remove(D document, ReplicateTo replicateTo) {
        return this.remove(document, replicateTo, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> D remove(D document, long timeout, TimeUnit timeUnit) {
        return (D)((Document)Blocking.blockForSingle(this.asyncBucket.remove(document).singleOrDefault(null), timeout, timeUnit));
    }

    @Override
    public <D extends Document<?>> D remove(D document, PersistTo persistTo, ReplicateTo replicateTo, long timeout, TimeUnit timeUnit) {
        return (D)((Document)Blocking.blockForSingle(this.asyncBucket.remove(document, persistTo, replicateTo).singleOrDefault(null), timeout, timeUnit));
    }

    @Override
    public <D extends Document<?>> D remove(D document, PersistTo persistTo, long timeout, TimeUnit timeUnit) {
        return (D)((Document)Blocking.blockForSingle(this.asyncBucket.remove(document, persistTo).singleOrDefault(null), timeout, timeUnit));
    }

    @Override
    public <D extends Document<?>> D remove(D document, ReplicateTo replicateTo, long timeout, TimeUnit timeUnit) {
        return (D)((Document)Blocking.blockForSingle(this.asyncBucket.remove(document, replicateTo).singleOrDefault(null), timeout, timeUnit));
    }

    @Override
    public JsonDocument remove(String id) {
        return this.remove(id, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public JsonDocument remove(String id, PersistTo persistTo, ReplicateTo replicateTo) {
        return this.remove(id, persistTo, replicateTo, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public JsonDocument remove(String id, PersistTo persistTo) {
        return this.remove(id, persistTo, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public JsonDocument remove(String id, ReplicateTo replicateTo) {
        return this.remove(id, replicateTo, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public JsonDocument remove(String id, long timeout, TimeUnit timeUnit) {
        return (JsonDocument)Blocking.blockForSingle(this.asyncBucket.remove(id).singleOrDefault(null), timeout, timeUnit);
    }

    @Override
    public JsonDocument remove(String id, PersistTo persistTo, ReplicateTo replicateTo, long timeout, TimeUnit timeUnit) {
        return (JsonDocument)Blocking.blockForSingle(this.asyncBucket.remove(id, persistTo, replicateTo).singleOrDefault(null), timeout, timeUnit);
    }

    @Override
    public JsonDocument remove(String id, PersistTo persistTo, long timeout, TimeUnit timeUnit) {
        return (JsonDocument)Blocking.blockForSingle(this.asyncBucket.remove(id, persistTo).singleOrDefault(null), timeout, timeUnit);
    }

    @Override
    public JsonDocument remove(String id, ReplicateTo replicateTo, long timeout, TimeUnit timeUnit) {
        return (JsonDocument)Blocking.blockForSingle(this.asyncBucket.remove(id, replicateTo).singleOrDefault(null), timeout, timeUnit);
    }

    @Override
    public <D extends Document<?>> D remove(String id, Class<D> target) {
        return this.remove(id, target, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> D remove(String id, PersistTo persistTo, ReplicateTo replicateTo, Class<D> target) {
        return this.remove(id, persistTo, replicateTo, target, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> D remove(String id, PersistTo persistTo, Class<D> target) {
        return this.remove(id, persistTo, target, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> D remove(String id, ReplicateTo replicateTo, Class<D> target) {
        return this.remove(id, replicateTo, target, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> D remove(String id, Class<D> target, long timeout, TimeUnit timeUnit) {
        return (D)((Document)Blocking.blockForSingle(this.asyncBucket.remove(id, target).singleOrDefault(null), timeout, timeUnit));
    }

    @Override
    public <D extends Document<?>> D remove(String id, PersistTo persistTo, ReplicateTo replicateTo, Class<D> target, long timeout, TimeUnit timeUnit) {
        return (D)((Document)Blocking.blockForSingle(this.asyncBucket.remove(id, persistTo, replicateTo, target).singleOrDefault(null), timeout, timeUnit));
    }

    @Override
    public <D extends Document<?>> D remove(String id, PersistTo persistTo, Class<D> target, long timeout, TimeUnit timeUnit) {
        return (D)((Document)Blocking.blockForSingle(this.asyncBucket.remove(id, persistTo, target).singleOrDefault(null), timeout, timeUnit));
    }

    @Override
    public <D extends Document<?>> D remove(String id, ReplicateTo replicateTo, Class<D> target, long timeout, TimeUnit timeUnit) {
        return (D)((Document)Blocking.blockForSingle(this.asyncBucket.remove(id, replicateTo, target).singleOrDefault(null), timeout, timeUnit));
    }

    @Override
    public ViewResult query(ViewQuery query) {
        return this.query(query, this.environment.viewTimeout(), TIMEOUT_UNIT);
    }

    @Override
    public QueryResult query(Statement statement) {
        return this.query(statement, this.environment.queryTimeout(), TIMEOUT_UNIT);
    }

    @Override
    public QueryResult query(Query query) {
        return this.query(query, this.environment.queryTimeout(), TIMEOUT_UNIT);
    }

    @Override
    public QueryPlan prepare(String statement) {
        return this.prepare(statement, this.environment.queryTimeout(), TIMEOUT_UNIT);
    }

    @Override
    public QueryPlan prepare(Statement statement) {
        return this.prepare(statement, this.environment.queryTimeout(), TIMEOUT_UNIT);
    }

    @Override
    public SpatialViewResult query(SpatialViewQuery query) {
        return this.query(query, this.environment.queryTimeout(), TIMEOUT_UNIT);
    }

    @Override
    public ViewResult query(ViewQuery query, long timeout, TimeUnit timeUnit) {
        return (ViewResult)Blocking.blockForSingle(this.asyncBucket.query(query).map((Func1)new Func1<AsyncViewResult, ViewResult>(){

            public ViewResult call(AsyncViewResult asyncViewResult) {
                return new DefaultViewResult(CouchbaseBucket.this.environment, CouchbaseBucket.this, asyncViewResult.rows(), asyncViewResult.totalRows(), asyncViewResult.success(), asyncViewResult.error(), asyncViewResult.debug());
            }
        }).single(), timeout, timeUnit);
    }

    @Override
    public SpatialViewResult query(SpatialViewQuery query, long timeout, TimeUnit timeUnit) {
        return (SpatialViewResult)Blocking.blockForSingle(this.asyncBucket.query(query).map((Func1)new Func1<AsyncSpatialViewResult, SpatialViewResult>(){

            public SpatialViewResult call(AsyncSpatialViewResult asyncSpatialViewResult) {
                return new DefaultSpatialViewResult(CouchbaseBucket.this.environment, CouchbaseBucket.this, asyncSpatialViewResult.rows(), asyncSpatialViewResult.success(), asyncSpatialViewResult.error(), asyncSpatialViewResult.debug());
            }
        }).single(), timeout, timeUnit);
    }

    @Override
    public QueryResult query(Statement statement, long timeout, TimeUnit timeUnit) {
        return this.query(Query.simple(statement), timeout, timeUnit);
    }

    @Override
    public QueryResult query(Query query, long timeout, TimeUnit timeUnit) {
        return (QueryResult)Blocking.blockForSingle(this.asyncBucket.query(query).flatMap((Func1)new Func1<AsyncQueryResult, Observable<QueryResult>>(){

            public Observable<QueryResult> call(AsyncQueryResult aqr) {
                final boolean parseSuccess = aqr.parseSuccess();
                final String requestId = aqr.requestId();
                final String clientContextId = aqr.clientContextId();
                return Observable.zip((Observable)aqr.rows().toList(), (Observable)aqr.signature().singleOrDefault((Object)JsonObject.empty()), (Observable)aqr.info().singleOrDefault((Object)QueryMetrics.EMPTY_METRICS), (Observable)aqr.errors().toList(), (Observable)aqr.finalSuccess().singleOrDefault((Object)Boolean.FALSE), (Func5)new Func5<List<AsyncQueryRow>, Object, QueryMetrics, List<JsonObject>, Boolean, QueryResult>(){

                    public QueryResult call(List<AsyncQueryRow> rows, Object signature, QueryMetrics info, List<JsonObject> errors, Boolean finalSuccess) {
                        return new DefaultQueryResult(rows, signature, info, errors, finalSuccess, parseSuccess, requestId, clientContextId);
                    }
                });
            }
        }).single(), timeout, timeUnit);
    }

    @Override
    public QueryPlan prepare(String statement, long timeout, TimeUnit timeUnit) {
        return (QueryPlan)Blocking.blockForSingle(this.asyncBucket.prepare(statement).single(), timeout, timeUnit);
    }

    @Override
    public QueryPlan prepare(Statement statement, long timeout, TimeUnit timeUnit) {
        return (QueryPlan)Blocking.blockForSingle(this.asyncBucket.prepare(statement).single(), timeout, timeUnit);
    }

    @Override
    public Boolean unlock(String id, long cas) {
        return this.unlock(id, cas, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> Boolean unlock(D document) {
        return this.unlock(document, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public Boolean unlock(String id, long cas, long timeout, TimeUnit timeUnit) {
        return (Boolean)Blocking.blockForSingle(this.asyncBucket.unlock(id, cas).single(), timeout, timeUnit);
    }

    @Override
    public <D extends Document<?>> Boolean unlock(D document, long timeout, TimeUnit timeUnit) {
        return (Boolean)Blocking.blockForSingle(this.asyncBucket.unlock(document).single(), timeout, timeUnit);
    }

    @Override
    public Boolean touch(String id, int expiry) {
        return this.touch(id, expiry, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> Boolean touch(D document) {
        return this.touch(document, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public Boolean touch(String id, int expiry, long timeout, TimeUnit timeUnit) {
        return (Boolean)Blocking.blockForSingle(this.asyncBucket.touch(id, expiry).single(), timeout, timeUnit);
    }

    @Override
    public <D extends Document<?>> Boolean touch(D document, long timeout, TimeUnit timeUnit) {
        return (Boolean)Blocking.blockForSingle(this.asyncBucket.touch(document).single(), timeout, timeUnit);
    }

    @Override
    public JsonLongDocument counter(String id, long delta) {
        return this.counter(id, delta, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public JsonLongDocument counter(String id, long delta, long initial) {
        return this.counter(id, delta, initial, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public JsonLongDocument counter(String id, long delta, long initial, int expiry) {
        return this.counter(id, delta, initial, expiry, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public JsonLongDocument counter(String id, long delta, long timeout, TimeUnit timeUnit) {
        return (JsonLongDocument)Blocking.blockForSingle(this.asyncBucket.counter(id, delta).single(), timeout, timeUnit);
    }

    @Override
    public JsonLongDocument counter(String id, long delta, long initial, long timeout, TimeUnit timeUnit) {
        return (JsonLongDocument)Blocking.blockForSingle(this.asyncBucket.counter(id, delta, initial).single(), timeout, timeUnit);
    }

    @Override
    public JsonLongDocument counter(String id, long delta, long initial, int expiry, long timeout, TimeUnit timeUnit) {
        return (JsonLongDocument)Blocking.blockForSingle(this.asyncBucket.counter(id, delta, initial, expiry).single(), timeout, timeUnit);
    }

    @Override
    public BucketManager bucketManager() {
        return (BucketManager)this.asyncBucket.bucketManager().map((Func1)new Func1<AsyncBucketManager, BucketManager>(){

            public BucketManager call(AsyncBucketManager asyncBucketManager) {
                return DefaultBucketManager.create(CouchbaseBucket.this.environment, CouchbaseBucket.this.name, CouchbaseBucket.this.password, CouchbaseBucket.this.core);
            }
        }).toBlocking().single();
    }

    @Override
    public <D extends Document<?>> D append(D document) {
        return this.append(document, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> D prepend(D document) {
        return this.prepend(document, this.kvTimeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> D append(D document, long timeout, TimeUnit timeUnit) {
        return (D)((Document)Blocking.blockForSingle(this.asyncBucket.append(document).single(), timeout, timeUnit));
    }

    @Override
    public <D extends Document<?>> D prepend(D document, long timeout, TimeUnit timeUnit) {
        return (D)((Document)Blocking.blockForSingle(this.asyncBucket.prepend(document).single(), timeout, timeUnit));
    }

    @Override
    public Boolean close() {
        return this.close(this.environment.disconnectTimeout(), TIMEOUT_UNIT);
    }

    @Override
    public Boolean close(long timeout, TimeUnit timeUnit) {
        return (Boolean)Blocking.blockForSingle(this.asyncBucket.close().single(), timeout, timeUnit);
    }

    public String toString() {
        return "Bucket[" + this.name() + "]";
    }
}

