/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.document;

import com.couchbase.client.java.document.AbstractDocument;
import com.couchbase.client.java.document.json.JsonObject;

public class JsonDocument
extends AbstractDocument<JsonObject> {
    public static JsonDocument create(String id) {
        return new JsonDocument(id, 0, null, 0L);
    }

    public static JsonDocument create(String id, JsonObject content) {
        return new JsonDocument(id, 0, content, 0L);
    }

    public static JsonDocument create(String id, JsonObject content, long cas) {
        return new JsonDocument(id, 0, content, cas);
    }

    public static JsonDocument create(String id, int expiry, JsonObject content) {
        return new JsonDocument(id, expiry, content, 0L);
    }

    public static JsonDocument create(String id, int expiry, JsonObject content, long cas) {
        return new JsonDocument(id, expiry, content, cas);
    }

    public static JsonDocument from(JsonDocument doc, String id) {
        return JsonDocument.create(id, doc.expiry(), (JsonObject)doc.content(), doc.cas());
    }

    public static JsonDocument from(JsonDocument doc, JsonObject content) {
        return JsonDocument.create(doc.id(), doc.expiry(), content, doc.cas());
    }

    public static JsonDocument from(JsonDocument doc, String id, JsonObject content) {
        return JsonDocument.create(id, doc.expiry(), content, doc.cas());
    }

    public static JsonDocument from(JsonDocument doc, long cas) {
        return JsonDocument.create(doc.id(), doc.expiry(), (JsonObject)doc.content(), cas);
    }

    private JsonDocument(String id, int expiry, JsonObject content, long cas) {
        super(id, expiry, content, cas);
    }
}

