/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.bucket;

import com.couchbase.client.core.ClusterFacade;
import com.couchbase.client.core.CouchbaseException;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.message.CouchbaseResponse;
import com.couchbase.client.core.message.ResponseStatus;
import com.couchbase.client.core.message.config.BucketConfigRequest;
import com.couchbase.client.core.message.config.BucketConfigResponse;
import com.couchbase.client.core.message.config.FlushRequest;
import com.couchbase.client.core.message.config.FlushResponse;
import com.couchbase.client.core.message.config.GetDesignDocumentsRequest;
import com.couchbase.client.core.message.config.GetDesignDocumentsResponse;
import com.couchbase.client.core.message.kv.GetRequest;
import com.couchbase.client.core.message.kv.GetResponse;
import com.couchbase.client.core.message.kv.UpsertRequest;
import com.couchbase.client.core.message.view.GetDesignDocumentRequest;
import com.couchbase.client.core.message.view.GetDesignDocumentResponse;
import com.couchbase.client.core.message.view.RemoveDesignDocumentRequest;
import com.couchbase.client.core.message.view.RemoveDesignDocumentResponse;
import com.couchbase.client.core.message.view.UpsertDesignDocumentRequest;
import com.couchbase.client.core.message.view.UpsertDesignDocumentResponse;
import com.couchbase.client.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.deps.io.netty.util.CharsetUtil;
import com.couchbase.client.java.CouchbaseAsyncBucket;
import com.couchbase.client.java.bucket.AsyncBucketManager;
import com.couchbase.client.java.bucket.BucketInfo;
import com.couchbase.client.java.bucket.DefaultBucketInfo;
import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.error.DesignDocumentAlreadyExistsException;
import com.couchbase.client.java.error.DesignDocumentException;
import com.couchbase.client.java.error.FlushDisabledException;
import com.couchbase.client.java.error.TranscodingException;
import com.couchbase.client.java.view.DesignDocument;
import java.nio.charset.Charset;
import java.util.ArrayList;
import rx.Observable;
import rx.functions.Func1;

public class DefaultAsyncBucketManager
implements AsyncBucketManager {
    private final ClusterFacade core;
    private final String bucket;
    private final String password;

    DefaultAsyncBucketManager(String bucket, String password, ClusterFacade core) {
        this.bucket = bucket;
        this.password = password;
        this.core = core;
    }

    public static DefaultAsyncBucketManager create(String bucket, String password, ClusterFacade core) {
        return new DefaultAsyncBucketManager(bucket, password, core);
    }

    @Override
    public Observable<BucketInfo> info() {
        return this.core.send((CouchbaseRequest)new BucketConfigRequest("/pools/default/buckets/", null, this.bucket, this.password)).map((Func1)new Func1<BucketConfigResponse, BucketInfo>(){

            public BucketInfo call(BucketConfigResponse response) {
                try {
                    return DefaultBucketInfo.create(CouchbaseAsyncBucket.JSON_OBJECT_TRANSCODER.stringToJsonObject(response.config()));
                }
                catch (Exception ex) {
                    throw new TranscodingException("Could not decode bucket info.", ex);
                }
            }
        });
    }

    @Override
    public Observable<Boolean> flush() {
        String markerKey = "__flush_marker";
        return this.core.send((CouchbaseRequest)new UpsertRequest("__flush_marker", Unpooled.copiedBuffer((CharSequence)"__flush_marker", (Charset)CharsetUtil.UTF_8), this.bucket)).flatMap((Func1)new Func1<CouchbaseResponse, Observable<FlushResponse>>(){

            public Observable<FlushResponse> call(CouchbaseResponse res) {
                return DefaultAsyncBucketManager.this.core.send((CouchbaseRequest)new FlushRequest(DefaultAsyncBucketManager.this.bucket, DefaultAsyncBucketManager.this.password));
            }
        }).flatMap((Func1)new Func1<FlushResponse, Observable<? extends Boolean>>(){

            public Observable<? extends Boolean> call(FlushResponse flushResponse) {
                GetResponse res;
                if (flushResponse.status() == ResponseStatus.FAILURE) {
                    if (flushResponse.content().contains("disabled")) {
                        return Observable.error((Throwable)((Object)new FlushDisabledException("Flush is disabled for this bucket.")));
                    }
                    return Observable.error((Throwable)new CouchbaseException("Flush failed because of: " + flushResponse.content()));
                }
                if (flushResponse.isDone()) {
                    return Observable.just((Object)true);
                }
                while ((res = (GetResponse)DefaultAsyncBucketManager.this.core.send((CouchbaseRequest)new GetRequest("__flush_marker", DefaultAsyncBucketManager.this.bucket)).toBlocking().single()).status() != ResponseStatus.NOT_EXISTS) {
                }
                return Observable.just((Object)true);
            }
        });
    }

    @Override
    public Observable<DesignDocument> getDesignDocuments() {
        return this.getDesignDocuments(false);
    }

    @Override
    public Observable<DesignDocument> getDesignDocuments(final boolean development) {
        return this.core.send((CouchbaseRequest)new GetDesignDocumentsRequest(this.bucket, this.password)).flatMap((Func1)new Func1<GetDesignDocumentsResponse, Observable<DesignDocument>>(){

            public Observable<DesignDocument> call(GetDesignDocumentsResponse response) {
                JsonObject converted = null;
                try {
                    converted = CouchbaseAsyncBucket.JSON_OBJECT_TRANSCODER.stringToJsonObject(response.content());
                }
                catch (Exception e) {
                    throw new TranscodingException("Could not decode design document.", e);
                }
                JsonArray rows = converted.getArray("rows");
                ArrayList<DesignDocument> docs = new ArrayList<DesignDocument>();
                for (Object doc : rows) {
                    JsonObject docObj = ((JsonObject)doc).getObject("doc");
                    String id = docObj.getObject("meta").getString("id");
                    String[] idSplit = id.split("/");
                    String fullName = idSplit[1];
                    boolean isDev = fullName.startsWith("dev_");
                    if (isDev != development) continue;
                    String name = fullName.replace("dev_", "");
                    docs.add(DesignDocument.from(name, docObj.getObject("json")));
                }
                return Observable.from(docs);
            }
        });
    }

    @Override
    public Observable<DesignDocument> getDesignDocument(String name) {
        return this.getDesignDocument(name, false);
    }

    @Override
    public Observable<DesignDocument> getDesignDocument(String name, boolean development) {
        return this.core.send((CouchbaseRequest)new GetDesignDocumentRequest(name, development, this.bucket, this.password)).filter((Func1)new Func1<GetDesignDocumentResponse, Boolean>(){

            public Boolean call(GetDesignDocumentResponse response) {
                return response.status().isSuccess();
            }
        }).map((Func1)new Func1<GetDesignDocumentResponse, DesignDocument>(){

            public DesignDocument call(GetDesignDocumentResponse response) {
                JsonObject converted;
                try {
                    converted = CouchbaseAsyncBucket.JSON_OBJECT_TRANSCODER.stringToJsonObject(response.content().toString(CharsetUtil.UTF_8));
                }
                catch (Exception e) {
                    throw new TranscodingException("Could not decode design document.", e);
                }
                return DesignDocument.from(response.name(), converted);
            }
        });
    }

    @Override
    public Observable<DesignDocument> insertDesignDocument(DesignDocument designDocument) {
        return this.insertDesignDocument(designDocument, false);
    }

    @Override
    public Observable<DesignDocument> insertDesignDocument(final DesignDocument designDocument, final boolean development) {
        return this.getDesignDocument(designDocument.name(), development).isEmpty().flatMap((Func1)new Func1<Boolean, Observable<DesignDocument>>(){

            public Observable<DesignDocument> call(Boolean doesNotExist) {
                if (doesNotExist.booleanValue()) {
                    return DefaultAsyncBucketManager.this.upsertDesignDocument(designDocument, development);
                }
                return Observable.error((Throwable)((Object)new DesignDocumentAlreadyExistsException()));
            }
        });
    }

    @Override
    public Observable<DesignDocument> upsertDesignDocument(DesignDocument designDocument) {
        return this.upsertDesignDocument(designDocument, false);
    }

    @Override
    public Observable<DesignDocument> upsertDesignDocument(final DesignDocument designDocument, boolean development) {
        String body = null;
        try {
            body = CouchbaseAsyncBucket.JSON_OBJECT_TRANSCODER.jsonObjectToString(designDocument.toJsonObject());
        }
        catch (Exception e) {
            throw new TranscodingException("Could not encode design document: ", e);
        }
        UpsertDesignDocumentRequest req = new UpsertDesignDocumentRequest(designDocument.name(), body, development, this.bucket, this.password);
        return this.core.send((CouchbaseRequest)req).map((Func1)new Func1<UpsertDesignDocumentResponse, DesignDocument>(){

            public DesignDocument call(UpsertDesignDocumentResponse response) {
                if (!response.status().isSuccess()) {
                    String msg = response.content().toString(CharsetUtil.UTF_8);
                    throw new DesignDocumentException("Could not store DesignDocument: " + msg);
                }
                return designDocument;
            }
        });
    }

    @Override
    public Observable<Boolean> removeDesignDocument(String name) {
        return this.removeDesignDocument(name, false);
    }

    @Override
    public Observable<Boolean> removeDesignDocument(String name, boolean development) {
        RemoveDesignDocumentRequest req = new RemoveDesignDocumentRequest(name, development, this.bucket, this.password);
        return this.core.send((CouchbaseRequest)req).map((Func1)new Func1<RemoveDesignDocumentResponse, Boolean>(){

            public Boolean call(RemoveDesignDocumentResponse response) {
                return response.status().isSuccess();
            }
        });
    }

    @Override
    public Observable<DesignDocument> publishDesignDocument(String name) {
        return this.publishDesignDocument(name, false);
    }

    @Override
    public Observable<DesignDocument> publishDesignDocument(final String name, final boolean overwrite) {
        return this.getDesignDocument(name, false).isEmpty().flatMap((Func1)new Func1<Boolean, Observable<DesignDocument>>(){

            public Observable<DesignDocument> call(Boolean doesNotExist) {
                if (!doesNotExist.booleanValue() && !overwrite) {
                    return Observable.error((Throwable)((Object)new DesignDocumentAlreadyExistsException("Document exists in production and not overwriting.")));
                }
                return DefaultAsyncBucketManager.this.getDesignDocument(name, true);
            }
        }).flatMap((Func1)new Func1<DesignDocument, Observable<DesignDocument>>(){

            public Observable<DesignDocument> call(DesignDocument designDocument) {
                return DefaultAsyncBucketManager.this.upsertDesignDocument(designDocument);
            }
        });
    }
}

