/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.bucket;

import com.couchbase.client.core.ClusterFacade;
import com.couchbase.client.core.config.CouchbaseBucketConfig;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.message.cluster.GetClusterConfigRequest;
import com.couchbase.client.core.message.cluster.GetClusterConfigResponse;
import com.couchbase.client.core.message.kv.ObserveRequest;
import com.couchbase.client.core.message.kv.ObserveResponse;
import com.couchbase.client.java.PersistTo;
import com.couchbase.client.java.ReplicateTo;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.functions.Func0;
import rx.functions.Func1;

public class Observe {
    public static Observable<Boolean> call(ClusterFacade core, String bucket, String id, long cas, boolean remove, final PersistTo persistTo, final ReplicateTo replicateTo) {
        ObserveResponse.ObserveStatus replicaIdentifier;
        ObserveResponse.ObserveStatus persistIdentifier;
        if (remove) {
            persistIdentifier = ObserveResponse.ObserveStatus.FOUND_NOT_PERSISTED;
            replicaIdentifier = ObserveResponse.ObserveStatus.NOT_FOUND_NOT_PERSISTED;
        } else {
            persistIdentifier = ObserveResponse.ObserveStatus.FOUND_PERSISTED;
            replicaIdentifier = ObserveResponse.ObserveStatus.NOT_FOUND_PERSISTED;
        }
        Observable<ObserveResponse> observeResponses = Observe.sendObserveRequests(core, bucket, id, cas, persistTo, replicateTo);
        return observeResponses.toList().delay(10L, TimeUnit.MILLISECONDS).repeat().skipWhile((Func1)new Func1<List<ObserveResponse>, Boolean>(){

            public Boolean call(List<ObserveResponse> observeResponses) {
                int replicated = 0;
                int persisted = 0;
                boolean persistedMaster = false;
                for (ObserveResponse response : observeResponses) {
                    ObserveResponse.ObserveStatus status = response.observeStatus();
                    if (response.master()) {
                        if (status != persistIdentifier) continue;
                        ++persisted;
                        persistedMaster = true;
                        continue;
                    }
                    if (status == persistIdentifier) {
                        ++persisted;
                        ++replicated;
                        continue;
                    }
                    if (status != replicaIdentifier) continue;
                    ++replicated;
                }
                boolean persistDone = false;
                boolean replicateDone = false;
                if (persistTo == PersistTo.MASTER && persistedMaster) {
                    persistDone = true;
                } else if (persisted >= persistTo.value()) {
                    persistDone = true;
                }
                if (replicated >= replicateTo.value()) {
                    replicateDone = true;
                }
                return !persistDone || !replicateDone;
            }
        }).take(1).map((Func1)new Func1<List<ObserveResponse>, Boolean>(){

            public Boolean call(List<ObserveResponse> observeResponses) {
                return true;
            }
        });
    }

    private static Observable<ObserveResponse> sendObserveRequests(final ClusterFacade core, final String bucket, final String id, final long cas, final PersistTo persistTo, final ReplicateTo replicateTo) {
        return Observable.defer((Func0)new Func0<Observable<ObserveResponse>>(){

            public Observable<ObserveResponse> call() {
                return core.send((CouchbaseRequest)new GetClusterConfigRequest()).map((Func1)new Func1<GetClusterConfigResponse, Integer>(){

                    public Integer call(GetClusterConfigResponse response) {
                        CouchbaseBucketConfig conf = (CouchbaseBucketConfig)response.config().bucketConfig(bucket);
                        return conf.numberOfReplicas();
                    }
                }).flatMap((Func1)new Func1<Integer, Observable<ObserveResponse>>(){

                    public Observable<ObserveResponse> call(Integer replicas) {
                        ArrayList<Observable> obs = new ArrayList<Observable>();
                        if (persistTo != PersistTo.NONE) {
                            obs.add(core.send((CouchbaseRequest)new ObserveRequest(id, cas, true, 0, bucket)));
                        }
                        if (persistTo.touchesReplica() || replicateTo.touchesReplica()) {
                            if (replicas >= 1) {
                                obs.add(core.send((CouchbaseRequest)new ObserveRequest(id, cas, false, 1, bucket)));
                            }
                            if (replicas >= 2) {
                                obs.add(core.send((CouchbaseRequest)new ObserveRequest(id, cas, false, 2, bucket)));
                            }
                            if (replicas == 3) {
                                obs.add(core.send((CouchbaseRequest)new ObserveRequest(id, cas, false, 3, bucket)));
                            }
                        }
                        return Observable.merge(obs);
                    }
                });
            }
        });
    }
}

