/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.columnar.client.java;

import com.couchbase.client.core.util.CbObjects;
import java.time.Duration;
import org.jspecify.annotations.Nullable;

public final class TimeoutOptions {
    private @Nullable Duration connectTimeout;
    private @Nullable Duration queryTimeout;

    TimeoutOptions() {
    }

    Unmodifiable build() {
        return new Unmodifiable(this);
    }

    private static @Nullable Duration requireNullOrNonNegative(@Nullable Duration d, String name) {
        if (d != null && d.isNegative()) {
            throw new IllegalArgumentException(name + " must be non-negative, but got: " + String.valueOf(d));
        }
        return d;
    }

    public TimeoutOptions queryTimeout(@Nullable Duration queryTimeout) {
        this.queryTimeout = TimeoutOptions.requireNullOrNonNegative(queryTimeout, "queryTimeout");
        return this;
    }

    public TimeoutOptions connectTimeout(Duration connectTimeout) {
        this.connectTimeout = TimeoutOptions.requireNullOrNonNegative(connectTimeout, "connectTimeout");
        return this;
    }

    static class Unmodifiable {
        private final Duration queryTimeout;
        private final Duration connectTimeout;

        private Unmodifiable(TimeoutOptions builder) {
            this.connectTimeout = (Duration)CbObjects.defaultIfNull((Object)builder.connectTimeout, (Object)Duration.ofSeconds(10L));
            this.queryTimeout = (Duration)CbObjects.defaultIfNull((Object)builder.queryTimeout, (Object)Duration.ofMinutes(10L));
        }

        public Duration queryTimeout() {
            return this.queryTimeout;
        }

        public Duration connectTimeout() {
            return this.connectTimeout;
        }

        public String toString() {
            return "TimeoutOptions{queryTimeout=" + String.valueOf(this.queryTimeout) + ", connectTimeout=" + String.valueOf(this.connectTimeout) + "}";
        }
    }
}

