/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.columnar.client.java.json;

import com.couchbase.client.core.util.CbCollections;
import com.couchbase.columnar.client.java.json.JsonArray;
import com.couchbase.columnar.client.java.json.JsonObject;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import reactor.util.annotation.Nullable;

public abstract class JsonValue {
    JsonValue() {
    }

    static boolean isSupportedType(@Nullable Object item) {
        return item == null || item instanceof String || item instanceof Integer || item instanceof Long || item instanceof Double || item instanceof Boolean || item instanceof BigInteger || item instanceof BigDecimal || item instanceof JsonObject || item instanceof JsonArray;
    }

    @Nullable
    static Object coerce(@Nullable Object value) {
        if (JsonValue.isSupportedType(value)) {
            return value;
        }
        if (value instanceof Map) {
            return JsonObject.from((Map)value);
        }
        if (value instanceof List) {
            return JsonArray.from((List)value);
        }
        if (value instanceof Iterable) {
            return JsonArray.fromIterable((Iterable)value);
        }
        throw new IllegalArgumentException("Unsupported type for JSON value: " + value.getClass() + " ; must be one of " + JsonValue.supportedTypeNames());
    }

    private static List<String> supportedTypeNames() {
        return CbCollections.listOf((Object[])new String[]{"String", "Integer", "Long", "Double", "Boolean", "BigInteger", "BigDecimal", "JsonObject", "JsonArray", "Map<String,?>", "Iterable<?>", "null"});
    }
}

