/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.internal;

import com.couchbase.client.CouchbaseConnection;
import com.couchbase.client.internal.Throttler;
import java.lang.reflect.Constructor;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.spy.memcached.OperationFactory;

public class ThrottleManager<T extends Throttler> {
    private static final Logger LOGGER = Logger.getLogger(ThrottleManager.class.getName());
    private final Map<InetSocketAddress, T> throttles;
    private final Class<T> throttler;
    private final CouchbaseConnection conn;
    private final OperationFactory opFact;

    public ThrottleManager(List<InetSocketAddress> initialNodes, Class<T> throttler, CouchbaseConnection conn, OperationFactory opFact) {
        this.throttler = throttler;
        this.throttles = new HashMap<InetSocketAddress, T>();
        this.conn = conn;
        this.opFact = opFact;
        for (InetSocketAddress node : initialNodes) {
            this.setThrottler(node);
        }
    }

    public final ThrottleManager setThrottler(InetSocketAddress node) {
        LOGGER.log(Level.INFO, "Adding Throttler for {0}", node.toString());
        try {
            Constructor<T> constructor = this.throttler.getConstructor(this.conn.getClass(), this.opFact.getClass(), node.getClass());
            this.throttles.put(node, constructor.newInstance(this.conn, this.opFact, node));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not add Throttler for " + node.toString());
        }
        return this;
    }

    public T getThrottler(InetSocketAddress node) {
        return (T)((Throttler)this.throttles.get(node));
    }

    public void removeThrottler(InetSocketAddress node) {
        LOGGER.log(Level.INFO, "Removing Throttler for {0}", node.toString());
        this.throttles.remove(node);
    }
}

