/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.vbucket.config;

public class VBucket {
    public static final short MAX_REPLICAS = 3;
    public static final int MAX_BUCKETS = 65536;
    public static final short REPLICA_NOT_USED = -1;
    private volatile short master;
    private final short replica1;
    private final short replica2;
    private final short replica3;

    public VBucket(short m) {
        this(m, -1, -1, -1);
    }

    public VBucket(short m, short r1) {
        this(m, r1, -1, -1);
    }

    public VBucket(short m, short r1, short r2) {
        this(m, r1, r2, -1);
    }

    public VBucket(short m, short r1, short r2, short r3) {
        this.master = m;
        this.replica1 = r1;
        this.replica2 = r2;
        this.replica3 = r3;
    }

    public int getMaster() {
        return this.master;
    }

    public int getReplica(int n) {
        switch (n) {
            case 0: {
                return this.replica1;
            }
            case 1: {
                return this.replica2;
            }
            case 2: {
                return this.replica3;
            }
        }
        throw new IllegalArgumentException("No more than 3 replicas allowed.");
    }

    public void setMaster(short rv) {
        this.master = rv;
    }

    public String toString() {
        return "m: " + this.master + ", r: " + "[" + this.replica1 + ", " + this.replica2 + ", " + this.replica3 + "]";
    }
}

