/*
 * Decompiled with CFR 0.152.
 */
package com.cosmos.apm.framework.page;

import android.app.Activity;
import android.app.Instrumentation;
import android.os.Bundle;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;

public class ActivityLifeCycleHelper {
    private static Set<ILifeCycleListener> lifeCycleListeners = new HashSet<ILifeCycleListener>();

    private static void replaceInstrumentation() {
        try {
            Class<?> activityThreadClass = Class.forName("android.app.ActivityThread");
            Method currentActivityThreadMethod = activityThreadClass.getDeclaredMethod("currentActivityThread", new Class[0]);
            currentActivityThreadMethod.setAccessible(true);
            Object currentActivityThread = currentActivityThreadMethod.invoke(null, new Object[0]);
            Field mInstrumentationField = activityThreadClass.getDeclaredField("mInstrumentation");
            mInstrumentationField.setAccessible(true);
            Instrumentation mInstrumentation = (Instrumentation)mInstrumentationField.get(currentActivityThread);
            ApplicationInstrumentation evilInstrumentation = new ApplicationInstrumentation(mInstrumentation);
            mInstrumentationField.set(currentActivityThread, (Object)evilInstrumentation);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void registerLifeCycleListener(ILifeCycleListener listener) {
        if (listener == null) {
            return;
        }
        lifeCycleListeners.add(listener);
    }

    public static void unRegisterLifeCycleListener(ILifeCycleListener listener) {
        if (listener == null) {
            return;
        }
        lifeCycleListeners.remove(listener);
    }

    static {
        ActivityLifeCycleHelper.replaceInstrumentation();
    }

    public static interface ILifeCycleListener {
        public void beforeActivityCreate(Activity var1, Bundle var2);

        public void afterActivityCreate(Activity var1, Bundle var2);

        public void beforeActivityResume(Activity var1);

        public void afterActivityResume(Activity var1);

        public void beforeActivityDestroy(Activity var1);

        public void afterActivityDestroy(Activity var1);

        public void beforeActivityStart(Activity var1);

        public void afterActivityStart(Activity var1);

        public void beforeActivityStop(Activity var1);

        public void afterActivityStop(Activity var1);

        public void beforeActivityPause(Activity var1);

        public void afterActivityPause(Activity var1);
    }

    private static class ApplicationInstrumentation
    extends Instrumentation {
        Instrumentation mBase;

        public ApplicationInstrumentation(Instrumentation base) {
            this.mBase = base;
        }

        public void callActivityOnCreate(Activity activity, Bundle savedInstanceState) {
            for (ILifeCycleListener lifeCycleListener : lifeCycleListeners) {
                lifeCycleListener.beforeActivityCreate(activity, savedInstanceState);
            }
            super.callActivityOnCreate(activity, savedInstanceState);
            for (ILifeCycleListener lifeCycleListener : lifeCycleListeners) {
                lifeCycleListener.afterActivityCreate(activity, savedInstanceState);
            }
        }

        public void callActivityOnResume(Activity activity) {
            for (ILifeCycleListener lifeCycleListener : lifeCycleListeners) {
                lifeCycleListener.beforeActivityResume(activity);
            }
            super.callActivityOnResume(activity);
            for (ILifeCycleListener lifeCycleListener : lifeCycleListeners) {
                lifeCycleListener.afterActivityResume(activity);
            }
        }

        public void callActivityOnDestroy(Activity activity) {
            for (ILifeCycleListener lifeCycleListener : lifeCycleListeners) {
                lifeCycleListener.beforeActivityDestroy(activity);
            }
            super.callActivityOnDestroy(activity);
            for (ILifeCycleListener lifeCycleListener : lifeCycleListeners) {
                lifeCycleListener.afterActivityDestroy(activity);
            }
        }

        public void callActivityOnStop(Activity activity) {
            for (ILifeCycleListener lifeCycleListener : lifeCycleListeners) {
                lifeCycleListener.beforeActivityStop(activity);
            }
            super.callActivityOnStop(activity);
            for (ILifeCycleListener lifeCycleListener : lifeCycleListeners) {
                lifeCycleListener.afterActivityStop(activity);
            }
        }

        public void callActivityOnStart(Activity activity) {
            for (ILifeCycleListener lifeCycleListener : lifeCycleListeners) {
                lifeCycleListener.beforeActivityStart(activity);
            }
            super.callActivityOnStart(activity);
            for (ILifeCycleListener lifeCycleListener : lifeCycleListeners) {
                lifeCycleListener.afterActivityStart(activity);
            }
        }

        public void callActivityOnPause(Activity activity) {
            for (ILifeCycleListener lifeCycleListener : lifeCycleListeners) {
                lifeCycleListener.beforeActivityPause(activity);
            }
            super.callActivityOnPause(activity);
            for (ILifeCycleListener lifeCycleListener : lifeCycleListeners) {
                lifeCycleListener.afterActivityPause(activity);
            }
        }
    }
}

