/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.namespace;

import com.corundumstudio.socketio.Configuration;
import com.corundumstudio.socketio.SocketIOClient;
import com.corundumstudio.socketio.SocketIONamespace;
import com.corundumstudio.socketio.misc.CompositeIterable;
import com.corundumstudio.socketio.namespace.Namespace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class NamespacesHub {
    private final ConcurrentMap<String, SocketIONamespace> namespaces = new ConcurrentHashMap<String, SocketIONamespace>();
    private final Configuration configuration;

    public NamespacesHub(Configuration configuration) {
        this.configuration = configuration;
    }

    public Namespace create(String name) {
        Namespace oldNamespace;
        Namespace namespace = (Namespace)this.namespaces.get(name);
        if (namespace == null && (oldNamespace = (Namespace)this.namespaces.putIfAbsent(name, namespace = new Namespace(name, this.configuration))) != null) {
            namespace = oldNamespace;
        }
        return namespace;
    }

    public Iterable<SocketIOClient> getRoomClients(String room) {
        ArrayList allClients = new ArrayList();
        for (SocketIONamespace namespace : this.namespaces.values()) {
            Iterable<SocketIOClient> clients = ((Namespace)namespace).getRoomClients(room);
            allClients.add(clients);
        }
        return new CompositeIterable<SocketIOClient>(allClients);
    }

    public Namespace get(String name) {
        return (Namespace)this.namespaces.get(name);
    }

    public void remove(String name) {
        SocketIONamespace namespace = (SocketIONamespace)this.namespaces.remove(name);
        if (namespace != null) {
            namespace.getBroadcastOperations().disconnect();
        }
    }

    public Collection<SocketIONamespace> getAllNamespaces() {
        return this.namespaces.values();
    }
}

