/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.handler;

import com.corundumstudio.socketio.Configuration;
import com.corundumstudio.socketio.Transport;
import com.corundumstudio.socketio.messages.BaseMessage;
import com.corundumstudio.socketio.messages.HttpMessage;
import com.corundumstudio.socketio.messages.OutPacketMessage;
import com.corundumstudio.socketio.messages.XHROptionsMessage;
import com.corundumstudio.socketio.messages.XHRPostMessage;
import com.corundumstudio.socketio.protocol.Packet;
import com.corundumstudio.socketio.protocol.PacketEncoder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Queue;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class EncoderHandler
extends ChannelOutboundHandlerAdapter {
    private static final byte[] OK = "ok".getBytes(CharsetUtil.UTF_8);
    public static final AttributeKey<String> ORIGIN = AttributeKey.valueOf((String)"origin");
    public static final AttributeKey<String> USER_AGENT = AttributeKey.valueOf((String)"userAgent");
    public static final AttributeKey<Boolean> B64 = AttributeKey.valueOf((String)"b64");
    public static final AttributeKey<Integer> JSONP_INDEX = AttributeKey.valueOf((String)"jsonpIndex");
    public static final AttributeKey<Boolean> WRITE_ONCE = AttributeKey.valueOf((String)"writeOnce");
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final PacketEncoder encoder;
    private String version;
    private Configuration configuration;

    public EncoderHandler(Configuration configuration, PacketEncoder encoder) throws IOException {
        this.encoder = encoder;
        this.configuration = configuration;
        if (configuration.isAddVersionHeader()) {
            this.readVersion();
        }
    }

    private void readVersion() throws IOException {
        Enumeration<URL> resources = ((Object)((Object)this)).getClass().getClassLoader().getResources("META-INF/MANIFEST.MF");
        while (resources.hasMoreElements()) {
            try {
                String name;
                Manifest manifest = new Manifest(resources.nextElement().openStream());
                Attributes attrs = manifest.getMainAttributes();
                if (attrs == null || (name = attrs.getValue("Bundle-Name")) == null || !name.equals("netty-socketio")) continue;
                this.version = name + "/" + attrs.getValue("Bundle-Version");
                break;
            }
            catch (IOException iOException) {
            }
        }
    }

    private void write(XHROptionsMessage msg, ChannelHandlerContext ctx) {
        DefaultHttpResponse res = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        HttpHeaders.addHeader((io.netty.handler.codec.http.HttpMessage)res, (String)"Set-Cookie", (Object)("io=" + msg.getSessionId()));
        HttpHeaders.addHeader((io.netty.handler.codec.http.HttpMessage)res, (String)"Connection", (Object)"keep-alive");
        HttpHeaders.addHeader((io.netty.handler.codec.http.HttpMessage)res, (String)"Access-Control-Allow-Headers", (Object)"Content-Type");
        this.addOriginHeaders(ctx.channel(), (HttpResponse)res);
        ByteBuf out = this.encoder.allocateBuffer(ctx.alloc());
        this.sendMessage((HttpMessage)msg, ctx.channel(), out, (HttpResponse)res);
    }

    private void write(XHRPostMessage msg, ChannelHandlerContext ctx) {
        ByteBuf out = this.encoder.allocateBuffer(ctx.alloc());
        out.writeBytes(OK);
        this.sendMessage((HttpMessage)msg, ctx.channel(), out, "text/html");
    }

    private void sendMessage(HttpMessage msg, Channel channel, ByteBuf out, String type) {
        DefaultHttpResponse res = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        res.headers().add("Content-Type", (Object)type).add("Set-Cookie", (Object)("io=" + msg.getSessionId())).add("Connection", (Object)"keep-alive");
        this.addOriginHeaders(channel, (HttpResponse)res);
        HttpHeaders.setContentLength((io.netty.handler.codec.http.HttpMessage)res, (long)out.readableBytes());
        String userAgent = (String)channel.attr(USER_AGENT).get();
        if (userAgent != null && (userAgent.contains(";MSIE") || userAgent.contains("Trident/"))) {
            res.headers().add("X-XSS-Protection", (Object)"0");
        }
        this.sendMessage(msg, channel, out, (HttpResponse)res);
    }

    private void sendMessage(HttpMessage msg, Channel channel, ByteBuf out, HttpResponse res) {
        channel.write((Object)res);
        if (this.log.isTraceEnabled()) {
            this.log.trace("Out message: {} - sessionId: {}", (Object)out.toString(CharsetUtil.UTF_8), (Object)msg.getSessionId());
        }
        if (out.isReadable()) {
            channel.write((Object)out);
        } else {
            out.release();
        }
        channel.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private void addOriginHeaders(Channel channel, HttpResponse res) {
        if (this.version != null) {
            res.headers().add("Server", (Object)this.version);
        }
        if (this.configuration.getOrigin() != null) {
            HttpHeaders.addHeader((io.netty.handler.codec.http.HttpMessage)res, (String)"Access-Control-Allow-Origin", (Object)this.configuration.getOrigin());
        } else {
            String origin = (String)channel.attr(ORIGIN).get();
            if (origin != null) {
                HttpHeaders.addHeader((io.netty.handler.codec.http.HttpMessage)res, (String)"Access-Control-Allow-Origin", (Object)origin);
                HttpHeaders.addHeader((io.netty.handler.codec.http.HttpMessage)res, (String)"Access-Control-Allow-Credentials", (Object)Boolean.TRUE);
            } else {
                HttpHeaders.addHeader((io.netty.handler.codec.http.HttpMessage)res, (String)"Access-Control-Allow-Origin", (Object)"*");
            }
        }
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (!(msg instanceof BaseMessage)) {
            super.write(ctx, msg, promise);
            return;
        }
        if (msg instanceof OutPacketMessage) {
            OutPacketMessage m = (OutPacketMessage)msg;
            if (m.getTransport() == Transport.WEBSOCKET) {
                this.handleWebsocket((OutPacketMessage)msg, ctx);
            }
            if (m.getTransport() == Transport.POLLING) {
                this.handleHTTP((OutPacketMessage)msg, ctx);
            }
        } else if (msg instanceof XHROptionsMessage) {
            this.write((XHROptionsMessage)msg, ctx);
        } else if (msg instanceof XHRPostMessage) {
            this.write((XHRPostMessage)msg, ctx);
        }
    }

    private void handleWebsocket(OutPacketMessage msg, ChannelHandlerContext ctx) throws IOException {
        Queue<Packet> queue;
        Packet packet;
        while ((packet = (queue = msg.getClientHead().getPacketsQueue(msg.getTransport())).poll()) != null) {
            ByteBuf out = this.encoder.allocateBuffer(ctx.alloc());
            this.encoder.encodePacket(packet, out, ctx.alloc(), true, false);
            TextWebSocketFrame res = new TextWebSocketFrame(out);
            if (this.log.isTraceEnabled()) {
                this.log.trace("Out message: {} sessionId: {}", (Object)out.toString(CharsetUtil.UTF_8), (Object)msg.getSessionId());
            }
            ctx.channel().writeAndFlush((Object)res);
            if (!out.isReadable()) {
                out.release();
            }
            for (ByteBuf buf : packet.getAttachments()) {
                ByteBuf outBuf = this.encoder.allocateBuffer(ctx.alloc());
                outBuf.writeByte(4);
                outBuf.writeBytes(buf);
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Out attachment: {} sessionId: {}", (Object)ByteBufUtil.hexDump((ByteBuf)outBuf), (Object)msg.getSessionId());
                }
                ctx.channel().writeAndFlush((Object)new BinaryWebSocketFrame(outBuf));
            }
        }
    }

    private void handleHTTP(OutPacketMessage msg, ChannelHandlerContext ctx) throws IOException {
        Channel channel = ctx.channel();
        Attribute attr = channel.attr(WRITE_ONCE);
        Queue<Packet> queue = msg.getClientHead().getPacketsQueue(msg.getTransport());
        if (!channel.isActive() || queue.isEmpty() || !attr.compareAndSet(null, (Object)true)) {
            return;
        }
        ByteBuf out = this.encoder.allocateBuffer(ctx.alloc());
        Boolean b64 = (Boolean)ctx.channel().attr(B64).get();
        if (b64 != null && b64.booleanValue()) {
            Integer jsonpIndex = (Integer)ctx.channel().attr(JSONP_INDEX).get();
            this.encoder.encodeJsonP(jsonpIndex, queue, out, ctx.alloc(), 50);
            this.sendMessage((HttpMessage)msg, channel, out, "application/javascript");
        } else {
            this.encoder.encodePackets(queue, out, ctx.alloc(), 50);
            this.sendMessage((HttpMessage)msg, channel, out, "application/octet-stream");
        }
    }
}

