/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.transport;

import com.corundumstudio.socketio.DisconnectableHub;
import com.corundumstudio.socketio.HandshakeData;
import com.corundumstudio.socketio.SocketIOClient;
import com.corundumstudio.socketio.Transport;
import com.corundumstudio.socketio.ack.AckManager;
import com.corundumstudio.socketio.handler.AuthorizeHandler;
import com.corundumstudio.socketio.handler.HeartbeatHandler;
import com.corundumstudio.socketio.messages.PacketsMessage;
import com.corundumstudio.socketio.store.StoreFactory;
import com.corundumstudio.socketio.transport.BaseTransport;
import com.corundumstudio.socketio.transport.MainBaseClient;
import com.corundumstudio.socketio.transport.WebSocketClient;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class WebSocketTransport
extends BaseTransport {
    public static final String NAME = "websocket";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<UUID, WebSocketClient> sessionId2Client = new ConcurrentHashMap<UUID, WebSocketClient>();
    private final Map<Channel, WebSocketClient> channelId2Client = new ConcurrentHashMap<Channel, WebSocketClient>();
    private final AckManager ackManager;
    private final HeartbeatHandler heartbeatHandler;
    private final AuthorizeHandler authorizeHandler;
    private final DisconnectableHub disconnectableHub;
    private final StoreFactory storeFactory;
    private final boolean isSsl;
    protected String path;

    public WebSocketTransport(String connectPath, boolean isSsl, AckManager ackManager, DisconnectableHub disconnectable, AuthorizeHandler authorizeHandler, HeartbeatHandler heartbeatHandler, StoreFactory storeFactory) {
        this.path = connectPath + NAME;
        this.isSsl = isSsl;
        this.authorizeHandler = authorizeHandler;
        this.ackManager = ackManager;
        this.disconnectableHub = disconnectable;
        this.heartbeatHandler = heartbeatHandler;
        this.storeFactory = storeFactory;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof CloseWebSocketFrame) {
            ctx.channel().close();
            ((CloseWebSocketFrame)msg).release();
        } else if (msg instanceof TextWebSocketFrame) {
            TextWebSocketFrame frame = (TextWebSocketFrame)msg;
            WebSocketClient client = this.channelId2Client.get(ctx.channel());
            if (client == null) {
                this.log.debug("Client with was already disconnected. Channel closed!");
                ctx.channel().close();
                frame.release();
                return;
            }
            ctx.pipeline().fireChannelRead((Object)new PacketsMessage(client, frame.content()));
            frame.release();
        } else if (msg instanceof FullHttpRequest) {
            FullHttpRequest req = (FullHttpRequest)msg;
            QueryStringDecoder queryDecoder = new QueryStringDecoder(req.getUri());
            String path = queryDecoder.path();
            if (path.startsWith(this.path)) {
                this.handshake(ctx, path, req);
                req.release();
            } else {
                ctx.fireChannelRead(msg);
            }
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        WebSocketClient client = this.channelId2Client.get(ctx.channel());
        if (client != null) {
            client.onChannelDisconnect();
        } else {
            super.channelInactive(ctx);
        }
    }

    private void handshake(ChannelHandlerContext ctx, String path, FullHttpRequest req) {
        final Channel channel = ctx.channel();
        String[] parts = path.split("/");
        if (parts.length <= 3) {
            this.log.warn("Wrong GET request path: {}, from ip: {}. Channel closed!", (Object)path, (Object)channel.remoteAddress());
            channel.close();
            return;
        }
        final UUID sessionId = UUID.fromString(parts[4]);
        WebSocketServerHandshakerFactory factory = new WebSocketServerHandshakerFactory(this.getWebSocketLocation((HttpRequest)req), null, false);
        WebSocketServerHandshaker handshaker = factory.newHandshaker((HttpRequest)req);
        if (handshaker != null) {
            ChannelFuture f = handshaker.handshake(channel, req);
            f.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    WebSocketTransport.this.connectClient(channel, sessionId);
                }
            });
        } else {
            WebSocketServerHandshakerFactory.sendUnsupportedWebSocketVersionResponse((Channel)ctx.channel());
        }
    }

    private void connectClient(Channel channel, UUID sessionId) {
        HandshakeData data = this.authorizeHandler.getHandshakeData(sessionId);
        if (data == null) {
            this.log.warn("Unauthorized client with sessionId: {}, from ip: {}. Channel closed!", (Object)sessionId, (Object)channel.remoteAddress());
            channel.close();
            return;
        }
        WebSocketClient client = new WebSocketClient(channel, this.ackManager, this.disconnectableHub, sessionId, this.getTransport(), this.storeFactory, data);
        this.channelId2Client.put(channel, client);
        this.sessionId2Client.put(sessionId, client);
        this.authorizeHandler.connect(client);
        this.heartbeatHandler.onHeartbeat(client);
        channel.pipeline().remove("xhrPollingTransport");
        this.removeHandler(channel.pipeline());
    }

    protected Transport getTransport() {
        return Transport.WEBSOCKET;
    }

    protected void removeHandler(ChannelPipeline pipeline) {
        pipeline.remove("flashSocketTransport");
    }

    private String getWebSocketLocation(HttpRequest req) {
        String protocol = "ws://";
        if (this.isSsl) {
            protocol = "wss://";
        }
        return protocol + req.headers().get("Host") + req.getUri();
    }

    @Override
    public void onDisconnect(MainBaseClient client) {
        if (client instanceof WebSocketClient) {
            WebSocketClient webClient = (WebSocketClient)client;
            this.sessionId2Client.remove(webClient.getSessionId());
            this.channelId2Client.remove(webClient.getChannel());
        }
    }

    public Iterable<SocketIOClient> getAllClients() {
        Collection<WebSocketClient> clients = this.sessionId2Client.values();
        return this.getAllClients(clients);
    }
}

