/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.namespace;

import com.corundumstudio.socketio.AckRequest;
import com.corundumstudio.socketio.BroadcastOperations;
import com.corundumstudio.socketio.Configuration;
import com.corundumstudio.socketio.MultiTypeArgs;
import com.corundumstudio.socketio.SocketIOClient;
import com.corundumstudio.socketio.SocketIONamespace;
import com.corundumstudio.socketio.annotation.ScannerEngine;
import com.corundumstudio.socketio.listener.ConnectListener;
import com.corundumstudio.socketio.listener.DataListener;
import com.corundumstudio.socketio.listener.DisconnectListener;
import com.corundumstudio.socketio.listener.ExceptionListener;
import com.corundumstudio.socketio.listener.MultiTypeEventListener;
import com.corundumstudio.socketio.namespace.EventEntry;
import com.corundumstudio.socketio.parser.JsonSupport;
import com.corundumstudio.socketio.parser.Packet;
import com.corundumstudio.socketio.store.StoreFactory;
import com.corundumstudio.socketio.store.pubsub.JoinLeaveMessage;
import com.corundumstudio.socketio.transport.NamespaceClient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;

public class Namespace
implements SocketIONamespace {
    public static final String DEFAULT_NAME = "";
    private final ScannerEngine engine = new ScannerEngine();
    private final Map<UUID, SocketIOClient> allClients = new ConcurrentHashMap<UUID, SocketIOClient>();
    private final ConcurrentMap<String, EventEntry<?>> eventListeners = new ConcurrentHashMap();
    private final ConcurrentMap<Class<?>, Queue<DataListener<?>>> jsonObjectListeners = new ConcurrentHashMap();
    private final Queue<DataListener<String>> messageListeners = new ConcurrentLinkedQueue<DataListener<String>>();
    private final Queue<ConnectListener> connectListeners = new ConcurrentLinkedQueue<ConnectListener>();
    private final Queue<DisconnectListener> disconnectListeners = new ConcurrentLinkedQueue<DisconnectListener>();
    private final ConcurrentMap<String, Queue<UUID>> roomClients = new ConcurrentHashMap<String, Queue<UUID>>();
    private final String name;
    private final boolean autoAck;
    private final JsonSupport jsonSupport;
    private final StoreFactory storeFactory;
    private final ExceptionListener exceptionListener;

    public Namespace(String name, Configuration configuration) {
        this.name = name;
        this.jsonSupport = configuration.getJsonSupport();
        this.storeFactory = configuration.getStoreFactory();
        this.exceptionListener = configuration.getExceptionListener();
        this.autoAck = configuration.isAutoAck();
    }

    public void addClient(SocketIOClient client) {
        this.allClients.put(client.getSessionId(), client);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void addMultiTypeEventListener(String eventName, MultiTypeEventListener listener, Class<?> ... eventClass) {
        EventEntry oldEntry;
        EventEntry<MultiTypeArgs> entry = (EventEntry<MultiTypeArgs>)this.eventListeners.get(eventName);
        if (entry == null && (oldEntry = this.eventListeners.putIfAbsent(eventName, entry = new EventEntry<MultiTypeArgs>())) != null) {
            entry = oldEntry;
        }
        entry.addListener(listener);
        this.jsonSupport.addEventMapping(eventName, eventClass);
    }

    @Override
    public <T> void addEventListener(String eventName, Class<T> eventClass, DataListener<T> listener) {
        EventEntry oldEntry;
        EventEntry<T> entry = (EventEntry<T>)this.eventListeners.get(eventName);
        if (entry == null && (oldEntry = this.eventListeners.putIfAbsent(eventName, entry = new EventEntry<T>())) != null) {
            entry = oldEntry;
        }
        entry.addListener(listener);
        this.jsonSupport.addEventMapping(eventName, eventClass);
    }

    @Override
    public <T> void addJsonObjectListener(Class<T> clazz, DataListener<T> listener) {
        Queue oldQueue;
        Queue<DataListener<Object>> queue = (ConcurrentLinkedQueue<DataListener<T>>)this.jsonObjectListeners.get(clazz);
        if (queue == null && (oldQueue = (Queue)this.jsonObjectListeners.putIfAbsent(clazz, queue = new ConcurrentLinkedQueue<DataListener<T>>())) != null) {
            queue = oldQueue;
        }
        queue.add(listener);
        this.jsonSupport.addJsonClass(clazz);
    }

    public void onEvent(NamespaceClient client, String eventName, List<Object> args, AckRequest ackRequest) {
        EventEntry entry = (EventEntry)this.eventListeners.get(eventName);
        if (entry == null) {
            return;
        }
        try {
            Queue listeners = entry.getListeners();
            for (DataListener dataListener : listeners) {
                Object data = this.getEventData(args, dataListener);
                dataListener.onData(client, data, ackRequest);
            }
        }
        catch (Exception e) {
            this.exceptionListener.onEventException(e, args, client);
        }
        this.sendAck(ackRequest);
    }

    private void sendAck(AckRequest ackRequest) {
        if (this.autoAck) {
            ackRequest.sendAckData(Collections.<Object>emptyList());
        }
    }

    private Object getEventData(List<Object> args, DataListener dataListener) {
        if (dataListener instanceof MultiTypeEventListener) {
            return new MultiTypeArgs(args);
        }
        if (!args.isEmpty()) {
            return args.get(0);
        }
        return null;
    }

    public void onMessage(NamespaceClient client, String data, AckRequest ackRequest) {
        try {
            for (DataListener dataListener : this.messageListeners) {
                dataListener.onData(client, data, ackRequest);
            }
        }
        catch (Exception e) {
            this.exceptionListener.onMessageException(e, data, client);
        }
        this.sendAck(ackRequest);
    }

    public void onJsonObject(NamespaceClient client, Object data, AckRequest ackRequest) {
        Queue queue = (Queue)this.jsonObjectListeners.get(data.getClass());
        if (queue == null) {
            return;
        }
        try {
            for (DataListener dataListener : queue) {
                dataListener.onData(client, data, ackRequest);
            }
        }
        catch (Exception e) {
            this.exceptionListener.onJsonException(e, data, client);
        }
        this.sendAck(ackRequest);
    }

    @Override
    public void addDisconnectListener(DisconnectListener listener) {
        this.disconnectListeners.add(listener);
    }

    public void onDisconnect(SocketIOClient client) {
        this.allClients.remove(client.getSessionId());
        this.leave(this.getName(), client.getSessionId());
        this.storeFactory.pubSubStore().publish("leave", new JoinLeaveMessage(client.getSessionId(), this.getName(), this.getName()));
        try {
            for (DisconnectListener listener : this.disconnectListeners) {
                listener.onDisconnect(client);
            }
        }
        catch (Exception e) {
            this.exceptionListener.onDisconnectException(e, client);
        }
    }

    @Override
    public void addConnectListener(ConnectListener listener) {
        this.connectListeners.add(listener);
    }

    public void onConnect(SocketIOClient client) {
        this.join(this.getName(), client.getSessionId());
        this.storeFactory.pubSubStore().publish("join", new JoinLeaveMessage(client.getSessionId(), this.getName(), this.getName()));
        try {
            for (ConnectListener listener : this.connectListeners) {
                listener.onConnect(client);
            }
        }
        catch (Exception e) {
            this.exceptionListener.onConnectException(e, client);
        }
    }

    @Override
    public void addMessageListener(DataListener<String> listener) {
        this.messageListeners.add(listener);
    }

    public Queue<DataListener<String>> getMessageListeners() {
        return this.messageListeners;
    }

    @Override
    public BroadcastOperations getBroadcastOperations() {
        return new BroadcastOperations(this.allClients.values(), this.storeFactory);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Namespace other = (Namespace)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Override
    public void addListeners(Object listeners) {
        this.addListeners(listeners, listeners.getClass());
    }

    @Override
    public void addListeners(Object listeners, Class listenersClass) {
        this.engine.scan(this, listeners, listenersClass);
    }

    public void joinRoom(String room, UUID sessionId) {
        this.join(room, sessionId);
        this.storeFactory.pubSubStore().publish("join", new JoinLeaveMessage(sessionId, room, this.getName()));
    }

    public void dispatch(String room, Packet packet) {
        Iterable<SocketIOClient> clients = this.getRoomClients(room);
        for (SocketIOClient socketIOClient : clients) {
            socketIOClient.send(packet);
        }
    }

    public void join(String room, UUID sessionId) {
        Queue oldClients;
        Queue<UUID> clients = (ConcurrentLinkedQueue<UUID>)this.roomClients.get(room);
        if (clients == null && (oldClients = (Queue)this.roomClients.putIfAbsent(room, clients = new ConcurrentLinkedQueue<UUID>())) != null) {
            clients = oldClients;
        }
        clients.add(sessionId);
        if (clients != this.roomClients.get(room)) {
            this.joinRoom(room, sessionId);
        }
    }

    public void leaveRoom(String room, UUID sessionId) {
        this.leave(room, sessionId);
        this.storeFactory.pubSubStore().publish("leave", new JoinLeaveMessage(sessionId, room, this.getName()));
    }

    public void leave(String room, UUID sessionId) {
        Queue clients = (Queue)this.roomClients.get(room);
        if (clients == null) {
            return;
        }
        clients.remove(sessionId);
        if (clients.isEmpty()) {
            clients = (Queue)this.roomClients.remove(room);
            for (UUID clientId : clients) {
                this.joinRoom(room, clientId);
            }
        }
    }

    public List<String> getRooms(SocketIOClient client) {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry entry : this.roomClients.entrySet()) {
            if (!((Queue)entry.getValue()).contains(client.getSessionId())) continue;
            result.add((String)entry.getKey());
        }
        return result;
    }

    public Iterable<SocketIOClient> getRoomClients(String room) {
        Queue sessionIds = (Queue)this.roomClients.get(room);
        if (sessionIds == null) {
            return Collections.emptyList();
        }
        ArrayList<SocketIOClient> result = new ArrayList<SocketIOClient>();
        for (SocketIOClient client : this.allClients.values()) {
            if (!sessionIds.contains(client.getSessionId())) continue;
            result.add(client);
        }
        return result;
    }

    public boolean isEmpty() {
        return this.allClients.isEmpty();
    }
}

