/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.annotation;

import com.corundumstudio.socketio.SocketIOServer;
import com.corundumstudio.socketio.annotation.OnConnect;
import com.corundumstudio.socketio.annotation.OnDisconnect;
import com.corundumstudio.socketio.annotation.OnEvent;
import com.corundumstudio.socketio.annotation.OnJsonObject;
import com.corundumstudio.socketio.annotation.OnMessage;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.util.ReflectionUtils;

public class SpringAnnotationScanner
implements BeanPostProcessor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final List<Class<? extends Annotation>> annotations = Arrays.asList(OnConnect.class, OnDisconnect.class, OnEvent.class, OnMessage.class, OnJsonObject.class);
    private final SocketIOServer socketIOServer;
    private Class originalBeanClass;

    public SpringAnnotationScanner(SocketIOServer socketIOServer) {
        this.socketIOServer = socketIOServer;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (this.originalBeanClass != null) {
            this.socketIOServer.addListeners(bean, this.originalBeanClass);
            this.log.info("{} bean listeners added", (Object)beanName);
            this.originalBeanClass = null;
        }
        return bean;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        final AtomicBoolean add = new AtomicBoolean();
        ReflectionUtils.doWithMethods(bean.getClass(), (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                add.set(true);
            }
        }, (ReflectionUtils.MethodFilter)new ReflectionUtils.MethodFilter(){

            public boolean matches(Method method) {
                for (Class annotationClass : SpringAnnotationScanner.this.annotations) {
                    if (!method.isAnnotationPresent(annotationClass)) continue;
                    return true;
                }
                return false;
            }
        });
        if (add.get()) {
            this.originalBeanClass = bean.getClass();
        }
        return bean;
    }
}

