/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.annotation;

import com.corundumstudio.socketio.AckRequest;
import com.corundumstudio.socketio.SocketIOClient;
import com.corundumstudio.socketio.annotation.AnnotationScanner;
import com.corundumstudio.socketio.annotation.OnMessage;
import com.corundumstudio.socketio.handler.SocketIOException;
import com.corundumstudio.socketio.listener.DataListener;
import com.corundumstudio.socketio.namespace.Namespace;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class OnMessageScanner
implements AnnotationScanner {
    @Override
    public Class<? extends Annotation> getScanAnnotation() {
        return OnMessage.class;
    }

    @Override
    public void addListener(Namespace namespace, final Object object, final Method method, Annotation annot) {
        final int socketIOClientIndex = this.paramIndex(method, SocketIOClient.class);
        final int ackRequestIndex = this.paramIndex(method, AckRequest.class);
        final int dataIndex = this.paramIndex(method, String.class);
        namespace.addMessageListener(new DataListener<String>(){

            @Override
            public void onData(SocketIOClient client, String data, AckRequest ackSender) {
                try {
                    Object[] args = new Object[method.getParameterTypes().length];
                    if (socketIOClientIndex != -1) {
                        args[socketIOClientIndex] = client;
                    }
                    if (ackRequestIndex != -1) {
                        args[ackRequestIndex] = ackSender;
                    }
                    if (dataIndex != -1) {
                        args[dataIndex] = data;
                    }
                    method.invoke(object, args);
                }
                catch (InvocationTargetException e) {
                    throw new SocketIOException(e.getCause());
                }
                catch (Exception e) {
                    throw new SocketIOException(e);
                }
            }
        });
    }

    private int paramIndex(Method method, Class clazz) {
        int index = 0;
        for (Class<?> type : method.getParameterTypes()) {
            if (type.equals(clazz)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @Override
    public void validate(Method method, Class clazz) {
        int paramsCount = 3;
        int socketIOClientIndex = this.paramIndex(method, SocketIOClient.class);
        int ackRequestIndex = this.paramIndex(method, AckRequest.class);
        int dataIndex = this.paramIndex(method, String.class);
        if (dataIndex == -1) {
            throw new IllegalArgumentException("Wrong OnMessage listener signature: " + clazz + "." + method.getName() + " Data parameter is mandatory.");
        }
        if (socketIOClientIndex == -1) {
            --paramsCount;
        }
        if (ackRequestIndex == -1) {
            --paramsCount;
        }
        if (paramsCount != method.getParameterTypes().length) {
            throw new IllegalArgumentException("Wrong OnMessage listener signature: " + clazz + "." + method.getName());
        }
    }
}

