/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.transport;

import com.corundumstudio.socketio.Configuration;
import com.corundumstudio.socketio.DisconnectableHub;
import com.corundumstudio.socketio.SocketIOClient;
import com.corundumstudio.socketio.Transport;
import com.corundumstudio.socketio.ack.AckManager;
import com.corundumstudio.socketio.handler.AuthorizeHandler;
import com.corundumstudio.socketio.messages.PacketsMessage;
import com.corundumstudio.socketio.messages.XHRErrorMessage;
import com.corundumstudio.socketio.messages.XHROutMessage;
import com.corundumstudio.socketio.parser.ErrorAdvice;
import com.corundumstudio.socketio.parser.ErrorReason;
import com.corundumstudio.socketio.parser.Packet;
import com.corundumstudio.socketio.parser.PacketType;
import com.corundumstudio.socketio.scheduler.CancelableScheduler;
import com.corundumstudio.socketio.scheduler.SchedulerKey;
import com.corundumstudio.socketio.transport.BaseTransport;
import com.corundumstudio.socketio.transport.MainBaseClient;
import com.corundumstudio.socketio.transport.XHRPollingClient;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class XHRPollingTransport
extends BaseTransport {
    public static final String NAME = "xhr-polling";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<UUID, XHRPollingClient> sessionId2Client = new ConcurrentHashMap<UUID, XHRPollingClient>();
    private final CancelableScheduler scheduler;
    private final AckManager ackManager;
    private final AuthorizeHandler authorizeHandler;
    private final DisconnectableHub disconnectable;
    private final Configuration configuration;
    private final String path;

    public XHRPollingTransport(String connectPath, AckManager ackManager, DisconnectableHub disconnectable, CancelableScheduler scheduler, AuthorizeHandler authorizeHandler, Configuration configuration) {
        this.path = connectPath + NAME + "/";
        this.ackManager = ackManager;
        this.authorizeHandler = authorizeHandler;
        this.configuration = configuration;
        this.disconnectable = disconnectable;
        this.scheduler = scheduler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        FullHttpRequest req;
        QueryStringDecoder queryDecoder;
        if (msg instanceof FullHttpRequest && (queryDecoder = new QueryStringDecoder((req = (FullHttpRequest)msg).getUri())).path().startsWith(this.path)) {
            try {
                this.handleMessage(req, queryDecoder, ctx);
            }
            finally {
                req.release();
            }
            return;
        }
        ctx.fireChannelRead(msg);
    }

    private void handleMessage(FullHttpRequest req, QueryStringDecoder queryDecoder, ChannelHandlerContext ctx) throws IOException {
        String[] parts = queryDecoder.path().split("/");
        if (parts.length > 3) {
            UUID sessionId = UUID.fromString(parts[4]);
            String origin = req.headers().get("Origin");
            if (queryDecoder.parameters().containsKey("disconnect")) {
                MainBaseClient client = this.sessionId2Client.get(sessionId);
                client.onChannelDisconnect();
                ctx.channel().write((Object)new XHROutMessage(origin, sessionId));
            } else if (HttpMethod.POST.equals((Object)req.getMethod())) {
                this.onPost(sessionId, ctx, origin, req.content());
            } else if (HttpMethod.GET.equals((Object)req.getMethod())) {
                this.onGet(sessionId, ctx, origin);
            }
        } else {
            this.log.warn("Wrong {} method request path: {}, from ip: {}. Channel closed!", new Object[]{req.getMethod(), this.path, ctx.channel().remoteAddress()});
            ctx.channel().close();
        }
    }

    private void scheduleNoop(final UUID sessionId) {
        SchedulerKey key = new SchedulerKey(SchedulerKey.Type.POLLING, sessionId);
        this.scheduler.cancel(key);
        this.scheduler.schedule(key, new Runnable(){

            @Override
            public void run() {
                XHRPollingClient client = (XHRPollingClient)XHRPollingTransport.this.sessionId2Client.get(sessionId);
                if (client != null) {
                    client.send(new Packet(PacketType.NOOP));
                }
            }
        }, this.configuration.getPollingDuration(), TimeUnit.SECONDS);
    }

    private void scheduleDisconnect(Channel channel, final UUID sessionId) {
        final SchedulerKey key = new SchedulerKey(SchedulerKey.Type.CLOSE_TIMEOUT, sessionId);
        this.scheduler.cancel(key);
        ChannelFuture future = channel.closeFuture();
        future.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                XHRPollingTransport.this.scheduler.schedule(key, new Runnable(){

                    @Override
                    public void run() {
                        XHRPollingClient client = (XHRPollingClient)XHRPollingTransport.this.sessionId2Client.get(sessionId);
                        if (client != null) {
                            client.onChannelDisconnect();
                            XHRPollingTransport.this.log.debug("Client: {} disconnected due to connection timeout", (Object)sessionId);
                        }
                    }
                }, XHRPollingTransport.this.configuration.getCloseTimeout(), TimeUnit.SECONDS);
            }
        });
    }

    private void onPost(UUID sessionId, ChannelHandlerContext ctx, String origin, ByteBuf content) throws IOException {
        XHRPollingClient client = this.sessionId2Client.get(sessionId);
        if (client == null) {
            this.log.debug("Client with sessionId: {} was already disconnected. Channel closed!", (Object)sessionId);
            ctx.channel().close();
            return;
        }
        ctx.channel().writeAndFlush((Object)new XHROutMessage(origin, sessionId));
        ctx.pipeline().fireChannelRead((Object)new PacketsMessage(client, content));
    }

    private void onGet(UUID sessionId, ChannelHandlerContext ctx, String origin) {
        if (!this.authorizeHandler.isSessionAuthorized(sessionId)) {
            this.sendError(ctx, origin, sessionId);
            return;
        }
        XHRPollingClient client = this.sessionId2Client.get(sessionId);
        if (client == null) {
            client = this.createClient(origin, ctx.channel(), sessionId);
        }
        client.bindChannel(ctx.channel(), origin);
        this.scheduleDisconnect(ctx.channel(), sessionId);
        this.scheduleNoop(sessionId);
    }

    private XHRPollingClient createClient(String origin, Channel channel, UUID sessionId) {
        XHRPollingClient client = new XHRPollingClient(this.ackManager, this.disconnectable, sessionId, Transport.XHRPOLLING, this.configuration.getStoreFactory());
        this.sessionId2Client.put(sessionId, client);
        client.bindChannel(channel, origin);
        this.authorizeHandler.connect(client);
        this.log.debug("Client for sessionId: {} was created", (Object)sessionId);
        return client;
    }

    private void sendError(ChannelHandlerContext ctx, String origin, UUID sessionId) {
        this.log.debug("Client with sessionId: {} was not found! Reconnect error response sended", (Object)sessionId);
        Packet packet = new Packet(PacketType.ERROR);
        packet.setReason(ErrorReason.CLIENT_NOT_HANDSHAKEN);
        packet.setAdvice(ErrorAdvice.RECONNECT);
        ctx.channel().write((Object)new XHRErrorMessage(packet, origin, sessionId));
    }

    @Override
    public void onDisconnect(MainBaseClient client) {
        if (client instanceof XHRPollingClient) {
            UUID sessionId = client.getSessionId();
            this.sessionId2Client.remove(sessionId);
            SchedulerKey noopKey = new SchedulerKey(SchedulerKey.Type.POLLING, sessionId);
            this.scheduler.cancel(noopKey);
            SchedulerKey closeTimeoutKey = new SchedulerKey(SchedulerKey.Type.CLOSE_TIMEOUT, sessionId);
            this.scheduler.cancel(closeTimeoutKey);
        }
    }

    public Iterable<SocketIOClient> getAllClients() {
        Collection<XHRPollingClient> clients = this.sessionId2Client.values();
        return this.getAllClients(clients);
    }
}

