/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.store.pubsub;

import com.corundumstudio.socketio.namespace.NamespacesHub;
import com.corundumstudio.socketio.parser.JsonSupport;
import com.corundumstudio.socketio.store.StoreFactory;
import com.corundumstudio.socketio.store.pubsub.DispatchMessage;
import com.corundumstudio.socketio.store.pubsub.JoinLeaveMessage;
import com.corundumstudio.socketio.store.pubsub.PubSubListener;
import com.corundumstudio.socketio.store.pubsub.PubSubStore;
import com.corundumstudio.socketio.transport.MainBaseClient;

public abstract class BaseStoreFactory
implements StoreFactory {
    private Long nodeId = (long)(Math.random() * 1000000.0);

    protected Long getNodeId() {
        return this.nodeId;
    }

    @Override
    public void init(final NamespacesHub namespacesHub, JsonSupport jsonSupport) {
        this.getPubSubStore().subscribe("dispatch", new PubSubListener<DispatchMessage>(){

            @Override
            public void onMessage(DispatchMessage msg) {
                String name = msg.getRoom();
                String[] parts = name.split("/");
                String namespaceName = name;
                if (parts.length > 1) {
                    namespaceName = parts[0];
                }
                namespacesHub.get(namespaceName).dispatch(name, msg.getPacket());
            }
        }, DispatchMessage.class);
        this.getPubSubStore().subscribe("join", new PubSubListener<JoinLeaveMessage>(){

            @Override
            public void onMessage(JoinLeaveMessage msg) {
                String name = msg.getRoom();
                String[] parts = name.split("/");
                String namespaceName = name;
                if (parts.length > 1) {
                    namespaceName = parts[0];
                }
                namespacesHub.get(namespaceName).join(name, msg.getSessionId());
            }
        }, JoinLeaveMessage.class);
        this.getPubSubStore().subscribe("leave", new PubSubListener<JoinLeaveMessage>(){

            @Override
            public void onMessage(JoinLeaveMessage msg) {
                String name = msg.getRoom();
                String[] parts = name.split("/");
                String namespaceName = name;
                if (parts.length > 1) {
                    namespaceName = parts[0];
                }
                namespacesHub.get(namespaceName).leave(name, msg.getSessionId());
            }
        }, JoinLeaveMessage.class);
    }

    @Override
    public abstract PubSubStore getPubSubStore();

    @Override
    public void onDisconnect(MainBaseClient client) {
    }
}

