/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.store;

import com.corundumstudio.socketio.store.Store;
import java.util.UUID;
import redis.clients.jedis.Jedis;

public class RedisStore
implements Store {
    private final Jedis client;
    private final String sessionId;

    public RedisStore(UUID sessionId, Jedis client) {
        this.sessionId = sessionId.toString();
        this.client = client;
    }

    @Override
    public void set(String key, String value) {
        this.client.hset(this.sessionId, key, value);
    }

    @Override
    public String get(String key) {
        return this.client.hget(this.sessionId, key);
    }

    @Override
    public boolean has(String key) {
        return this.client.hexists(this.sessionId, key);
    }

    @Override
    public void del(String key) {
        this.client.hdel(this.sessionId, new String[]{key});
    }
}

