/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.namespace;

import com.corundumstudio.socketio.SocketIOClient;
import com.corundumstudio.socketio.misc.CompositeIterable;
import com.corundumstudio.socketio.namespace.Namespace;
import com.corundumstudio.socketio.parser.JsonSupport;
import com.corundumstudio.socketio.store.StoreFactory;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class NamespacesHub {
    private final ConcurrentMap<String, Namespace> namespaces = new ConcurrentHashMap<String, Namespace>();
    private final JsonSupport jsonSupport;
    private final StoreFactory storeFactory;

    public NamespacesHub(JsonSupport jsonSupport, StoreFactory storeFactory) {
        this.jsonSupport = jsonSupport;
        this.storeFactory = storeFactory;
    }

    public Namespace create(String name) {
        Namespace oldNamespace;
        Namespace namespace = (Namespace)this.namespaces.get(name);
        if (namespace == null && (oldNamespace = this.namespaces.putIfAbsent(name, namespace = new Namespace(name, this.jsonSupport, this.storeFactory))) != null) {
            namespace = oldNamespace;
        }
        return namespace;
    }

    public Iterable<SocketIOClient> getRoomClients(String room) {
        ArrayList allClients = new ArrayList();
        for (Namespace namespace : this.namespaces.values()) {
            Iterable<SocketIOClient> clients = namespace.getRoomClients(room);
            allClients.add(clients);
        }
        return new CompositeIterable<SocketIOClient>(allClients);
    }

    public Namespace get(String name) {
        return (Namespace)this.namespaces.get(name);
    }

    public void remove(String name) {
        Namespace namespace = (Namespace)this.namespaces.remove(name);
        namespace.getBroadcastOperations().disconnect();
    }
}

