/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.annotation;

import com.corundumstudio.socketio.SocketIOClient;
import com.corundumstudio.socketio.annotation.AnnotationScanner;
import com.corundumstudio.socketio.annotation.OnConnect;
import com.corundumstudio.socketio.handler.SocketIOException;
import com.corundumstudio.socketio.listener.ConnectListener;
import com.corundumstudio.socketio.namespace.Namespace;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

public class OnConnectScanner
implements AnnotationScanner {
    @Override
    public Class<? extends Annotation> getScanAnnotation() {
        return OnConnect.class;
    }

    @Override
    public void addListener(Namespace namespace, final Object object, Class clazz, final Method method) {
        namespace.addConnectListener(new ConnectListener(){

            @Override
            public void onConnect(SocketIOClient client) {
                try {
                    method.invoke(object, client);
                }
                catch (Exception e) {
                    throw new SocketIOException(e);
                }
            }
        });
    }

    @Override
    public void validate(Method method, Class clazz) {
        if (method.getParameterTypes().length != 1) {
            throw new IllegalArgumentException("Wrong OnConnect listener signature: " + clazz + "." + method.getName());
        }
        boolean valid = false;
        for (Class<?> eventType : method.getParameterTypes()) {
            if (!eventType.equals(SocketIOClient.class)) continue;
            valid = true;
        }
        if (!valid) {
            throw new IllegalArgumentException("Wrong OnConnect listener signature: " + clazz + "." + method.getName());
        }
    }
}

