/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.ack;

import com.corundumstudio.socketio.AckCallback;
import com.corundumstudio.socketio.Disconnectable;
import com.corundumstudio.socketio.SocketIOClient;
import com.corundumstudio.socketio.ack.AckSchedulerKey;
import com.corundumstudio.socketio.parser.Packet;
import com.corundumstudio.socketio.scheduler.CancelableScheduler;
import com.corundumstudio.socketio.scheduler.SchedulerKey;
import com.corundumstudio.socketio.transport.MainBaseClient;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AckManager
implements Disconnectable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<UUID, AckEntry> ackEntries = new ConcurrentHashMap<UUID, AckEntry>();
    private final CancelableScheduler scheduler;

    public AckManager(CancelableScheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void initAckIndex(UUID sessionId, long index) {
        AckEntry ackEntry = this.getAckEntry(sessionId);
        ackEntry.initAckIndex(index);
    }

    private AckEntry getAckEntry(UUID sessionId) {
        AckEntry oldAckEntry;
        AckEntry ackEntry = this.ackEntries.get(sessionId);
        if (ackEntry == null && (oldAckEntry = this.ackEntries.put(sessionId, ackEntry = new AckEntry())) != null) {
            ackEntry = oldAckEntry;
        }
        return ackEntry;
    }

    public void onAck(SocketIOClient client, Packet packet) {
        AckSchedulerKey key = new AckSchedulerKey(SchedulerKey.Type.ACK_TIMEOUT, client.getSessionId(), packet.getAckId());
        this.scheduler.cancel(key);
        AckCallback callback = this.removeCallback(client.getSessionId(), packet.getAckId());
        if (callback != null) {
            Object param = null;
            if (!packet.getArgs().isEmpty()) {
                param = packet.getArgs().get(0);
            }
            callback.onSuccess(param);
        }
    }

    private AckCallback removeCallback(UUID sessionId, long index) {
        AckEntry ackEntry = this.ackEntries.get(sessionId);
        if (ackEntry != null) {
            return ackEntry.removeCallback(index);
        }
        return null;
    }

    public AckCallback<?> getCallback(UUID sessionId, long index) {
        AckEntry ackEntry = this.getAckEntry(sessionId);
        return ackEntry.getAckCallback(index);
    }

    public long registerAck(UUID sessionId, AckCallback callback) {
        AckEntry ackEntry = this.getAckEntry(sessionId);
        ackEntry.initAckIndex(0L);
        long index = ackEntry.addAckCallback(callback);
        if (this.log.isDebugEnabled()) {
            this.log.debug("AckCallback registered with id: {}", (Object)index);
        }
        this.scheduleTimeout(index, sessionId, callback);
        return index;
    }

    private void scheduleTimeout(final long index, final UUID sessionId, final AckCallback callback) {
        if (callback.getTimeout() == -1) {
            return;
        }
        AckSchedulerKey key = new AckSchedulerKey(SchedulerKey.Type.ACK_TIMEOUT, sessionId, index);
        this.scheduler.schedule(key, new Runnable(){

            @Override
            public void run() {
                AckManager.this.removeCallback(sessionId, index);
                callback.onTimeout();
            }
        }, callback.getTimeout(), TimeUnit.SECONDS);
    }

    @Override
    public void onDisconnect(MainBaseClient client) {
        this.ackEntries.remove(client.getSessionId());
    }

    class AckEntry {
        final Map<Long, AckCallback<?>> ackCallbacks = new ConcurrentHashMap();
        final AtomicLong ackIndex = new AtomicLong(-1L);

        AckEntry() {
        }

        public long addAckCallback(AckCallback<?> callback) {
            long index = this.ackIndex.incrementAndGet();
            this.ackCallbacks.put(index, callback);
            return index;
        }

        public Set<Long> getAckIndexes() {
            return this.ackCallbacks.keySet();
        }

        public AckCallback<?> getAckCallback(long index) {
            return this.ackCallbacks.get(index);
        }

        public AckCallback<?> removeCallback(long index) {
            return this.ackCallbacks.remove(index);
        }

        public void initAckIndex(long index) {
            this.ackIndex.compareAndSet(-1L, index);
        }
    }
}

