/*
 * Decompiled with CFR 0.152.
 */
package com.bigkoo.pickerview.utils;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;

public class ChinaDate {
    private static final long[] lunarInfo = new long[]{19416L, 19168L, 42352L, 21717L, 53856L, 55632L, 91476L, 22176L, 39632L, 21970L, 19168L, 42422L, 42192L, 53840L, 119381L, 46400L, 54944L, 44450L, 38320L, 84343L, 18800L, 42160L, 46261L, 27216L, 27968L, 109396L, 11104L, 38256L, 21234L, 18800L, 25958L, 54432L, 59984L, 28309L, 23248L, 11104L, 100067L, 37600L, 116951L, 51536L, 54432L, 120998L, 46416L, 22176L, 107956L, 9680L, 37584L, 53938L, 43344L, 46423L, 27808L, 46416L, 86869L, 19872L, 42448L, 83315L, 21200L, 43432L, 59728L, 27296L, 44710L, 43856L, 19296L, 43748L, 42352L, 21088L, 62051L, 55632L, 23383L, 22176L, 38608L, 19925L, 19152L, 42192L, 54484L, 53840L, 54616L, 46400L, 46496L, 103846L, 38320L, 18864L, 43380L, 42160L, 45690L, 27216L, 27968L, 44870L, 43872L, 38256L, 19189L, 18800L, 25776L, 29859L, 59984L, 27480L, 21952L, 43872L, 38613L, 37600L, 51552L, 55636L, 54432L, 55888L, 30034L, 22176L, 43959L, 9680L, 37584L, 51893L, 43344L, 46240L, 47780L, 44368L, 21977L, 19360L, 42416L, 86390L, 21168L, 43312L, 31060L, 27296L, 44368L, 23378L, 19296L, 42726L, 42208L, 53856L, 60005L, 54576L, 23200L, 30371L, 38608L, 19415L, 19152L, 42192L, 118966L, 53840L, 54560L, 56645L, 46496L, 22224L, 21938L, 18864L, 42359L, 42160L, 43600L, 111189L, 27936L, 44448L};
    private static final int[] year20 = new int[]{1, 4, 1, 2, 1, 2, 1, 1, 2, 1, 2, 1};
    private static final int[] year19 = new int[]{0, 3, 0, 1, 0, 1, 0, 0, 1, 0, 1, 0};
    private static final int[] year2000 = new int[]{0, 3, 1, 2, 1, 2, 1, 1, 2, 1, 2, 1};
    public static final String[] nStr1 = new String[]{"", "\u6b63", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d", "\u5341", "\u51ac", "\u814a"};
    private static final String[] Gan = new String[]{"\u7532", "\u4e59", "\u4e19", "\u4e01", "\u620a", "\u5df1", "\u5e9a", "\u8f9b", "\u58ec", "\u7678"};
    private static final String[] Zhi = new String[]{"\u5b50", "\u4e11", "\u5bc5", "\u536f", "\u8fb0", "\u5df3", "\u5348", "\u672a", "\u7533", "\u9149", "\u620c", "\u4ea5"};
    private static final String[] Animals = new String[]{"\u9f20", "\u725b", "\u864e", "\u5154", "\u9f99", "\u86c7", "\u9a6c", "\u7f8a", "\u7334", "\u9e21", "\u72d7", "\u732a"};
    private static final String[] solarTerm = new String[]{"\u5c0f\u5bd2", "\u5927\u5bd2", "\u7acb\u6625", "\u96e8\u6c34", "\u60ca\u86f0", "\u6625\u5206", "\u6e05\u660e", "\u8c37\u96e8", "\u7acb\u590f", "\u5c0f\u6ee1", "\u8292\u79cd", "\u590f\u81f3", "\u5c0f\u6691", "\u5927\u6691", "\u7acb\u79cb", "\u5904\u6691", "\u767d\u9732", "\u79cb\u5206", "\u5bd2\u9732", "\u971c\u964d", "\u7acb\u51ac", "\u5c0f\u96ea", "\u5927\u96ea", "\u51ac\u81f3"};
    private static final String[] sFtv = new String[]{"0101*\u5143\u65e6", "0214 \u60c5\u4eba\u8282", "0308 \u5987\u5973\u8282", "0312 \u690d\u6811\u8282", "0315 \u6d88\u8d39\u8005\u6743\u76ca\u65e5", "0401 \u611a\u4eba\u8282", "0501 \u52b3\u52a8\u8282", "0504 \u9752\u5e74\u8282", "0512 \u62a4\u58eb\u8282", "0601 \u513f\u7ae5\u8282", "0701 \u5efa\u515a\u8282", "0801 \u5efa\u519b\u8282", "0808 \u7236\u4eb2\u8282", "0909 mzd\u901d\u4e16\u7eaa\u5ff5", "0910 \u6559\u5e08\u8282", "0928 \u5b54\u5b50\u8bde\u8fb0", "1001*\u56fd\u5e86\u8282", "1006 \u8001\u4eba\u8282", "1024 \u8054\u5408\u56fd\u65e5", "1112 \u5b59\u4e2d\u5c71\u8bde\u8fb0", "1220 \u6fb3\u95e8\u56de\u5f52", "1225 \u5723\u8bde\u8282", "1226 mzd\u8bde\u8fb0"};
    private static final String[] lFtv = new String[]{"0101*\u519c\u5386\u6625\u8282", "0115 \u5143\u5bb5\u8282", "0505 \u7aef\u5348\u8282", "0707 \u4e03\u5915\u60c5\u4eba\u8282", "0815 \u4e2d\u79cb\u8282", "0909 \u91cd\u9633\u8282", "1208 \u814a\u516b\u8282", "1224 \u5c0f\u5e74", "0100*\u9664\u5915"};
    private static final int[] dayArr = new int[]{20, 19, 21, 20, 21, 22, 23, 23, 23, 24, 23, 22};
    private static final String[] constellationArr = new String[]{"\u6469\u7faf\u5ea7", "\u6c34\u74f6\u5ea7", "\u53cc\u9c7c\u5ea7", "\u767d\u7f8a\u5ea7", "\u91d1\u725b\u5ea7", "\u53cc\u5b50\u5ea7", "\u5de8\u87f9\u5ea7", "\u72ee\u5b50\u5ea7", "\u5904\u5973\u5ea7", "\u5929\u79e4\u5ea7", "\u5929\u874e\u5ea7", "\u5c04\u624b\u5ea7", "\u6469\u7faf\u5ea7"};
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy\u5e74M\u6708d\u65e5 EEEEE");

    private static final int lYearDays(int y) {
        int sum = 348;
        for (int i = 32768; i > 8; i >>= 1) {
            if ((lunarInfo[y - 1900] & (long)i) == 0L) continue;
            ++sum;
        }
        return sum + ChinaDate.leapDays(y);
    }

    public static final int leapDays(int y) {
        if (ChinaDate.leapMonth(y) != 0) {
            if ((lunarInfo[y - 1900] & 0x10000L) != 0L) {
                return 30;
            }
            return 29;
        }
        return 0;
    }

    public static final int leapMonth(int y) {
        return (int)(lunarInfo[y - 1900] & 0xFL);
    }

    public static final int monthDays(int y, int m) {
        if ((lunarInfo[y - 1900] & (long)(65536 >> m)) == 0L) {
            return 29;
        }
        return 30;
    }

    public static final String AnimalsYear(int y) {
        return Animals[(y - 4) % 12];
    }

    private static final String cyclicalm(int num) {
        return Gan[num % 10] + Zhi[num % 12];
    }

    public static final String cyclical(int y) {
        int num = y - 1900 + 36;
        return ChinaDate.cyclicalm(num);
    }

    private final long[] Lunar(int y, int m) {
        long[] nongDate = new long[7];
        int i = 0;
        int temp = 0;
        int leap = 0;
        Date baseDate = new GregorianCalendar(3800, 1, 31).getTime();
        Date objDate = new GregorianCalendar(y + 1900, m, 1).getTime();
        long offset = (objDate.getTime() - baseDate.getTime()) / 86400000L;
        if (y < 2000) {
            offset += (long)year19[m - 1];
        }
        if (y > 2000) {
            offset += (long)year20[m - 1];
        }
        if (y == 2000) {
            offset += (long)year2000[m - 1];
        }
        nongDate[5] = offset + 40L;
        nongDate[4] = 14L;
        for (i = 1900; i < 2050 && offset > 0L; offset -= (long)temp, ++i) {
            temp = ChinaDate.lYearDays(i);
            nongDate[4] = nongDate[4] + 12L;
        }
        if (offset < 0L) {
            offset += (long)temp;
            --i;
            nongDate[4] = nongDate[4] - 12L;
        }
        nongDate[0] = i;
        nongDate[3] = i - 1864;
        leap = ChinaDate.leapMonth(i);
        nongDate[6] = 0L;
        for (i = 1; i < 13 && offset > 0L; ++i) {
            if (leap > 0 && i == leap + 1 && nongDate[6] == 0L) {
                --i;
                nongDate[6] = 1L;
                temp = ChinaDate.leapDays((int)nongDate[0]);
            } else {
                temp = ChinaDate.monthDays((int)nongDate[0], i);
            }
            if (nongDate[6] == 1L && i == leap + 1) {
                nongDate[6] = 0L;
            }
            offset -= (long)temp;
            if (nongDate[6] != 0L) continue;
            nongDate[4] = nongDate[4] + 1L;
        }
        if (offset == 0L && leap > 0 && i == leap + 1) {
            if (nongDate[6] == 1L) {
                nongDate[6] = 0L;
            } else {
                nongDate[6] = 1L;
                --i;
                nongDate[4] = nongDate[4] - 1L;
            }
        }
        if (offset < 0L) {
            offset += (long)temp;
            --i;
            nongDate[4] = nongDate[4] - 1L;
        }
        nongDate[1] = i;
        nongDate[2] = offset + 1L;
        return nongDate;
    }

    public static final long[] calElement(int y, int m, int d) {
        long[] nongDate = new long[7];
        int i = 0;
        int temp = 0;
        int leap = 0;
        Date baseDate = new GregorianCalendar(1900, 0, 31).getTime();
        Date objDate = new GregorianCalendar(y, m - 1, d).getTime();
        long offset = (objDate.getTime() - baseDate.getTime()) / 86400000L;
        nongDate[5] = offset + 40L;
        nongDate[4] = 14L;
        for (i = 1900; i < 2050 && offset > 0L; offset -= (long)temp, ++i) {
            temp = ChinaDate.lYearDays(i);
            nongDate[4] = nongDate[4] + 12L;
        }
        if (offset < 0L) {
            offset += (long)temp;
            --i;
            nongDate[4] = nongDate[4] - 12L;
        }
        nongDate[0] = i;
        nongDate[3] = i - 1864;
        leap = ChinaDate.leapMonth(i);
        nongDate[6] = 0L;
        for (i = 1; i < 13 && offset > 0L; ++i) {
            if (leap > 0 && i == leap + 1 && nongDate[6] == 0L) {
                --i;
                nongDate[6] = 1L;
                temp = ChinaDate.leapDays((int)nongDate[0]);
            } else {
                temp = ChinaDate.monthDays((int)nongDate[0], i);
            }
            if (nongDate[6] == 1L && i == leap + 1) {
                nongDate[6] = 0L;
            }
            offset -= (long)temp;
            if (nongDate[6] != 0L) continue;
            nongDate[4] = nongDate[4] + 1L;
        }
        if (offset == 0L && leap > 0 && i == leap + 1) {
            if (nongDate[6] == 1L) {
                nongDate[6] = 0L;
            } else {
                nongDate[6] = 1L;
                --i;
                nongDate[4] = nongDate[4] - 1L;
            }
        }
        if (offset < 0L) {
            offset += (long)temp;
            --i;
            nongDate[4] = nongDate[4] - 1L;
        }
        nongDate[1] = i;
        nongDate[2] = offset + 1L;
        return nongDate;
    }

    public static final String getChinaDate(int day) {
        String a = "";
        if (day == 10) {
            return "\u521d\u5341";
        }
        if (day == 20) {
            return "\u4e8c\u5341";
        }
        if (day == 30) {
            return "\u4e09\u5341";
        }
        int two = day / 10;
        if (two == 0) {
            a = "\u521d";
        }
        if (two == 1) {
            a = "\u5341";
        }
        if (two == 2) {
            a = "\u5eff";
        }
        if (two == 3) {
            a = "\u4e09";
        }
        int one = day % 10;
        switch (one) {
            case 1: {
                a = a + "\u4e00";
                break;
            }
            case 2: {
                a = a + "\u4e8c";
                break;
            }
            case 3: {
                a = a + "\u4e09";
                break;
            }
            case 4: {
                a = a + "\u56db";
                break;
            }
            case 5: {
                a = a + "\u4e94";
                break;
            }
            case 6: {
                a = a + "\u516d";
                break;
            }
            case 7: {
                a = a + "\u4e03";
                break;
            }
            case 8: {
                a = a + "\u516b";
                break;
            }
            case 9: {
                a = a + "\u4e5d";
            }
        }
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String today() {
        Calendar today = Calendar.getInstance(Locale.SIMPLIFIED_CHINESE);
        int year = today.get(1);
        int month = today.get(2) + 1;
        int date = today.get(5);
        long[] l = ChinaDate.calElement(year, month, date);
        StringBuffer sToday = new StringBuffer();
        try {
            sToday.append(sdf.format(today.getTime()));
            sToday.append(" \u519c\u5386");
            sToday.append(ChinaDate.cyclical(year));
            sToday.append('(');
            sToday.append(ChinaDate.AnimalsYear(year));
            sToday.append(")\u5e74");
            sToday.append(nStr1[(int)l[1]]);
            sToday.append("\u6708");
            sToday.append(ChinaDate.getChinaDate((int)l[2]));
            String string2 = sToday.toString();
            return string2;
        }
        finally {
            sToday = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String oneDay(int year, int month, int day) {
        long[] l = ChinaDate.calElement(year, month, day);
        StringBuffer sToday = new StringBuffer();
        try {
            sToday.append(" \u519c\u5386");
            sToday.append(ChinaDate.cyclical(year));
            sToday.append('(');
            sToday.append(ChinaDate.AnimalsYear(year));
            sToday.append(")\u5e74");
            sToday.append(nStr1[(int)l[1]]);
            sToday.append("\u6708");
            sToday.append(ChinaDate.getChinaDate((int)l[2]));
            String string2 = sToday.toString();
            return string2;
        }
        finally {
            sToday = null;
        }
    }

    public static String getConstellation(int month, int day) {
        return day < dayArr[month - 1] ? constellationArr[month - 1] : constellationArr[month];
    }

    public static int getMonthByYear(int year) {
        if (ChinaDate.leapMonth(year) == 0) {
            return 12;
        }
        return 13;
    }

    public static String getLunarYearText(int lunarYear) {
        return Gan[(lunarYear - 4) % 10] + Zhi[(lunarYear - 4) % 12] + "\u5e74";
    }

    public static ArrayList<String> getYears(int startYear, int endYear) {
        ArrayList<String> years = new ArrayList<String>();
        for (int i = startYear; i < endYear; ++i) {
            years.add(String.format("%s(%d)", ChinaDate.getLunarYearText(i), i));
        }
        return years;
    }

    public static ArrayList<String> getMonths(int year) {
        ArrayList<String> baseMonths = new ArrayList<String>();
        for (int i = 1; i < nStr1.length; ++i) {
            baseMonths.add(nStr1[i] + "\u6708");
        }
        if (ChinaDate.leapMonth(year) != 0) {
            baseMonths.add(ChinaDate.leapMonth(year), "\u95f0" + nStr1[ChinaDate.leapMonth(year)] + "\u6708");
        }
        return baseMonths;
    }

    public static ArrayList<String> getLunarDays(int maxDay) {
        ArrayList<String> days = new ArrayList<String>();
        for (int i = 1; i <= maxDay; ++i) {
            days.add(ChinaDate.getChinaDate(i));
        }
        return days;
    }
}

