/*
 * Decompiled with CFR 0.152.
 */
package com.bigkoo.pickerview.lib;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.os.Build;
import android.os.Handler;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import com.bigkoo.pickerview.R;
import com.bigkoo.pickerview.adapter.WheelAdapter;
import com.bigkoo.pickerview.lib.InertiaTimerTask;
import com.bigkoo.pickerview.lib.LoopViewGestureListener;
import com.bigkoo.pickerview.lib.MessageHandler;
import com.bigkoo.pickerview.lib.OnItemSelectedRunnable;
import com.bigkoo.pickerview.lib.SmoothScrollTimerTask;
import com.bigkoo.pickerview.listener.OnItemSelectedListener;
import com.bigkoo.pickerview.model.IPickerViewData;
import java.util.Locale;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class WheelView
extends View {
    private DividerType dividerType;
    Context context;
    Handler handler;
    private GestureDetector gestureDetector;
    OnItemSelectedListener onItemSelectedListener;
    private boolean isOptions = false;
    private boolean isCenterLabel = true;
    ScheduledExecutorService mExecutor = Executors.newSingleThreadScheduledExecutor();
    private ScheduledFuture<?> mFuture;
    Paint paintOuterText;
    Paint paintCenterText;
    Paint paintIndicator;
    WheelAdapter adapter;
    private String label;
    int textSize;
    int maxTextWidth;
    int maxTextHeight;
    float itemHeight;
    Typeface typeface = Typeface.MONOSPACE;
    int textColorOut = -5723992;
    int textColorCenter = -14013910;
    int dividerColor = -2763307;
    float lineSpacingMultiplier = 1.6f;
    boolean isLoop;
    float firstLineY;
    float secondLineY;
    float centerY;
    float totalScrollY;
    int initPosition;
    private int selectedItem;
    int preCurrentIndex;
    int change;
    int itemsVisible = 11;
    int measuredHeight;
    int measuredWidth;
    int halfCircumference;
    int radius;
    private int mOffset = 0;
    private float previousY = 0.0f;
    long startTime = 0L;
    private static final int VELOCITYFLING = 5;
    int widthMeasureSpec;
    private int mGravity = 17;
    private int drawCenterContentStart = 0;
    private int drawOutContentStart = 0;
    private static final float SCALECONTENT = 0.8f;
    private float CENTERCONTENTOFFSET;

    public WheelView(Context context) {
        this(context, null);
    }

    public WheelView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.textSize = this.getResources().getDimensionPixelSize(R.dimen.pickerview_textsize);
        DisplayMetrics dm = this.getResources().getDisplayMetrics();
        float density = dm.density;
        if (density < 1.0f) {
            this.CENTERCONTENTOFFSET = 2.4f;
        } else if (1.0f <= density && density < 2.0f) {
            this.CENTERCONTENTOFFSET = 3.6f;
        } else if (1.0f <= density && density < 2.0f) {
            this.CENTERCONTENTOFFSET = 4.5f;
        } else if (2.0f <= density && density < 3.0f) {
            this.CENTERCONTENTOFFSET = 6.0f;
        } else if (density >= 3.0f) {
            this.CENTERCONTENTOFFSET = density * 2.5f;
        }
        if (attrs != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.pickerview, 0, 0);
            this.mGravity = a.getInt(R.styleable.pickerview_pickerview_gravity, 17);
            this.textColorOut = a.getColor(R.styleable.pickerview_pickerview_textColorOut, this.textColorOut);
            this.textColorCenter = a.getColor(R.styleable.pickerview_pickerview_textColorCenter, this.textColorCenter);
            this.dividerColor = a.getColor(R.styleable.pickerview_pickerview_dividerColor, this.dividerColor);
            this.textSize = a.getDimensionPixelOffset(R.styleable.pickerview_pickerview_textSize, this.textSize);
            this.lineSpacingMultiplier = a.getFloat(R.styleable.pickerview_pickerview_lineSpacingMultiplier, this.lineSpacingMultiplier);
            a.recycle();
        }
        this.judgeLineSpae();
        this.initLoopView(context);
    }

    private void judgeLineSpae() {
        if (this.lineSpacingMultiplier < 1.2f) {
            this.lineSpacingMultiplier = 1.2f;
        } else if (this.lineSpacingMultiplier > 2.0f) {
            this.lineSpacingMultiplier = 2.0f;
        }
    }

    private void initLoopView(Context context) {
        this.context = context;
        this.handler = new MessageHandler(this);
        this.gestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new LoopViewGestureListener(this));
        this.gestureDetector.setIsLongpressEnabled(false);
        this.isLoop = true;
        this.totalScrollY = 0.0f;
        this.initPosition = -1;
        this.initPaints();
    }

    private void initPaints() {
        this.paintOuterText = new Paint();
        this.paintOuterText.setColor(this.textColorOut);
        this.paintOuterText.setAntiAlias(true);
        this.paintOuterText.setTypeface(this.typeface);
        this.paintOuterText.setTextSize((float)this.textSize);
        this.paintCenterText = new Paint();
        this.paintCenterText.setColor(this.textColorCenter);
        this.paintCenterText.setAntiAlias(true);
        this.paintCenterText.setTextScaleX(1.1f);
        this.paintCenterText.setTypeface(this.typeface);
        this.paintCenterText.setTextSize((float)this.textSize);
        this.paintIndicator = new Paint();
        this.paintIndicator.setColor(this.dividerColor);
        this.paintIndicator.setAntiAlias(true);
        if (Build.VERSION.SDK_INT >= 11) {
            this.setLayerType(1, null);
        }
    }

    private void remeasure() {
        if (this.adapter == null) {
            return;
        }
        this.measureTextWidthHeight();
        this.halfCircumference = (int)(this.itemHeight * (float)(this.itemsVisible - 1));
        this.measuredHeight = (int)((double)(this.halfCircumference * 2) / Math.PI);
        this.radius = (int)((double)this.halfCircumference / Math.PI);
        this.measuredWidth = View.MeasureSpec.getSize((int)this.widthMeasureSpec);
        this.firstLineY = ((float)this.measuredHeight - this.itemHeight) / 2.0f;
        this.secondLineY = ((float)this.measuredHeight + this.itemHeight) / 2.0f;
        this.centerY = this.secondLineY - (this.itemHeight - (float)this.maxTextHeight) / 2.0f - this.CENTERCONTENTOFFSET;
        if (this.initPosition == -1) {
            this.initPosition = this.isLoop ? (this.adapter.getItemsCount() + 1) / 2 : 0;
        }
        this.preCurrentIndex = this.initPosition;
    }

    private void measureTextWidthHeight() {
        Rect rect = new Rect();
        for (int i = 0; i < this.adapter.getItemsCount(); ++i) {
            String s1 = this.getContentText(this.adapter.getItem(i));
            this.paintCenterText.getTextBounds(s1, 0, s1.length(), rect);
            int textWidth = rect.width();
            if (textWidth > this.maxTextWidth) {
                this.maxTextWidth = textWidth;
            }
            this.paintCenterText.getTextBounds("\u661f\u671f", 0, 2, rect);
            this.maxTextHeight = rect.height() + 2;
        }
        this.itemHeight = this.lineSpacingMultiplier * (float)this.maxTextHeight;
    }

    void smoothScroll(ACTION action) {
        this.cancelFuture();
        if (action == ACTION.FLING || action == ACTION.DAGGLE) {
            this.mOffset = (int)((this.totalScrollY % this.itemHeight + this.itemHeight) % this.itemHeight);
            this.mOffset = (float)this.mOffset > this.itemHeight / 2.0f ? (int)(this.itemHeight - (float)this.mOffset) : -this.mOffset;
        }
        this.mFuture = this.mExecutor.scheduleWithFixedDelay(new SmoothScrollTimerTask(this, this.mOffset), 0L, 10L, TimeUnit.MILLISECONDS);
    }

    protected final void scrollBy(float velocityY) {
        this.cancelFuture();
        this.mFuture = this.mExecutor.scheduleWithFixedDelay(new InertiaTimerTask(this, velocityY), 0L, 5L, TimeUnit.MILLISECONDS);
    }

    public void cancelFuture() {
        if (this.mFuture != null && !this.mFuture.isCancelled()) {
            this.mFuture.cancel(true);
            this.mFuture = null;
        }
    }

    public final void setCyclic(boolean cyclic) {
        this.isLoop = cyclic;
    }

    public final void setTypeface(Typeface font) {
        this.typeface = font;
        this.paintOuterText.setTypeface(this.typeface);
        this.paintCenterText.setTypeface(this.typeface);
    }

    public final void setTextSize(float size) {
        if (size > 0.0f) {
            this.textSize = (int)(this.context.getResources().getDisplayMetrics().density * size);
            this.paintOuterText.setTextSize((float)this.textSize);
            this.paintCenterText.setTextSize((float)this.textSize);
        }
    }

    public final void setCurrentItem(int currentItem) {
        this.selectedItem = currentItem;
        this.initPosition = currentItem;
        this.totalScrollY = 0.0f;
        this.invalidate();
    }

    public final void setOnItemSelectedListener(OnItemSelectedListener OnItemSelectedListener2) {
        this.onItemSelectedListener = OnItemSelectedListener2;
    }

    public final void setAdapter(WheelAdapter adapter) {
        this.adapter = adapter;
        this.remeasure();
        this.invalidate();
    }

    public final WheelAdapter getAdapter() {
        return this.adapter;
    }

    public final int getCurrentItem() {
        return this.selectedItem;
    }

    protected final void onItemSelected() {
        if (this.onItemSelectedListener != null) {
            this.postDelayed(new OnItemSelectedRunnable(this), 200L);
        }
    }

    protected void onDraw(Canvas canvas) {
        int counter;
        if (this.adapter == null) {
            return;
        }
        if (this.initPosition < 0) {
            this.initPosition = 0;
        }
        if (this.initPosition >= this.adapter.getItemsCount()) {
            this.initPosition = this.adapter.getItemsCount() - 1;
        }
        Object[] visibles = new Object[this.itemsVisible];
        this.change = (int)(this.totalScrollY / this.itemHeight);
        try {
            this.preCurrentIndex = this.initPosition + this.change % this.adapter.getItemsCount();
        }
        catch (ArithmeticException e) {
            Log.e((String)"WheelView", (String)"\u51fa\u9519\u4e86\uff01adapter.getItemsCount() == 0\uff0c\u8054\u52a8\u6570\u636e\u4e0d\u5339\u914d");
        }
        if (!this.isLoop) {
            if (this.preCurrentIndex < 0) {
                this.preCurrentIndex = 0;
            }
            if (this.preCurrentIndex > this.adapter.getItemsCount() - 1) {
                this.preCurrentIndex = this.adapter.getItemsCount() - 1;
            }
        } else {
            if (this.preCurrentIndex < 0) {
                this.preCurrentIndex = this.adapter.getItemsCount() + this.preCurrentIndex;
            }
            if (this.preCurrentIndex > this.adapter.getItemsCount() - 1) {
                this.preCurrentIndex -= this.adapter.getItemsCount();
            }
        }
        float itemHeightOffset = this.totalScrollY % this.itemHeight;
        for (counter = 0; counter < this.itemsVisible; ++counter) {
            int index = this.preCurrentIndex - (this.itemsVisible / 2 - counter);
            if (this.isLoop) {
                index = this.getLoopMappingIndex(index);
                visibles[counter] = this.adapter.getItem(index);
                continue;
            }
            visibles[counter] = index < 0 ? "" : (index > this.adapter.getItemsCount() - 1 ? "" : this.adapter.getItem(index));
        }
        if (this.dividerType == DividerType.WRAP) {
            float startX = TextUtils.isEmpty((CharSequence)this.label) ? (float)((this.measuredWidth - this.maxTextWidth) / 2 - 12) : (float)((this.measuredWidth - this.maxTextWidth) / 4 - 12);
            if (startX <= 0.0f) {
                startX = 10.0f;
            }
            float endX = (float)this.measuredWidth - startX;
            canvas.drawLine(startX, this.firstLineY, endX, this.firstLineY, this.paintIndicator);
            canvas.drawLine(startX, this.secondLineY, endX, this.secondLineY, this.paintIndicator);
        } else {
            canvas.drawLine(0.0f, this.firstLineY, (float)this.measuredWidth, this.firstLineY, this.paintIndicator);
            canvas.drawLine(0.0f, this.secondLineY, (float)this.measuredWidth, this.secondLineY, this.paintIndicator);
        }
        if (!TextUtils.isEmpty((CharSequence)this.label) && this.isCenterLabel) {
            int drawRightContentStart = this.measuredWidth - this.getTextWidth(this.paintCenterText, this.label);
            canvas.drawText(this.label, (float)drawRightContentStart - this.CENTERCONTENTOFFSET, this.centerY, this.paintCenterText);
        }
        for (counter = 0; counter < this.itemsVisible; ++counter) {
            canvas.save();
            double radian = (this.itemHeight * (float)counter - itemHeightOffset) / (float)this.radius;
            float angle = (float)(90.0 - radian / Math.PI * 180.0);
            if (angle >= 90.0f || angle <= -90.0f) {
                canvas.restore();
                continue;
            }
            String contentText = !this.isCenterLabel && !TextUtils.isEmpty((CharSequence)this.label) && !TextUtils.isEmpty((CharSequence)this.getContentText(visibles[counter])) ? this.getContentText(visibles[counter]) + this.label : this.getContentText(visibles[counter]);
            this.reMeasureTextSize(contentText);
            this.measuredCenterContentStart(contentText);
            this.measuredOutContentStart(contentText);
            float translateY = (float)((double)this.radius - Math.cos(radian) * (double)this.radius - Math.sin(radian) * (double)this.maxTextHeight / 2.0);
            canvas.translate(0.0f, translateY);
            canvas.scale(1.0f, (float)Math.sin(radian));
            if (translateY <= this.firstLineY && (float)this.maxTextHeight + translateY >= this.firstLineY) {
                canvas.save();
                canvas.clipRect(0.0f, 0.0f, (float)this.measuredWidth, this.firstLineY - translateY);
                canvas.scale(1.0f, (float)Math.sin(radian) * 0.8f);
                canvas.drawText(contentText, (float)this.drawOutContentStart, (float)this.maxTextHeight, this.paintOuterText);
                canvas.restore();
                canvas.save();
                canvas.clipRect(0.0f, this.firstLineY - translateY, (float)this.measuredWidth, (float)((int)this.itemHeight));
                canvas.scale(1.0f, (float)Math.sin(radian) * 1.0f);
                canvas.drawText(contentText, (float)this.drawCenterContentStart, (float)this.maxTextHeight - this.CENTERCONTENTOFFSET, this.paintCenterText);
                canvas.restore();
            } else if (translateY <= this.secondLineY && (float)this.maxTextHeight + translateY >= this.secondLineY) {
                canvas.save();
                canvas.clipRect(0.0f, 0.0f, (float)this.measuredWidth, this.secondLineY - translateY);
                canvas.scale(1.0f, (float)Math.sin(radian) * 1.0f);
                canvas.drawText(contentText, (float)this.drawCenterContentStart, (float)this.maxTextHeight - this.CENTERCONTENTOFFSET, this.paintCenterText);
                canvas.restore();
                canvas.save();
                canvas.clipRect(0.0f, this.secondLineY - translateY, (float)this.measuredWidth, (float)((int)this.itemHeight));
                canvas.scale(1.0f, (float)Math.sin(radian) * 0.8f);
                canvas.drawText(contentText, (float)this.drawOutContentStart, (float)this.maxTextHeight, this.paintOuterText);
                canvas.restore();
            } else if (translateY >= this.firstLineY && (float)this.maxTextHeight + translateY <= this.secondLineY) {
                int preSelectedItem;
                float Y = (float)this.maxTextHeight - this.CENTERCONTENTOFFSET;
                canvas.drawText(contentText, (float)this.drawCenterContentStart, Y, this.paintCenterText);
                this.selectedItem = preSelectedItem = this.adapter.indexOf(visibles[counter]);
            } else {
                canvas.save();
                canvas.clipRect(0, 0, this.measuredWidth, (int)this.itemHeight);
                canvas.scale(1.0f, (float)Math.sin(radian) * 0.8f);
                canvas.drawText(contentText, (float)this.drawOutContentStart, (float)this.maxTextHeight, this.paintOuterText);
                canvas.restore();
            }
            canvas.restore();
            this.paintCenterText.setTextSize((float)this.textSize);
        }
    }

    private void reMeasureTextSize(String contentText) {
        Rect rect = new Rect();
        this.paintCenterText.getTextBounds(contentText, 0, contentText.length(), rect);
        int width = rect.width();
        int size = this.textSize;
        while (width > this.measuredWidth) {
            this.paintCenterText.setTextSize((float)(--size));
            this.paintCenterText.getTextBounds(contentText, 0, contentText.length(), rect);
            width = rect.width();
        }
        this.paintOuterText.setTextSize((float)size);
    }

    private int getLoopMappingIndex(int index) {
        if (index < 0) {
            index += this.adapter.getItemsCount();
            index = this.getLoopMappingIndex(index);
        } else if (index > this.adapter.getItemsCount() - 1) {
            index -= this.adapter.getItemsCount();
            index = this.getLoopMappingIndex(index);
        }
        return index;
    }

    private String getContentText(Object item) {
        if (item == null) {
            return "";
        }
        if (item instanceof IPickerViewData) {
            return ((IPickerViewData)item).getPickerViewText();
        }
        if (item instanceof Integer) {
            return String.format(Locale.getDefault(), "%02d", (int)((Integer)item));
        }
        return item.toString();
    }

    private void measuredCenterContentStart(String content) {
        Rect rect = new Rect();
        this.paintCenterText.getTextBounds(content, 0, content.length(), rect);
        switch (this.mGravity) {
            case 17: {
                if (this.isOptions || this.label == null || this.label.equals("") || !this.isCenterLabel) {
                    this.drawCenterContentStart = (int)((double)(this.measuredWidth - rect.width()) * 0.5);
                    break;
                }
                this.drawCenterContentStart = (int)((double)(this.measuredWidth - rect.width()) * 0.25);
                break;
            }
            case 3: {
                this.drawCenterContentStart = 0;
                break;
            }
            case 5: {
                this.drawCenterContentStart = this.measuredWidth - rect.width() - (int)this.CENTERCONTENTOFFSET;
            }
        }
    }

    private void measuredOutContentStart(String content) {
        Rect rect = new Rect();
        this.paintOuterText.getTextBounds(content, 0, content.length(), rect);
        switch (this.mGravity) {
            case 17: {
                if (this.isOptions || this.label == null || this.label.equals("") || !this.isCenterLabel) {
                    this.drawOutContentStart = (int)((double)(this.measuredWidth - rect.width()) * 0.5);
                    break;
                }
                this.drawOutContentStart = (int)((double)(this.measuredWidth - rect.width()) * 0.25);
                break;
            }
            case 3: {
                this.drawOutContentStart = 0;
                break;
            }
            case 5: {
                this.drawOutContentStart = this.measuredWidth - rect.width() - (int)this.CENTERCONTENTOFFSET;
            }
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.widthMeasureSpec = widthMeasureSpec;
        this.remeasure();
        this.setMeasuredDimension(this.measuredWidth, this.measuredHeight);
    }

    public boolean onTouchEvent(MotionEvent event) {
        boolean eventConsumed = this.gestureDetector.onTouchEvent(event);
        switch (event.getAction()) {
            case 0: {
                this.startTime = System.currentTimeMillis();
                this.cancelFuture();
                this.previousY = event.getRawY();
                break;
            }
            case 2: {
                float dy = this.previousY - event.getRawY();
                this.previousY = event.getRawY();
                this.totalScrollY += dy;
                if (this.isLoop) break;
                float top = (float)(-this.initPosition) * this.itemHeight;
                float bottom = (float)(this.adapter.getItemsCount() - 1 - this.initPosition) * this.itemHeight;
                if ((double)this.totalScrollY - (double)this.itemHeight * 0.25 < (double)top) {
                    top = this.totalScrollY - dy;
                } else if ((double)this.totalScrollY + (double)this.itemHeight * 0.25 > (double)bottom) {
                    bottom = this.totalScrollY - dy;
                }
                if (this.totalScrollY < top) {
                    this.totalScrollY = (int)top;
                    break;
                }
                if (!(this.totalScrollY > bottom)) break;
                this.totalScrollY = (int)bottom;
                break;
            }
            default: {
                if (eventConsumed) break;
                float y = event.getY();
                double L = Math.acos(((float)this.radius - y) / (float)this.radius) * (double)this.radius;
                int circlePosition = (int)((L + (double)(this.itemHeight / 2.0f)) / (double)this.itemHeight);
                float extraOffset = (this.totalScrollY % this.itemHeight + this.itemHeight) % this.itemHeight;
                this.mOffset = (int)((float)(circlePosition - this.itemsVisible / 2) * this.itemHeight - extraOffset);
                if (System.currentTimeMillis() - this.startTime > 120L) {
                    this.smoothScroll(ACTION.DAGGLE);
                    break;
                }
                this.smoothScroll(ACTION.CLICK);
            }
        }
        this.invalidate();
        return true;
    }

    public int getItemsCount() {
        return this.adapter != null ? this.adapter.getItemsCount() : 0;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void isCenterLabel(Boolean isCenterLabel) {
        this.isCenterLabel = isCenterLabel;
    }

    public void setGravity(int gravity) {
        this.mGravity = gravity;
    }

    public int getTextWidth(Paint paint, String str) {
        int iRet = 0;
        if (str != null && str.length() > 0) {
            int len = str.length();
            float[] widths = new float[len];
            paint.getTextWidths(str, widths);
            for (int j = 0; j < len; ++j) {
                iRet += (int)Math.ceil(widths[j]);
            }
        }
        return iRet;
    }

    public void setIsOptions(boolean options) {
        this.isOptions = options;
    }

    public void setTextColorOut(int textColorOut) {
        if (textColorOut != 0) {
            this.textColorOut = textColorOut;
            this.paintOuterText.setColor(this.textColorOut);
        }
    }

    public void setTextColorCenter(int textColorCenter) {
        if (textColorCenter != 0) {
            this.textColorCenter = textColorCenter;
            this.paintCenterText.setColor(this.textColorCenter);
        }
    }

    public void setDividerColor(int dividerColor) {
        if (dividerColor != 0) {
            this.dividerColor = dividerColor;
            this.paintIndicator.setColor(this.dividerColor);
        }
    }

    public void setDividerType(DividerType dividerType) {
        this.dividerType = dividerType;
    }

    public void setLineSpacingMultiplier(float lineSpacingMultiplier) {
        if (lineSpacingMultiplier != 0.0f) {
            this.lineSpacingMultiplier = lineSpacingMultiplier;
            this.judgeLineSpae();
        }
    }

    public static enum DividerType {
        FILL,
        WRAP;

    }

    public static enum ACTION {
        CLICK,
        FLING,
        DAGGLE;

    }
}

