/*
 * Decompiled with CFR 0.152.
 */
package com.bigkoo.pickerview.view;

import android.content.Context;
import android.view.View;
import com.bigkoo.pickerview.R;
import com.bigkoo.pickerview.TimePickerView;
import com.bigkoo.pickerview.adapter.NumericWheelAdapter;
import com.bigkoo.pickerview.lib.WheelView;
import com.bigkoo.pickerview.listener.OnItemSelectedListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;

public class WheelTime {
    public static DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private View view;
    private WheelView wv_year;
    private WheelView wv_month;
    private WheelView wv_day;
    private WheelView wv_hours;
    private WheelView wv_mins;
    private WheelView wv_seconds;
    private int gravity;
    private TimePickerView.Type type;
    public static final int DEFULT_START_YEAR = 1900;
    public static final int DEFULT_END_YEAR = 2100;
    private int startYear = 1900;
    private int endYear = 2100;
    private int textSize = 18;
    int textColorOut;
    int textColorCenter;
    int dividerColor;
    float lineSpacingMultiplier = 1.6f;

    public WheelTime(View view) {
        this.view = view;
        this.type = TimePickerView.Type.ALL;
        this.setView(view);
    }

    public WheelTime(View view, TimePickerView.Type type, int gravity, int textSize) {
        this.view = view;
        this.type = type;
        this.gravity = gravity;
        this.textSize = textSize;
        this.setView(view);
    }

    public void setPicker(int year, int month, int day) {
        this.setPicker(year, month, day, 0, 0, 0);
    }

    public void setPicker(int year, int month, int day, int h, int m, int s) {
        String[] months_big = new String[]{"1", "3", "5", "7", "8", "10", "12"};
        String[] months_little = new String[]{"4", "6", "9", "11"};
        final List<String> list_big = Arrays.asList(months_big);
        final List<String> list_little = Arrays.asList(months_little);
        Context context = this.view.getContext();
        this.wv_year = (WheelView)this.view.findViewById(R.id.year);
        this.wv_year.setAdapter(new NumericWheelAdapter(this.startYear, this.endYear));
        this.wv_year.setLabel(context.getString(R.string.pickerview_year));
        this.wv_year.setCurrentItem(year - this.startYear);
        this.wv_year.setGravity(this.gravity);
        this.wv_month = (WheelView)this.view.findViewById(R.id.month);
        this.wv_month.setAdapter(new NumericWheelAdapter(1, 12));
        this.wv_month.setLabel(context.getString(R.string.pickerview_month));
        this.wv_month.setCurrentItem(month);
        this.wv_month.setGravity(this.gravity);
        this.wv_day = (WheelView)this.view.findViewById(R.id.day);
        if (list_big.contains(String.valueOf(month + 1))) {
            this.wv_day.setAdapter(new NumericWheelAdapter(1, 31));
        } else if (list_little.contains(String.valueOf(month + 1))) {
            this.wv_day.setAdapter(new NumericWheelAdapter(1, 30));
        } else if (year % 4 == 0 && year % 100 != 0 || year % 400 == 0) {
            this.wv_day.setAdapter(new NumericWheelAdapter(1, 29));
        } else {
            this.wv_day.setAdapter(new NumericWheelAdapter(1, 28));
        }
        this.wv_day.setLabel(context.getString(R.string.pickerview_day));
        this.wv_day.setCurrentItem(day - 1);
        this.wv_day.setGravity(this.gravity);
        this.wv_hours = (WheelView)this.view.findViewById(R.id.hour);
        this.wv_hours.setAdapter(new NumericWheelAdapter(0, 23));
        this.wv_hours.setLabel(context.getString(R.string.pickerview_hours));
        this.wv_hours.setCurrentItem(h);
        this.wv_hours.setGravity(this.gravity);
        this.wv_mins = (WheelView)this.view.findViewById(R.id.min);
        this.wv_mins.setAdapter(new NumericWheelAdapter(0, 59));
        this.wv_mins.setLabel(context.getString(R.string.pickerview_minutes));
        this.wv_mins.setCurrentItem(m);
        this.wv_mins.setGravity(this.gravity);
        this.wv_seconds = (WheelView)this.view.findViewById(R.id.second);
        this.wv_seconds.setAdapter(new NumericWheelAdapter(0, 59));
        this.wv_seconds.setLabel(context.getString(R.string.pickerview_seconds));
        this.wv_seconds.setCurrentItem(s);
        this.wv_seconds.setGravity(this.gravity);
        OnItemSelectedListener wheelListener_year = new OnItemSelectedListener(){

            @Override
            public void onItemSelected(int index) {
                int year_num = index + WheelTime.this.startYear;
                int maxItem = 30;
                if (list_big.contains(String.valueOf(WheelTime.this.wv_month.getCurrentItem() + 1))) {
                    WheelTime.this.wv_day.setAdapter(new NumericWheelAdapter(1, 31));
                    maxItem = 31;
                } else if (list_little.contains(String.valueOf(WheelTime.this.wv_month.getCurrentItem() + 1))) {
                    WheelTime.this.wv_day.setAdapter(new NumericWheelAdapter(1, 30));
                    maxItem = 30;
                } else if (year_num % 4 == 0 && year_num % 100 != 0 || year_num % 400 == 0) {
                    WheelTime.this.wv_day.setAdapter(new NumericWheelAdapter(1, 29));
                    maxItem = 29;
                } else {
                    WheelTime.this.wv_day.setAdapter(new NumericWheelAdapter(1, 28));
                    maxItem = 28;
                }
                if (WheelTime.this.wv_day.getCurrentItem() > maxItem - 1) {
                    WheelTime.this.wv_day.setCurrentItem(maxItem - 1);
                }
            }
        };
        OnItemSelectedListener wheelListener_month = new OnItemSelectedListener(){

            @Override
            public void onItemSelected(int index) {
                int month_num = index + 1;
                int maxItem = 30;
                if (list_big.contains(String.valueOf(month_num))) {
                    WheelTime.this.wv_day.setAdapter(new NumericWheelAdapter(1, 31));
                    maxItem = 31;
                } else if (list_little.contains(String.valueOf(month_num))) {
                    WheelTime.this.wv_day.setAdapter(new NumericWheelAdapter(1, 30));
                    maxItem = 30;
                } else if ((WheelTime.this.wv_year.getCurrentItem() + WheelTime.this.startYear) % 4 == 0 && (WheelTime.this.wv_year.getCurrentItem() + WheelTime.this.startYear) % 100 != 0 || (WheelTime.this.wv_year.getCurrentItem() + WheelTime.this.startYear) % 400 == 0) {
                    WheelTime.this.wv_day.setAdapter(new NumericWheelAdapter(1, 29));
                    maxItem = 29;
                } else {
                    WheelTime.this.wv_day.setAdapter(new NumericWheelAdapter(1, 28));
                    maxItem = 28;
                }
                if (WheelTime.this.wv_day.getCurrentItem() > maxItem - 1) {
                    WheelTime.this.wv_day.setCurrentItem(maxItem - 1);
                }
            }
        };
        this.wv_year.setOnItemSelectedListener(wheelListener_year);
        this.wv_month.setOnItemSelectedListener(wheelListener_month);
        switch (this.type) {
            case ALL: {
                break;
            }
            case YEAR_MONTH_DAY: {
                this.wv_hours.setVisibility(8);
                this.wv_mins.setVisibility(8);
                this.wv_seconds.setVisibility(8);
                break;
            }
            case HOURS_MINS: {
                this.wv_year.setVisibility(8);
                this.wv_month.setVisibility(8);
                this.wv_day.setVisibility(8);
                this.wv_seconds.setVisibility(8);
                break;
            }
            case MONTH_DAY_HOUR_MIN: {
                this.wv_year.setVisibility(8);
                this.wv_seconds.setVisibility(8);
                break;
            }
            case YEAR_MONTH: {
                this.wv_day.setVisibility(8);
                this.wv_hours.setVisibility(8);
                this.wv_mins.setVisibility(8);
                this.wv_seconds.setVisibility(8);
            }
        }
        this.setContentTextSize();
    }

    private void setContentTextSize() {
        this.wv_day.setTextSize(this.textSize);
        this.wv_month.setTextSize(this.textSize);
        this.wv_year.setTextSize(this.textSize);
        this.wv_hours.setTextSize(this.textSize);
        this.wv_mins.setTextSize(this.textSize);
        this.wv_seconds.setTextSize(this.textSize);
    }

    private void setTextColorOut() {
        this.wv_day.setTextColorOut(this.textColorOut);
        this.wv_month.setTextColorOut(this.textColorOut);
        this.wv_year.setTextColorOut(this.textColorOut);
        this.wv_hours.setTextColorOut(this.textColorOut);
        this.wv_mins.setTextColorOut(this.textColorOut);
        this.wv_seconds.setTextColorOut(this.textColorOut);
    }

    private void setTextColorCenter() {
        this.wv_day.setTextColorCenter(this.textColorCenter);
        this.wv_month.setTextColorCenter(this.textColorCenter);
        this.wv_year.setTextColorCenter(this.textColorCenter);
        this.wv_hours.setTextColorCenter(this.textColorCenter);
        this.wv_mins.setTextColorCenter(this.textColorCenter);
        this.wv_seconds.setTextColorCenter(this.textColorCenter);
    }

    private void setDividerColor() {
        this.wv_day.setDividerColor(this.dividerColor);
        this.wv_month.setDividerColor(this.dividerColor);
        this.wv_year.setDividerColor(this.dividerColor);
        this.wv_hours.setDividerColor(this.dividerColor);
        this.wv_mins.setDividerColor(this.dividerColor);
        this.wv_seconds.setDividerColor(this.dividerColor);
    }

    private void setLineSpacingMultiplier() {
        this.wv_day.setLineSpacingMultiplier(this.lineSpacingMultiplier);
        this.wv_month.setLineSpacingMultiplier(this.lineSpacingMultiplier);
        this.wv_year.setLineSpacingMultiplier(this.lineSpacingMultiplier);
        this.wv_hours.setLineSpacingMultiplier(this.lineSpacingMultiplier);
        this.wv_mins.setLineSpacingMultiplier(this.lineSpacingMultiplier);
        this.wv_seconds.setLineSpacingMultiplier(this.lineSpacingMultiplier);
    }

    public void setLabels(String label_year, String label_month, String label_day, String label_hours, String label_mins, String label_seconds) {
        if (label_year != null) {
            this.wv_year.setLabel(label_year);
        }
        if (label_month != null) {
            this.wv_month.setLabel(label_month);
        }
        if (label_day != null) {
            this.wv_day.setLabel(label_day);
        }
        if (label_hours != null) {
            this.wv_hours.setLabel(label_hours);
        }
        if (label_mins != null) {
            this.wv_mins.setLabel(label_mins);
        }
        if (label_seconds != null) {
            this.wv_seconds.setLabel(label_seconds);
        }
    }

    public void setCyclic(boolean cyclic) {
        this.wv_year.setCyclic(cyclic);
        this.wv_month.setCyclic(cyclic);
        this.wv_day.setCyclic(cyclic);
        this.wv_hours.setCyclic(cyclic);
        this.wv_mins.setCyclic(cyclic);
        this.wv_seconds.setCyclic(cyclic);
    }

    public String getTime() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.wv_year.getCurrentItem() + this.startYear).append("-").append(this.wv_month.getCurrentItem() + 1).append("-").append(this.wv_day.getCurrentItem() + 1).append(" ").append(this.wv_hours.getCurrentItem()).append(":").append(this.wv_mins.getCurrentItem()).append(":").append(this.wv_seconds.getCurrentItem());
        return sb.toString();
    }

    public View getView() {
        return this.view;
    }

    public void setView(View view) {
        this.view = view;
    }

    public int getStartYear() {
        return this.startYear;
    }

    public void setStartYear(int startYear) {
        this.startYear = startYear;
    }

    public int getEndYear() {
        return this.endYear;
    }

    public void setEndYear(int endYear) {
        this.endYear = endYear;
    }

    public void setLineSpacingMultiplier(float lineSpacingMultiplier) {
        this.lineSpacingMultiplier = lineSpacingMultiplier;
        this.setLineSpacingMultiplier();
    }

    public void setDividerColor(int dividerColor) {
        this.dividerColor = dividerColor;
        this.setDividerColor();
    }

    public void setTextColorCenter(int textColorCenter) {
        this.textColorCenter = textColorCenter;
        this.setTextColorCenter();
    }

    public void setTextColorOut(int textColorOut) {
        this.textColorOut = textColorOut;
        this.setTextColorOut();
    }
}

