/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.dsl.builder;

import com.consol.citrus.TestAction;
import com.consol.citrus.dsl.actions.DelegatingTestAction;
import com.consol.citrus.dsl.builder.AbstractTestActionBuilder;
import com.consol.citrus.dsl.builder.HttpServerRequestActionBuilder;
import com.consol.citrus.dsl.builder.HttpServerResponseActionBuilder;
import com.consol.citrus.endpoint.Endpoint;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;

public class HttpServerActionBuilder
extends AbstractTestActionBuilder<DelegatingTestAction<TestAction>> {
    private ApplicationContext applicationContext;
    private final Endpoint httpServer;

    public HttpServerActionBuilder(DelegatingTestAction<TestAction> action, Endpoint httpServer) {
        super(action);
        this.httpServer = httpServer;
    }

    public HttpServerResponseActionBuilder respond() {
        return new HttpServerSendActionBuilder().response();
    }

    public HttpServerResponseActionBuilder respond(HttpStatus status) {
        return new HttpServerSendActionBuilder().response(status);
    }

    public HttpServerReceiveActionBuilder receive() {
        return new HttpServerReceiveActionBuilder();
    }

    public HttpServerSendActionBuilder send() {
        return new HttpServerSendActionBuilder();
    }

    private HttpServerRequestActionBuilder request(HttpMethod method, String path) {
        HttpServerRequestActionBuilder httpServerRequestActionBuilder = ((HttpServerRequestActionBuilder)new HttpServerRequestActionBuilder((DelegatingTestAction)this.action, this.httpServer).withApplicationContext(this.applicationContext)).method(method);
        if (StringUtils.hasText((String)path)) {
            httpServerRequestActionBuilder.path(path);
        }
        return httpServerRequestActionBuilder;
    }

    public HttpServerActionBuilder withApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        return this;
    }

    public class HttpServerReceiveActionBuilder {
        public HttpServerRequestActionBuilder get() {
            return HttpServerActionBuilder.this.request(HttpMethod.GET, null);
        }

        public HttpServerRequestActionBuilder get(String path) {
            return HttpServerActionBuilder.this.request(HttpMethod.GET, path);
        }

        public HttpServerRequestActionBuilder post() {
            return HttpServerActionBuilder.this.request(HttpMethod.POST, null);
        }

        public HttpServerRequestActionBuilder post(String path) {
            return HttpServerActionBuilder.this.request(HttpMethod.POST, path);
        }

        public HttpServerRequestActionBuilder put() {
            return HttpServerActionBuilder.this.request(HttpMethod.PUT, null);
        }

        public HttpServerRequestActionBuilder put(String path) {
            return HttpServerActionBuilder.this.request(HttpMethod.PUT, path);
        }

        public HttpServerRequestActionBuilder delete() {
            return HttpServerActionBuilder.this.request(HttpMethod.DELETE, null);
        }

        public HttpServerRequestActionBuilder delete(String path) {
            return HttpServerActionBuilder.this.request(HttpMethod.DELETE, path);
        }

        public HttpServerRequestActionBuilder head() {
            return HttpServerActionBuilder.this.request(HttpMethod.HEAD, null);
        }

        public HttpServerRequestActionBuilder head(String path) {
            return HttpServerActionBuilder.this.request(HttpMethod.HEAD, path);
        }

        public HttpServerRequestActionBuilder options() {
            return HttpServerActionBuilder.this.request(HttpMethod.OPTIONS, null);
        }

        public HttpServerRequestActionBuilder options(String path) {
            return HttpServerActionBuilder.this.request(HttpMethod.OPTIONS, path);
        }

        public HttpServerRequestActionBuilder trace() {
            return HttpServerActionBuilder.this.request(HttpMethod.TRACE, null);
        }

        public HttpServerRequestActionBuilder trace(String path) {
            return HttpServerActionBuilder.this.request(HttpMethod.TRACE, path);
        }

        public HttpServerRequestActionBuilder patch() {
            return HttpServerActionBuilder.this.request(HttpMethod.PATCH, null);
        }

        public HttpServerRequestActionBuilder patch(String path) {
            return HttpServerActionBuilder.this.request(HttpMethod.PATCH, path);
        }
    }

    public class HttpServerSendActionBuilder {
        public HttpServerResponseActionBuilder response() {
            return (HttpServerResponseActionBuilder)new HttpServerResponseActionBuilder((DelegatingTestAction)HttpServerActionBuilder.this.action, HttpServerActionBuilder.this.httpServer).withApplicationContext(HttpServerActionBuilder.this.applicationContext);
        }

        public HttpServerResponseActionBuilder response(HttpStatus status) {
            return ((HttpServerResponseActionBuilder)new HttpServerResponseActionBuilder((DelegatingTestAction)HttpServerActionBuilder.this.action, HttpServerActionBuilder.this.httpServer).withApplicationContext(HttpServerActionBuilder.this.applicationContext)).status(status);
        }
    }
}

