/*
 * Decompiled with CFR 0.152.
 */
package com.configureit.barcode;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.YuvImage;
import com.google.zxing.PlanarYUVLuminanceSource;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

public class SourceData {
    private byte[] data;
    private int dataWidth;
    private int dataHeight;
    private int imageFormat;
    private int rotation;
    private Rect cropRect;

    public SourceData(byte[] data, int dataWidth, int dataHeight, int imageFormat, int rotation) {
        this.data = data;
        this.dataWidth = dataWidth;
        this.dataHeight = dataHeight;
        this.rotation = rotation;
        this.imageFormat = imageFormat;
    }

    public Rect getCropRect() {
        return this.cropRect;
    }

    public void setCropRect(Rect cropRect) {
        this.cropRect = cropRect;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getDataWidth() {
        return this.dataWidth;
    }

    public int getDataHeight() {
        return this.dataHeight;
    }

    public boolean isRotated() {
        return this.rotation % 180 != 0;
    }

    public int getImageFormat() {
        return this.imageFormat;
    }

    public PlanarYUVLuminanceSource createSource() {
        byte[] rotated = SourceData.rotateCameraPreview(this.rotation, this.data, this.dataWidth, this.dataHeight);
        if (this.isRotated()) {
            return new PlanarYUVLuminanceSource(rotated, this.dataHeight, this.dataWidth, this.cropRect.left, this.cropRect.top, this.cropRect.width(), this.cropRect.height(), false);
        }
        return new PlanarYUVLuminanceSource(rotated, this.dataWidth, this.dataHeight, this.cropRect.left, this.cropRect.top, this.cropRect.width(), this.cropRect.height(), false);
    }

    public Bitmap getBitmap() {
        return this.getBitmap(1);
    }

    public Bitmap getBitmap(int scaleFactor) {
        return this.getBitmap(this.cropRect, scaleFactor);
    }

    private Bitmap getBitmap(Rect cropRect, int scaleFactor) {
        if (this.isRotated()) {
            cropRect = new Rect(cropRect.top, cropRect.left, cropRect.bottom, cropRect.right);
        }
        YuvImage img = new YuvImage(this.data, this.imageFormat, this.dataWidth, this.dataHeight, null);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        img.compressToJpeg(cropRect, 90, (OutputStream)buffer);
        byte[] jpegData = buffer.toByteArray();
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inSampleSize = scaleFactor;
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])jpegData, (int)0, (int)jpegData.length, (BitmapFactory.Options)options);
        if (this.rotation != 0) {
            Matrix imageMatrix = new Matrix();
            imageMatrix.postRotate((float)this.rotation);
            bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)imageMatrix, (boolean)false);
        }
        return bitmap;
    }

    public static byte[] rotateCameraPreview(int cameraRotation, byte[] data, int imageWidth, int imageHeight) {
        switch (cameraRotation) {
            case 0: {
                return data;
            }
            case 90: {
                return SourceData.rotateCW(data, imageWidth, imageHeight);
            }
            case 180: {
                return SourceData.rotate180(data, imageWidth, imageHeight);
            }
            case 270: {
                return SourceData.rotateCCW(data, imageWidth, imageHeight);
            }
        }
        return data;
    }

    public static byte[] rotateCW(byte[] data, int imageWidth, int imageHeight) {
        byte[] yuv = new byte[imageWidth * imageHeight];
        int i = 0;
        for (int x = 0; x < imageWidth; ++x) {
            for (int y = imageHeight - 1; y >= 0; --y) {
                yuv[i] = data[y * imageWidth + x];
                ++i;
            }
        }
        return yuv;
    }

    public static byte[] rotate180(byte[] data, int imageWidth, int imageHeight) {
        int n = imageWidth * imageHeight;
        byte[] yuv = new byte[n];
        int i = n - 1;
        for (int j = 0; j < n; ++j) {
            yuv[i] = data[j];
            --i;
        }
        return yuv;
    }

    public static byte[] rotateCCW(byte[] data, int imageWidth, int imageHeight) {
        int n = imageWidth * imageHeight;
        byte[] yuv = new byte[n];
        int i = n - 1;
        for (int x = 0; x < imageWidth; ++x) {
            for (int y = imageHeight - 1; y >= 0; --y) {
                yuv[i] = data[y * imageWidth + x];
                --i;
            }
        }
        return yuv;
    }
}

