/*
 * Decompiled with CFR 0.152.
 */
package com.configureit.barcode;

import android.graphics.Rect;
import com.configureit.barcode.FitCenterStrategy;
import com.configureit.barcode.PreviewScalingStrategy;
import com.configureit.barcode.Size;
import java.util.List;

public class DisplayConfiguration {
    private static final String TAG = DisplayConfiguration.class.getSimpleName();
    private Size viewfinderSize;
    private int rotation;
    private boolean center = false;
    private PreviewScalingStrategy previewScalingStrategy = new FitCenterStrategy();

    public DisplayConfiguration(int rotation) {
        this.rotation = rotation;
    }

    public DisplayConfiguration(int rotation, Size viewfinderSize) {
        this.rotation = rotation;
        this.viewfinderSize = viewfinderSize;
    }

    public int getRotation() {
        return this.rotation;
    }

    public Size getViewfinderSize() {
        return this.viewfinderSize;
    }

    public PreviewScalingStrategy getPreviewScalingStrategy() {
        return this.previewScalingStrategy;
    }

    public void setPreviewScalingStrategy(PreviewScalingStrategy previewScalingStrategy) {
        this.previewScalingStrategy = previewScalingStrategy;
    }

    public Size getDesiredPreviewSize(boolean rotate) {
        if (this.viewfinderSize == null) {
            return null;
        }
        if (rotate) {
            return this.viewfinderSize.rotate();
        }
        return this.viewfinderSize;
    }

    public Size getBestPreviewSize(List<Size> sizes, boolean isRotated) {
        Size desired = this.getDesiredPreviewSize(isRotated);
        return this.previewScalingStrategy.getBestPreviewSize(sizes, desired);
    }

    public Rect scalePreview(Size previewSize) {
        return this.previewScalingStrategy.scalePreview(previewSize, this.viewfinderSize);
    }
}

