/*
 * Decompiled with CFR 0.152.
 */
package com.configureit.navigation;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTabHost;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TabHost;
import com.configureit.navigation.CITActivity;
import com.configureit.navigation.CITTabBarDetails;
import com.configureit.navigation.CITTabContainer;
import com.configureit.navigation.INavigationCIT;
import com.configureit.navigation.TabSpecDetails;
import configureit.citnavigationlib.R;
import java.util.ArrayList;

public class CITTabFragment
extends Fragment
implements FragmentManager.OnBackStackChangedListener {
    private View v;
    private Bundle bundle;
    private CITTabBarDetails citTabBarDetails;
    private int status = 0;
    private long citFragmentID;
    public static final int CREATE = 0;
    public static final int PAUSE = 1;
    public static final int STOP = 2;
    public boolean addedToStack = true;
    private TabHost.OnTabChangeListener tabChangeListener = new TabHost.OnTabChangeListener(){

        public void onTabChanged(String tabId) {
            try {
                if (CITActivity.class.isInstance(CITTabFragment.this.getActivity())) {
                    String tabIndex;
                    CITActivity citActivity = (CITActivity)CITTabFragment.this.getActivity();
                    String string = tabIndex = tabId.contains("cit_tab_container_") ? tabId.replace("cit_tab_container_", "") : tabId;
                    if (!CITActivity.isEmpty(tabIndex) && TextUtils.isDigitsOnly((CharSequence)tabIndex)) {
                        int i = Integer.parseInt(tabIndex);
                        if (citActivity.getListTabSpec() != null) {
                            citActivity.onTabChanged(citActivity.getListTabSpec().get(i).getLayoutName());
                        }
                    }
                }
            }
            catch (Exception e) {
                Log.e((String)"onTabChanged", (String)("" + e.getMessage()));
            }
        }
    };

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.citFragmentID = System.currentTimeMillis();
        this.status = 0;
    }

    public boolean isScreenResumed() {
        if (this.status != 0) {
            return !this.isAddedToStack();
        }
        return false;
    }

    public long getCitFragmentID() {
        return this.citFragmentID;
    }

    public void addedToStack(boolean addedToStack) {
        this.addedToStack = addedToStack;
    }

    public boolean isAddedToStack() {
        return this.addedToStack;
    }

    public void setTabBarDetails(@NonNull CITTabBarDetails citTabBarDetails) {
        this.citTabBarDetails = citTabBarDetails;
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        if (this.v == null) {
            this.v = this.citTabBarDetails.getTabBarAlignment() == 0 ? LayoutInflater.from((Context)this.getActivity()).inflate(R.layout.bottom_tabbar, container, false) : LayoutInflater.from((Context)this.getActivity()).inflate(R.layout.top_tabbar, container, false);
            this.initilizeTabBar(this.v);
        }
        return this.v;
    }

    public void initilizeTabBar(View v) {
        FragmentTabHost mTabHost = (FragmentTabHost)v.findViewById(0x1020012);
        INavigationCIT navigationCIT = (INavigationCIT)this.getActivity();
        int tabFragmentContainer = this.citTabBarDetails.getTabBarAlignment() == 1 ? 0x1020011 : R.id.tabFragmentContainer;
        mTabHost.setup((Context)navigationCIT.getActivityCIT(), this.getChildFragmentManager(), tabFragmentContainer);
        mTabHost.setOnTabChangedListener(this.tabChangeListener);
        ArrayList<TabSpecDetails> listTabSpecDetails = this.citTabBarDetails.getListTabSpecDetails();
        LinearLayout.LayoutParams layout_gravity = (LinearLayout.LayoutParams)mTabHost.getTabWidget().getLayoutParams();
        layout_gravity.width = -2;
        if (this.citTabBarDetails.isTabsFitToWidth()) {
            layout_gravity.width = -1;
        }
        if (this.citTabBarDetails.getTabBarAlignment() == 0) {
            layout_gravity.height = -2;
            layout_gravity.gravity = 1;
        }
        mTabHost.getTabWidget().setLayoutParams((ViewGroup.LayoutParams)layout_gravity);
        mTabHost.getTabWidget().setDividerDrawable(this.citTabBarDetails.getTabDivider());
        mTabHost.getTabWidget().setShowDividers(2);
        if (!listTabSpecDetails.isEmpty()) {
            int i = 0;
            for (TabSpecDetails tabSpecDetails : listTabSpecDetails) {
                Bundle tabBundle = tabSpecDetails.getBundleArguments();
                if (tabBundle == null) {
                    tabBundle = new Bundle();
                }
                int selectedIndex = this.getArguments().getInt("default-selected-tab-index", 0);
                tabBundle.putString("layout_name", tabSpecDetails.getLayoutName());
                tabBundle.putString("cit-screen-type", "cit-tab-content");
                tabBundle.putInt("default-selected-tab-index", selectedIndex);
                tabBundle.putInt("cit-tab-index", i);
                String indicatorText = "";
                if (tabSpecDetails.getTabBarText() != 0) {
                    indicatorText = CITActivity.isEmpty(this.getString(tabSpecDetails.getTabBarText())) ? "" : this.getString(tabSpecDetails.getTabBarText());
                }
                Drawable drawable2 = tabSpecDetails.getTabButtonSelector() != 0 ? CITActivity.getDrawable((Context)navigationCIT.getActivityCIT(), tabSpecDetails.getTabButtonSelector()) : null;
                TabHost.TabSpec tabButtonSpec = mTabHost.newTabSpec("cit_tab_container_" + i);
                if (tabSpecDetails.getTabButtonView() != null) {
                    tabButtonSpec.setIndicator(tabSpecDetails.getTabButtonView());
                } else if (!TextUtils.isEmpty((CharSequence)indicatorText) && drawable2 != null) {
                    tabButtonSpec.setIndicator((CharSequence)indicatorText, drawable2);
                } else if (!TextUtils.isEmpty((CharSequence)indicatorText)) {
                    tabButtonSpec.setIndicator((CharSequence)indicatorText);
                } else if (drawable2 != null) {
                    tabButtonSpec.setIndicator((CharSequence)"", drawable2);
                }
                mTabHost.addTab(tabButtonSpec, CITTabContainer.class, tabBundle);
                ++i;
            }
            if (this.citTabBarDetails.getTabBarStripBackground() != null) {
                View vLinear = v.findViewById(R.id.tabBackground);
                if (Build.VERSION.SDK_INT > 15) {
                    vLinear.setBackground(this.citTabBarDetails.getTabBarStripBackground());
                } else {
                    vLinear.setBackgroundDrawable(this.citTabBarDetails.getTabBarStripBackground());
                }
            }
            navigationCIT.setFragmentManagerCIT(this.getChildFragmentManager());
        }
        navigationCIT.setTabHost(mTabHost);
    }

    public void onBackStackChanged() {
    }

    public static @interface ScreenStatus {
    }
}

