/*
 * Decompiled with CFR 0.152.
 */
package com.configureit.navigation;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.widget.FrameLayout;
import com.configureit.navigation.CITActivity;
import com.configureit.navigation.CITFragment;
import com.configureit.navigation.CITNavigationConstants;
import com.configureit.navigation.INavigationCIT;
import com.configureit.navigation.TabSpecDetails;
import configureit.citnavigationlib.R;
import java.util.LinkedHashMap;

public class CITTabContainer
extends Fragment {
    private FrameLayout frameLayout;
    private INavigationCIT navigationCIT;
    private int tabIndex;
    private int selectedTabIndex;
    private LinkedHashMap<String, TabSpecDetails> changeTabMap = new LinkedHashMap();
    private int tabFMPrevCount;
    private boolean isActivate = false;
    private TabSpecDetails tabSpecDetails;

    public int getTabFMPrevCount() {
        return this.tabFMPrevCount;
    }

    public void setTabFMPrevCount(int tabFMPrevCount) {
        this.tabFMPrevCount = tabFMPrevCount;
    }

    public void updateTabSpecDetailsMap(@CITNavigationConstants.ChangeTabProperty String changeTabProperty, TabSpecDetails newTabSpecification) {
        this.changeTabMap.put(changeTabProperty, newTabSpecification);
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle bundle = this.getArguments();
        this.tabIndex = bundle.getInt("cit-tab-index", -1);
        this.selectedTabIndex = bundle.getInt("default-selected-tab-index", 0);
    }

    public Animation onCreateAnimation(int transit, boolean enter, int nextAnim) {
        if (CITActivity.disableAnimation) {
            Animation animation = new Animation(){};
            animation.setDuration(0L);
            return animation;
        }
        return super.onCreateAnimation(transit, enter, nextAnim);
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        if (this.frameLayout == null) {
            this.frameLayout = new FrameLayout((Context)this.getActivity());
            this.frameLayout.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
            this.frameLayout.setBackgroundColor(-1);
            this.frameLayout.setId(R.id.cit_tab_container);
        }
        return this.frameLayout;
    }

    public void onResume() {
        super.onResume();
        CITActivity citActivity = (CITActivity)this.getActivity();
        if (this.changeTabMap != null && !this.changeTabMap.isEmpty() && citActivity != null) {
            CITActivity.disableAnimation = true;
            if (this.tabSpecDetails == null && citActivity.getListTabSpec() != null && !citActivity.getListTabSpec().isEmpty()) {
                this.tabSpecDetails = citActivity.getListTabSpec().get(this.tabIndex);
            }
            if (this.changeTabMap.containsKey("popToRootViewController")) {
                if (this.tabSpecDetails != null) {
                    this.changeTabMap.remove("popToRootViewController");
                    int size = this.getChildFragmentManager().getBackStackEntryCount();
                    for (int a = 0; a < size; ++a) {
                        FragmentManager.BackStackEntry entry = this.getChildFragmentManager().getBackStackEntryAt(a);
                        CITFragment citFragment = (CITFragment)this.getChildFragmentManager().findFragmentByTag(entry.getName());
                        if (citFragment == null) continue;
                        this.getChildFragmentManager().removeOnBackStackChangedListener((FragmentManager.OnBackStackChangedListener)citFragment);
                    }
                    if (size > 0) {
                        citActivity.pop(null);
                    }
                    this.tabSpecDetails.setChildFragmentManager(this.getChildFragmentManager());
                    this.navigationCIT.getActivityCIT().updateTabChildTabManager(this.tabIndex, this.tabSpecDetails);
                }
            } else if (this.changeTabMap.containsKey("changeRootViewController")) {
                TabSpecDetails newRootTabSpecDetails = this.changeTabMap.get("changeRootViewController");
                this.changeTabMap.remove("changeRootViewController");
                if (newRootTabSpecDetails != null) {
                    int size = this.getChildFragmentManager().getBackStackEntryCount();
                    for (int a = 0; a < size; ++a) {
                        FragmentManager.BackStackEntry entry = this.getChildFragmentManager().getBackStackEntryAt(a);
                        CITFragment citFragment = (CITFragment)this.getChildFragmentManager().findFragmentByTag(entry.getName());
                        if (citFragment == null) continue;
                        if (a == 1) {
                            citFragment.addedToStack(false);
                            this.getChildFragmentManager().removeOnBackStackChangedListener((FragmentManager.OnBackStackChangedListener)citFragment);
                            this.getChildFragmentManager().addOnBackStackChangedListener((FragmentManager.OnBackStackChangedListener)citFragment);
                            continue;
                        }
                        this.getChildFragmentManager().removeOnBackStackChangedListener((FragmentManager.OnBackStackChangedListener)citFragment);
                    }
                    if (size > 0) {
                        this.getChildFragmentManager().popBackStack(null, 1);
                    }
                    CITFragment fragment = (CITFragment)newRootTabSpecDetails.getFragment();
                    Bundle bundleArguments = this.tabSpecDetails.getBundleArguments();
                    if (fragment == null) {
                        fragment = new CITFragment();
                    }
                    if (bundleArguments == null && fragment.getArguments() != null) {
                        bundleArguments = fragment.getArguments();
                    } else if (bundleArguments == null) {
                        bundleArguments = new Bundle();
                    }
                    bundleArguments.putString("layout_name", newRootTabSpecDetails.getLayoutName());
                    bundleArguments.putString("cit-screen-type", "cit-tab-content");
                    fragment.setArguments(bundleArguments);
                    newRootTabSpecDetails.setFragment(fragment);
                    FragmentTransaction ft = this.getChildFragmentManager().beginTransaction();
                    ft.replace(R.id.cit_tab_container, (Fragment)fragment, newRootTabSpecDetails.getLayoutName());
                    ft.commit();
                    this.tabSpecDetails = newRootTabSpecDetails;
                    this.tabSpecDetails.setChildFragmentManager(this.getChildFragmentManager());
                    this.navigationCIT.getActivityCIT().updateTabChildTabManager(this.tabIndex, this.tabSpecDetails);
                }
            }
        }
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        if (!this.isActivate) {
            this.isActivate = true;
            this.navigationCIT = (INavigationCIT)this.getActivity();
            if (this.navigationCIT != null && this.navigationCIT.getListTabSpec() != null && this.tabIndex != -1) {
                this.tabSpecDetails = this.navigationCIT.getListTabSpec().get(this.tabIndex);
                Fragment fragment = this.tabSpecDetails.getFragment();
                String layout2 = this.tabSpecDetails.getLayoutName();
                Bundle bundle = this.getArguments();
                bundle.putString("cit-screen-type", "cit-tab-content");
                bundle.putString("layout_name", layout2);
                if (fragment == null) {
                    fragment = new CITFragment();
                }
                fragment.setArguments(bundle);
                FragmentTransaction ft = this.getChildFragmentManager().beginTransaction();
                ft.replace(R.id.cit_tab_container, fragment, layout2);
                ft.commit();
                this.tabSpecDetails.setChildFragmentManager(this.getChildFragmentManager());
                this.navigationCIT.getActivityCIT().updateTabChildTabManager(this.tabIndex, this.tabSpecDetails);
                if (this.selectedTabIndex == this.tabIndex) {
                    this.navigationCIT.setCurrentFragment(fragment);
                }
            }
        }
    }
}

