/*
 * Decompiled with CFR 0.152.
 */
package com.configureit.navigation;

import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import com.configureit.navigation.CITActivity;
import com.configureit.navigation.CITSlidePanelDetails;
import com.configureit.navigation.CITTabContainer;
import com.configureit.navigation.IFragmentDetails;
import com.configureit.navigation.INavigationCIT;

public class CITFragment
extends Fragment
implements IFragmentDetails,
FragmentManager.OnBackStackChangedListener {
    private String screenType;
    private View v = null;
    private Bundle bundle;
    private long citFragmentID;
    private String layout;
    private int layoutID;
    private boolean shouldCall = true;
    private boolean tabFragment;
    private int status = 0;
    public static final int CREATE = 0;
    public static final int PAUSE = 1;
    public static final int STOP = 2;
    public static final int RESUME = 3;
    public static final int START = 4;
    public boolean addedToStack = true;
    private CITSlidePanelDetails citLeftSlidePanelDetails;
    private CITSlidePanelDetails citRightSlidePanelDetails;
    private int direction;
    private Animation.AnimationListener animationListener = new Animation.AnimationListener(){

        public void onAnimationStart(Animation animation) {
            CITFragment.this.onScreenTransitionStart();
        }

        public void onAnimationEnd(Animation animation) {
            CITFragment.this.onScreenTransitionCompleted();
        }

        public void onAnimationRepeat(Animation animation) {
        }
    };
    private boolean animationTransition = false;
    private Handler handle = new Handler(){

        public void handleMessage(Message msg) {
        }
    };
    CITActivity citActivity;

    public boolean isScreenResumed() {
        if (this.status != 0) {
            return !this.isAddedToStack();
        }
        return false;
    }

    public long getCitFragmentID() {
        return this.citFragmentID;
    }

    public void addedToStack(boolean addedToStack) {
        this.addedToStack = addedToStack;
    }

    public boolean isAddedToStack() {
        return this.addedToStack;
    }

    public boolean isTabFragment() {
        return this.tabFragment;
    }

    public void setTabFragment(boolean tabFragment) {
        this.tabFragment = tabFragment;
    }

    public void setLeftSlidePanelDetails(@Nullable CITSlidePanelDetails citLeftSlidePanelDetails) {
        this.citLeftSlidePanelDetails = citLeftSlidePanelDetails;
    }

    public void setRightSlidePanelDetails(@Nullable CITSlidePanelDetails citRightSlidePanelDetails) {
        this.citRightSlidePanelDetails = citRightSlidePanelDetails;
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
    }

    @Nullable
    public CITSlidePanelDetails getLeftSlidePanelDetails() {
        return this.citLeftSlidePanelDetails;
    }

    @Nullable
    public CITSlidePanelDetails getRightSlidePanelDetails() {
        return this.citRightSlidePanelDetails;
    }

    public boolean shouldCall() {
        return this.shouldCall;
    }

    public boolean isRFSScreenResumed() {
        if (this.isAddedToStack()) {
            return false;
        }
        if (!this.isAddedToStack() && this.status == 2) {
            return true;
        }
        return !this.isAddedToStack() && this.status == 1;
    }

    public void setShouldCall(boolean shouldCall) {
        this.shouldCall = shouldCall;
    }

    public void onPause() {
        super.onPause();
        if (!this.isAddedToStack() && this.status != 2) {
            this.status = 1;
        }
    }

    public void onStart() {
        super.onStart();
        this.status = 4;
    }

    public void onResume() {
        super.onResume();
        if (!this.isAddedToStack() && this.status != 2) {
            this.status = 3;
        }
    }

    @ScreenStatus
    public int getStatus() {
        return this.status;
    }

    public void onStop() {
        super.onStop();
        this.status = 2;
        if (!this.shouldCall()) {
            this.shouldCall = true;
        }
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.citFragmentID = System.currentTimeMillis();
        this.status = 0;
        this.bundle = this.getArguments();
        if (Build.VERSION.SDK_INT >= 12) {
            this.layout = this.bundle.getString("layout_name", "");
            this.screenType = this.bundle.getString("cit-screen-type", "");
        } else {
            this.layout = this.bundle.getString("layout_name");
            this.screenType = this.bundle.getString("cit-screen-type");
        }
        this.direction = this.bundle.getInt("direction");
        int n = this.layoutID = !CITActivity.isEmpty(this.layout) ? this.getActivity().getResources().getIdentifier(this.layout, "layout", this.getActivity().getPackageName()) : 0;
        if ("left-slide-content".equalsIgnoreCase(this.screenType)) {
            ((CITActivity)this.getActivity()).setLeftSideFragment(this);
        } else if ("right-slide-content".equalsIgnoreCase(this.screenType)) {
            ((CITActivity)this.getActivity()).setRightSideFragment(this);
        } else {
            ((CITActivity)this.getActivity()).setCurrentFragment(this);
        }
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        if (this.v == null) {
            this.v = inflater.inflate(this.layoutID, container, false);
        }
        return this.v;
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.citActivity = (CITActivity)this.getActivity();
        if ("left-slide-content".equalsIgnoreCase(this.screenType)) {
            ((CITActivity)this.getActivity()).setLeftSideFragment(this);
        } else if ("right-slide-content".equalsIgnoreCase(this.screenType)) {
            ((CITActivity)this.getActivity()).setRightSideFragment(this);
        } else {
            ((CITActivity)this.getActivity()).setCurrentFragment(this);
        }
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.citActivity = (CITActivity)this.getActivity();
        if ("left-slide-content".equalsIgnoreCase(this.screenType)) {
            ((CITActivity)this.getActivity()).setLeftSideFragment(this);
        } else if ("right-slide-content".equalsIgnoreCase(this.screenType)) {
            ((CITActivity)this.getActivity()).setRightSideFragment(this);
        } else {
            ((CITActivity)this.getActivity()).setCurrentFragment(this);
        }
    }

    protected void onScreenTransitionCompleted() {
        Log.e((String)"onTransitionCompleted", (String)(this.getFragmentLayoutName() + ""));
    }

    protected void onScreenTransitionStart() {
    }

    public boolean haveAnimationTransition() {
        return this.animationTransition;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    public Animation onCreateAnimation(int transit, boolean enter, int nextAnim) {
        Animation animation = super.onCreateAnimation(transit, enter, nextAnim);
        if (enter && nextAnim != 0) {
            this.animationTransition = true;
            animation = AnimationUtils.loadAnimation((Context)this.getActivity(), (int)nextAnim);
            animation.setAnimationListener(this.animationListener);
        }
        if ("cit-tab-content".equalsIgnoreCase(this.getFragmentScreenType()) && CITActivity.disableAnimation) {
            animation = new Animation(){};
            animation.setDuration(0L);
            this.animationTransition = true;
            animation.setAnimationListener(this.animationListener);
        }
        if (animation != null) {
            animation.setAnimationListener(this.animationListener);
        }
        return animation;
    }

    @Override
    public String getFragmentLayoutName() {
        return this.layout;
    }

    @Override
    public int getFragmentLayoutResourceId() {
        return this.layoutID;
    }

    @Override
    public String getFragmentScreenType() {
        return this.screenType;
    }

    @Override
    public INavigationCIT getNavigationDetails() {
        return (INavigationCIT)this.getActivity();
    }

    @Override
    public View getFragmentViewCIT() {
        return this.v;
    }

    @Override
    public Fragment getFragment() {
        return this;
    }

    public void onBackStackChanged() {
        if (this.citActivity == null) {
            this.citActivity = (CITActivity)this.getActivity();
        }
        if (this.citActivity != null) {
            int nowCount = this.citActivity.getFragmentManagerCIT().getBackStackEntryCount();
            int prevCount = this.citActivity.getSupportFMPrevCount();
            CITFragment citFragment = (CITFragment)this.citActivity.getCurrentFragment();
            if ("cit-tab-content".equalsIgnoreCase(this.getFragmentScreenType()) && this.citActivity.getTabHost() != null) {
                CITTabContainer tabContainer = this.citActivity.getTabContainer(this.citActivity.getTabHost().getCurrentTab());
                if (tabContainer != null) {
                    prevCount = tabContainer.getTabFMPrevCount();
                }
                if (prevCount != nowCount && citFragment != null && this.citFragmentID == citFragment.getCitFragmentID()) {
                    this.citActivity.getFragmentManagerCIT().removeOnBackStackChangedListener((FragmentManager.OnBackStackChangedListener)this);
                    if (prevCount > nowCount && !this.addedToStack) {
                        this.citActivity.popBackStack();
                    }
                }
            } else if (CITActivity.isEmpty(this.getFragmentScreenType()) && this.citActivity.getSupportFMPrevCount() != nowCount && citFragment != null && this.citFragmentID == citFragment.getCitFragmentID()) {
                this.citActivity.getFragmentManagerCIT().removeOnBackStackChangedListener((FragmentManager.OnBackStackChangedListener)this);
                if (this.citActivity.getSupportFMPrevCount() > nowCount && !this.addedToStack) {
                    this.citActivity.popBackStack();
                }
            }
        }
    }

    public static @interface ScreenStatus {
    }
}

