/*
 * Decompiled with CFR 0.152.
 */
package com.configureit.navigation;

import android.app.Activity;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Point;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.PersistableBundle;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTabHost;
import android.support.v4.app.FragmentTransaction;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import android.util.Log;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.widget.FrameLayout;
import com.configureit.navigation.CITFragment;
import com.configureit.navigation.CITLeftSlideContainer;
import com.configureit.navigation.CITNavigationConstants;
import com.configureit.navigation.CITRightSlideContainer;
import com.configureit.navigation.CITSlidePanelDetails;
import com.configureit.navigation.CITTabBarDetails;
import com.configureit.navigation.CITTabContainer;
import com.configureit.navigation.CITTabFragment;
import com.configureit.navigation.IFragmentDetails;
import com.configureit.navigation.INavigationCIT;
import com.configureit.navigation.TabSpecDetails;
import com.jeremyfeinstein.slidingmenu.lib.SlidingMenu;
import configureit.citnavigationlib.R;
import java.util.ArrayList;

public class CITActivity
extends AppCompatActivity
implements INavigationCIT {
    private String TAG = "CITActivity";
    public static boolean LOG_NAVIGATION_LIBRARY = true;
    private Fragment currentFragment;
    private Fragment leftSideFragment;
    private Fragment rightSideFragment;
    private FragmentTabHost fragmentTabHost;
    private ArrayList<TabSpecDetails> listTabSpec;
    private FragmentManager tabFragmentManager;
    private SlidingMenu menu;
    public static int BASE_WIDTH = 320;
    private int supportFMPrevCount;
    private CITTabBarDetails tabBarDetails;
    public static boolean disableAnimation = false;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        FrameLayout frameLayout = new FrameLayout((Context)this);
        frameLayout.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        frameLayout.setBackgroundColor(-1);
        frameLayout.setId(R.id.cit_activity_framecontent);
        this.setContentView((View)frameLayout);
    }

    public int getPercentage(int pixel) {
        int width;
        pixel = BASE_WIDTH - pixel;
        Display display = this.getWindowManager().getDefaultDisplay();
        if (Build.VERSION.SDK_INT >= 13) {
            Point size = new Point();
            display.getSize(size);
            width = size.x;
        } else {
            width = display.getWidth();
        }
        return width * pixel / BASE_WIDTH;
    }

    public void setSlideMenu(SlidingMenu menu) {
        this.menu = menu;
    }

    public void pushSlidePanel(final CITSlidePanelDetails citSlidePanelDetails) {
        try {
            if (this.menu == null) {
                this.menu = new SlidingMenu((Context)this);
                if (citSlidePanelDetails.getSideMenuAnimation() != 0) {
                    final Interpolator interp = new Interpolator(){

                        public float getInterpolation(float t) {
                            return (t -= 1.0f) * t * t + 1.0f;
                        }
                    };
                    this.menu.setBehindCanvasTransformer(new SlidingMenu.CanvasTransformer(){

                        @Override
                        public void transformCanvas(Canvas canvas, float percentOpen) {
                            switch (citSlidePanelDetails.getSideMenuAnimation()) {
                                case 1: {
                                    break;
                                }
                                case 2: {
                                    canvas.translate(0.0f, (float)canvas.getHeight() * (1.0f - interp.getInterpolation(percentOpen)));
                                    break;
                                }
                                case 3: {
                                    float scale = (float)((double)percentOpen * 0.25 + 0.75);
                                    canvas.scale(scale, scale, (float)(canvas.getWidth() / 2), (float)(canvas.getHeight() / 2));
                                    break;
                                }
                            }
                        }
                    });
                }
                this.menu.setTouchModeAbove(citSlidePanelDetails.isSwipeEnable() ? 1 : 2);
                this.menu.setFadeEnabled(true);
                this.menu.setShadowWidth(citSlidePanelDetails.getShadowWidth());
                this.menu.setShadowDrawable(citSlidePanelDetails.getShadowDrawable());
                if (citSlidePanelDetails.isShadowEnable()) {
                    if (citSlidePanelDetails.getSlidePanelType() == 0) {
                        this.menu.setShadowDrawable(R.drawable.shadow);
                    } else {
                        this.menu.setShadowDrawable(R.drawable.shadowright);
                    }
                }
                this.menu.setBehindOffset(this.getPercentage(citSlidePanelDetails.getSlideWidth()));
                this.menu.setFadeDegree(citSlidePanelDetails.getFadeDegree());
                this.menu.attachToActivity((Activity)this, citSlidePanelDetails.isSlideWithActionBar() ? 0 : 1, false);
            }
            FrameLayout frameLayout = new FrameLayout((Context)this);
            frameLayout.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
            frameLayout.setBackgroundColor(-1);
            if (citSlidePanelDetails.getSlidePanelType() == 0) {
                frameLayout.setId(R.id.cit_left_slide_view);
                this.menu.setMode(0);
                this.menu.setMenu((View)frameLayout);
                Bundle bundleLeftSide = new Bundle();
                bundleLeftSide.putString("cit-screen-type", "left-slide-content");
                bundleLeftSide.putString("layout_name", citSlidePanelDetails.getLayoutName());
                CITLeftSlideContainer citLeftSlideContainer = new CITLeftSlideContainer();
                citLeftSlideContainer.setCustomLeftSlideFragment(citSlidePanelDetails.getSidePanelFragment());
                citLeftSlideContainer.setLeftSlidePanelDetails(citSlidePanelDetails);
                citLeftSlideContainer.setArguments(bundleLeftSide);
                this.getSupportFragmentManager().beginTransaction().replace(R.id.cit_left_slide_view, (Fragment)citLeftSlideContainer, "cit_slide_left_container").commit();
            }
            if (citSlidePanelDetails.getSlidePanelType() == 1) {
                frameLayout.setId(R.id.cit_right_slide_view);
                this.menu.setMode(1);
                this.menu.setMenu((View)frameLayout);
                Bundle bundleRightSide = new Bundle();
                bundleRightSide.putString("cit-screen-type", "right-slide-content");
                bundleRightSide.putString("layout_name", citSlidePanelDetails.getLayoutName());
                CITRightSlideContainer citRightSlideContainer = new CITRightSlideContainer();
                citRightSlideContainer.setCustomRightSlideFragment(citSlidePanelDetails.getSidePanelFragment());
                citRightSlideContainer.setRightSlidePanelDetails(citSlidePanelDetails);
                citRightSlideContainer.setArguments(bundleRightSide);
                this.getSupportFragmentManager().beginTransaction().replace(R.id.cit_right_slide_view, (Fragment)citRightSlideContainer, "cit_slide_right_container").commit();
            }
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)e.getMessage());
        }
    }

    public void pushSlidePanel(CITSlidePanelDetails leftSlidePanelDetails, CITSlidePanelDetails rightSlidePanelDetails) {
        if (this.menu == null) {
            this.menu = new SlidingMenu((Context)this);
            this.menu.setTouchModeAbove(leftSlidePanelDetails.isSwipeEnable() ? 1 : 2);
            this.menu.setShadowWidth(leftSlidePanelDetails.getShadowWidth());
            int animationType = 0;
            if (leftSlidePanelDetails.getSideMenuAnimation() != 0) {
                animationType = leftSlidePanelDetails.getSideMenuAnimation();
            }
            if (rightSlidePanelDetails.getSideMenuAnimation() != 0) {
                animationType = rightSlidePanelDetails.getSideMenuAnimation();
            }
            if (animationType != 0) {
                final Interpolator interp = new Interpolator(){

                    public float getInterpolation(float t) {
                        return (t -= 1.0f) * t * t + 1.0f;
                    }
                };
                final int finalAnimationType = animationType;
                this.menu.setBehindCanvasTransformer(new SlidingMenu.CanvasTransformer(){

                    @Override
                    public void transformCanvas(Canvas canvas, float percentOpen) {
                        switch (finalAnimationType) {
                            case 1: {
                                break;
                            }
                            case 2: {
                                canvas.translate(0.0f, (float)canvas.getHeight() * (1.0f - interp.getInterpolation(percentOpen)));
                                break;
                            }
                            case 3: {
                                float scale = (float)((double)percentOpen * 0.25 + 0.75);
                                canvas.scale(scale, scale, (float)(canvas.getWidth() / 2), (float)(canvas.getHeight() / 2));
                                break;
                            }
                        }
                    }
                });
            }
            if (leftSlidePanelDetails.isShadowEnable() && leftSlidePanelDetails.getSlidePanelType() == 0) {
                this.menu.setShadowDrawable(R.drawable.shadow);
            }
            if (rightSlidePanelDetails.isShadowEnable()) {
                this.menu.setShadowWidth(rightSlidePanelDetails.getShadowWidth());
                if (rightSlidePanelDetails.getSlidePanelType() == 1) {
                    this.menu.setShadowDrawable(R.drawable.shadow);
                    this.menu.setSecondaryShadowDrawable(R.drawable.shadowright);
                }
            }
            this.menu.setBehindOffset(this.getPercentage(leftSlidePanelDetails.getSlideWidth()));
            this.menu.setFadeDegree(leftSlidePanelDetails.getFadeDegree());
            this.menu.attachToActivity((Activity)this, leftSlidePanelDetails.isSlideWithActionBar() ? 0 : 1);
        }
        FrameLayout frameLayout = new FrameLayout((Context)this);
        frameLayout.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        frameLayout.setBackgroundColor(-1);
        frameLayout.setId(R.id.cit_left_slide_view);
        this.menu.setMode(2);
        this.menu.setMenu((View)frameLayout);
        Bundle bundleLeftSide = new Bundle();
        bundleLeftSide.putString("cit-screen-type", "left-slide-content");
        bundleLeftSide.putString("layout_name", leftSlidePanelDetails.getLayoutName());
        CITLeftSlideContainer citLeftSlideContainer = new CITLeftSlideContainer();
        citLeftSlideContainer.setCustomLeftSlideFragment(leftSlidePanelDetails.getSidePanelFragment());
        citLeftSlideContainer.setLeftSlidePanelDetails(leftSlidePanelDetails);
        citLeftSlideContainer.setArguments(bundleLeftSide);
        this.getSupportFragmentManager().beginTransaction().replace(R.id.cit_left_slide_view, (Fragment)citLeftSlideContainer, "cit_slide_left_container").commit();
        frameLayout = new FrameLayout((Context)this);
        frameLayout.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        frameLayout.setBackgroundColor(-1);
        frameLayout.setId(R.id.cit_right_slide_view);
        this.menu.setSecondaryMenu((View)frameLayout);
        Bundle bundleRightSide = new Bundle();
        bundleRightSide.putString("cit-screen-type", "right-slide-content");
        bundleRightSide.putString("layout_name", rightSlidePanelDetails.getLayoutName());
        CITRightSlideContainer citRightSlideContainer = new CITRightSlideContainer();
        citRightSlideContainer.setCustomRightSlideFragment(rightSlidePanelDetails.getSidePanelFragment());
        citRightSlideContainer.setRightSlidePanelDetails(rightSlidePanelDetails);
        citRightSlideContainer.setArguments(bundleRightSide);
        this.getSupportFragmentManager().beginTransaction().replace(R.id.cit_right_slide_view, (Fragment)citRightSlideContainer, "cit_slide_right_container").commit();
    }

    public void popSlidePanelScreen(@CITNavigationConstants.SlidePanelMode int slidePanelMode, String tag) {
        if (slidePanelMode == 0) {
            CITFragment citFragment = (CITFragment)this.getSupportFragmentManager().findFragmentByTag("cit_slide_left_container");
            if (citFragment != null) {
                FragmentManager childFragmentManager = citFragment.getChildFragmentManager();
                childFragmentManager.popBackStack(null, 1);
            }
        } else {
            CITFragment citFragment = (CITFragment)this.getSupportFragmentManager().findFragmentByTag("cit_slide_right_container");
            if (citFragment != null) {
                FragmentManager childFragmentManager = citFragment.getChildFragmentManager();
                childFragmentManager.popBackStack(null, 1);
            }
        }
    }

    public void onLeftMenuOpened() {
    }

    public void onLeftMenuClosed() {
    }

    public void pushInsideSlidePanel(@CITNavigationConstants.SlidePanelMode int slidePanelMode, @NonNull String layoutname, @Nullable CITFragment fragment, @Nullable Bundle bundleArguments, @Nullable String prevFragmentTag, boolean addToStack) {
        Fragment citLeftSlideContainer = this.getSupportFragmentManager().findFragmentByTag(0 == slidePanelMode ? "cit_slide_left_container" : "cit_slide_right_container");
        if (citLeftSlideContainer != null) {
            CITFragment citFragment = (CITFragment)citLeftSlideContainer;
            FragmentManager leftFragmentManager = citLeftSlideContainer.getChildFragmentManager();
            if (fragment == null) {
                fragment = new CITFragment();
            }
            if (0 == slidePanelMode) {
                fragment.setLeftSlidePanelDetails(citFragment.getLeftSlidePanelDetails());
            } else {
                fragment.setRightSlidePanelDetails(citFragment.getRightSlidePanelDetails());
            }
            if (bundleArguments == null && fragment.getArguments() != null) {
                bundleArguments = fragment.getArguments();
            } else if (bundleArguments == null) {
                bundleArguments = new Bundle();
            }
            if (slidePanelMode == 0) {
                bundleArguments.putString("cit-screen-type", "left-slide-content");
            } else {
                bundleArguments.putString("cit-screen-type", "right-slide-content");
            }
            bundleArguments.putString("layout_name", layoutname);
            fragment.setArguments(bundleArguments);
            FragmentTransaction ft = leftFragmentManager.beginTransaction();
            if (slidePanelMode == 0) {
                ft.replace(R.id.cit_left_slide_container, (Fragment)fragment, layoutname);
            } else {
                ft.replace(R.id.cit_right_slide_container, (Fragment)fragment, layoutname);
            }
            fragment.setShouldCall(true);
            if (addToStack) {
                ft.addToBackStack(prevFragmentTag);
            } else {
                CITFragment fragment1;
                FragmentManager.BackStackEntry entry;
                int size = leftFragmentManager.getBackStackEntryCount() - 1;
                if (size >= 0 && (entry = leftFragmentManager.getBackStackEntryAt(size)) != null && (fragment1 = (CITFragment)leftFragmentManager.findFragmentByTag(entry.getName())) != null) {
                    prevFragmentTag = fragment1.getTag();
                    fragment1.setShouldCall(false);
                }
                leftFragmentManager.popBackStackImmediate();
                ft.addToBackStack(prevFragmentTag);
            }
            ft.commit();
        }
    }

    public static boolean isEmpty(@Nullable CharSequence str) {
        return str == null || TextUtils.isEmpty((CharSequence)str.toString().trim()) || "null".equalsIgnoreCase(str.toString());
    }

    public void pushButPopIfLoaded(@NonNull String layoutname, @Nullable CITFragment fragment, Bundle bundleArguments, String prevFragmentTag, boolean reloadFromStack, boolean addToStack, boolean enableAnimation, String animationType) {
        if (reloadFromStack) {
            int stackCount = this.getSupportFragmentManager().getBackStackEntryCount();
            for (int i = 0; i < stackCount; ++i) {
                CITFragment popFragment;
                FragmentManager.BackStackEntry stackEntry = this.getSupportFragmentManager().getBackStackEntryAt(i);
                if (!layoutname.equalsIgnoreCase(stackEntry.getName()) || (popFragment = (CITFragment)this.getSupportFragmentManager().findFragmentByTag(stackEntry.getName())) == null || !popFragment.isAddedToStack() || layoutname.equalsIgnoreCase(prevFragmentTag)) continue;
                this.pop(layoutname);
                return;
            }
        }
        this.push(layoutname, fragment, bundleArguments, prevFragmentTag, addToStack, enableAnimation, animationType);
    }

    public void onTabChanged(String tabId) {
        Log.e((String)"onTabChanged", (String)tabId);
        disableAnimation = true;
    }

    public void pushInsideTabButPopIfLoaded(@NonNull String layoutname, @Nullable CITFragment fragment, Bundle bundleArguments, String prevFragmentTag, boolean reloadFromStack, boolean addToStack, boolean enableAnimation, @CITNavigationConstants.NavigationAnimation String animationType) {
        FragmentManager fm = this.getFragmentManagerCIT();
        if (reloadFromStack && fm != null) {
            int stackCount = fm.getBackStackEntryCount();
            for (int i = 0; i < stackCount; ++i) {
                CITFragment popFragment;
                FragmentManager.BackStackEntry stackEntry = fm.getBackStackEntryAt(i);
                if (!layoutname.equalsIgnoreCase(stackEntry.getName()) || (popFragment = (CITFragment)fm.findFragmentByTag(stackEntry.getName())) == null || !popFragment.isAddedToStack() || layoutname.equalsIgnoreCase(prevFragmentTag)) continue;
                this.pop(layoutname);
                return;
            }
        }
        this.pushInsideTab(layoutname, fragment, bundleArguments, prevFragmentTag, addToStack, enableAnimation, animationType);
    }

    public void popRootViewController(int tabIndex) {
        if (this.getTabHost() != null && this.tabBarDetails != null && this.getListTabSpec() != null && !this.getListTabSpec().isEmpty()) {
            CITTabContainer citTabContainer = this.getTabContainer(tabIndex);
            TabSpecDetails currentRootTabDetails = this.getListTabSpec().get(tabIndex);
            String existingTopScreenName = currentRootTabDetails.getLayoutName();
            if (citTabContainer != null) {
                if (this.getTabHost().getCurrentTab() != tabIndex) {
                    citTabContainer.updateTabSpecDetailsMap("popToRootViewController", currentRootTabDetails);
                } else {
                    this.pop(null);
                }
            }
        }
    }

    @Nullable
    public CITTabContainer getTabContainer(int tabIndex) {
        if (this.tabBarDetails != null && this.getListTabSpec() != null && !this.getListTabSpec().isEmpty()) {
            Fragment tabContainer;
            String tabBarTag = this.tabBarDetails.getTabBarAlignment() == 1 ? "top_tabbar" : "bottom_tabbar";
            Fragment tabBarFragment = this.getSupportFragmentManager().findFragmentByTag(tabBarTag);
            if (tabBarFragment != null && CITTabContainer.class.isInstance(tabContainer = tabBarFragment.getChildFragmentManager().findFragmentByTag("cit_tab_container_" + tabIndex))) {
                return (CITTabContainer)tabContainer;
            }
        }
        return null;
    }

    public void changeRootViewController(int tabIndex, @Nullable CITFragment citFragment, @NonNull String rootViewScreenName, boolean enableAnimation, @CITNavigationConstants.NavigationAnimation String animationType) {
        if (this.getTabHost() != null && this.tabBarDetails != null && !this.tabBarDetails.getListTabSpecDetails().isEmpty()) {
            CITTabContainer citTabContainer = this.getTabContainer(tabIndex);
            TabSpecDetails currentRootTabDetails = this.tabBarDetails.getListTabSpecDetails().get(tabIndex);
            String existingTopScreenName = currentRootTabDetails.getLayoutName();
            if (citTabContainer != null) {
                currentRootTabDetails.setLayoutName(rootViewScreenName);
                if (citFragment == null) {
                    citFragment = new CITFragment();
                }
                currentRootTabDetails.setFragment(citFragment);
                if (this.getTabHost().getCurrentTab() != tabIndex) {
                    citTabContainer.updateTabSpecDetailsMap("changeRootViewController", currentRootTabDetails);
                } else {
                    this.pop(null);
                    this.pushInsideTab(rootViewScreenName, citFragment, null, existingTopScreenName, false, enableAnimation, animationType);
                }
            }
        }
    }

    public void onSaveInstanceState(Bundle outState, PersistableBundle outPersistentState) {
        super.onSaveInstanceState(outState, outPersistentState);
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
    }

    public int getSupportFMPrevCount() {
        return this.supportFMPrevCount;
    }

    public void push(@NonNull String layoutname, @Nullable CITFragment fragment, @Nullable Bundle bundle, @Nullable String prevFragmentTag, boolean addToStack, boolean enableAnimation, @CITNavigationConstants.NavigationAnimation String animationType) {
        try {
            int[] animations;
            this.supportFMPrevCount = this.getSupportFragmentManager().getBackStackEntryCount() + 1;
            if (fragment == null) {
                fragment = new CITFragment();
            }
            if (bundle == null && fragment.getArguments() != null) {
                bundle = fragment.getArguments();
            } else if (bundle == null) {
                bundle = new Bundle();
            }
            bundle.putString("layout_name", layoutname);
            bundle.putString("cit-normal-content", layoutname);
            fragment.setArguments(bundle);
            FragmentTransaction ft = this.getSupportFragmentManager().beginTransaction();
            CITFragment citFragment = (CITFragment)this.getCurrentFragment();
            if ("bottom_tabbar".equalsIgnoreCase(prevFragmentTag) || "top_tabbar".equalsIgnoreCase(prevFragmentTag)) {
                enableAnimation = false;
            }
            if (citFragment != null) {
                disableAnimation = false;
            }
            if (enableAnimation && (animations = CITNavigationConstants.getAnimation(animationType)) != null) {
                ft.setCustomAnimations(animations[0], animations[1], animations[2], animations[3]);
            }
            ft.replace(R.id.cit_activity_framecontent, (Fragment)fragment, layoutname);
            fragment.setShouldCall(true);
            if (citFragment == null) {
                ft.addToBackStack(null);
                fragment.addedToStack(false);
            } else {
                ft.addToBackStack(prevFragmentTag);
            }
            ft.commit();
            if (this.supportFMPrevCount > 1 && citFragment != null && !addToStack) {
                citFragment.addedToStack(false);
                this.getSupportFragmentManager().addOnBackStackChangedListener((FragmentManager.OnBackStackChangedListener)citFragment);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onBackPressed() {
        boolean isSlideMenuOpen = false;
        disableAnimation = false;
        if (this.getSlidingMenu() != null) {
            boolean bl = isSlideMenuOpen = this.getSlidingMenu().isMenuShowing() || this.getSlidingMenu().isSecondaryMenuShowing();
            if (this.getSlidingMenu().isMenuShowing()) {
                this.getSlidingMenu().toggle(true);
            } else if (this.getSlidingMenu().isSecondaryMenuShowing()) {
                this.getSlidingMenu().toggle(true);
            }
        }
        if (!isSlideMenuOpen) {
            this.popBackStack();
        }
    }

    public void popBackStack() {
        boolean done = false;
        String screenType = "";
        if (IFragmentDetails.class.isInstance(this.getCurrentFragment())) {
            IFragmentDetails fragmentDetails = (IFragmentDetails)this.getCurrentFragment();
            screenType = fragmentDetails.getFragmentScreenType();
        }
        if ("cit-tab-content".equalsIgnoreCase(screenType) && this.getFragmentManagerCIT() != null) {
            boolean bl = done = this.getFragmentManagerCIT().getBackStackEntryCount() > 0 && this.getFragmentManagerCIT().popBackStackImmediate();
        }
        if (!done) {
            if (this.getSupportFragmentManager().getBackStackEntryCount() == 1) {
                this.finish();
            } else {
                this.getSupportFragmentManager().popBackStackImmediate();
            }
        }
    }

    public static Drawable getDrawable(@NonNull Context context, @DrawableRes int resouceId) {
        if (Build.VERSION.SDK_INT >= 21) {
            return context.getResources().getDrawable(resouceId, context.getTheme());
        }
        return context.getResources().getDrawable(resouceId);
    }

    public void pushTabBar(CITTabBarDetails citTabBarDetails, @Nullable String prevFragmentTag, boolean addToStack) {
        Bundle bundle = new Bundle();
        CITTabFragment citTabFragment = new CITTabFragment();
        citTabFragment.setTabBarDetails(citTabBarDetails);
        this.tabBarDetails = citTabBarDetails;
        this.listTabSpec = citTabBarDetails.getListTabSpecDetails();
        String layoutName = citTabBarDetails.getTabBarAlignment() == 0 ? "bottom_tabbar" : "top_tabbar";
        bundle.putString("layout_name", layoutName);
        bundle.putInt("default-selected-tab-index", citTabBarDetails.getDefaultSelectedTab());
        citTabFragment.setArguments(bundle);
        FragmentTransaction ft = this.getSupportFragmentManager().beginTransaction();
        if (!CITActivity.isEmpty(layoutName)) {
            ft.replace(R.id.cit_activity_framecontent, (Fragment)citTabFragment, layoutName);
        } else {
            ft.replace(R.id.cit_activity_framecontent, (Fragment)citTabFragment);
        }
        if (addToStack) {
            ft.addToBackStack(prevFragmentTag);
        }
        ft.commit();
    }

    public void exitFromApplication() {
        if (this.getSlidingMenu() != null) {
            if (this.getSlidingMenu().isMenuShowing()) {
                this.getSlidingMenu().toggle(true);
            } else if (this.getSlidingMenu().isSecondaryMenuShowing()) {
                this.getSlidingMenu().toggle(true);
            }
        }
        this.finish();
    }

    public void pushTabBarButPopIfLoaded(CITTabBarDetails citTabBarDetails, @Nullable String prevFragmentTag, boolean addToStack, boolean enableAnimation, @CITNavigationConstants.NavigationAnimation String animationType) {
        int[] animations;
        this.supportFMPrevCount = this.getSupportFragmentManager().getBackStackEntryCount() + 1;
        String layoutName = citTabBarDetails.getTabBarAlignment() == 0 ? "bottom_tabbar" : "top_tabbar";
        int stackCount = this.getSupportFragmentManager().getBackStackEntryCount();
        for (int i = 0; i < stackCount; ++i) {
            FragmentManager.BackStackEntry stackEntry = this.getSupportFragmentManager().getBackStackEntryAt(i);
            if (!layoutName.equalsIgnoreCase(stackEntry.getName())) continue;
            this.pop(layoutName);
            return;
        }
        Bundle bundle = new Bundle();
        CITTabFragment citTabFragment = new CITTabFragment();
        citTabFragment.setTabBarDetails(citTabBarDetails);
        this.tabBarDetails = citTabBarDetails;
        this.listTabSpec = citTabBarDetails.getListTabSpecDetails();
        bundle.putString("layout_name", layoutName);
        bundle.putInt("default-selected-tab-index", citTabBarDetails.getDefaultSelectedTab());
        citTabFragment.setArguments(bundle);
        FragmentTransaction ft = this.getSupportFragmentManager().beginTransaction();
        CITFragment citFragment = (CITFragment)this.getCurrentFragment();
        if (enableAnimation && (animations = CITNavigationConstants.getAnimation(animationType)) != null) {
            ft.setCustomAnimations(animations[0], animations[1], animations[2], animations[3]);
        }
        if (!CITActivity.isEmpty(layoutName)) {
            ft.replace(R.id.cit_activity_framecontent, (Fragment)citTabFragment, layoutName);
        } else {
            ft.replace(R.id.cit_activity_framecontent, (Fragment)citTabFragment);
        }
        if (citFragment == null) {
            ft.addToBackStack(null);
            citTabFragment.addedToStack(false);
        } else {
            ft.addToBackStack(prevFragmentTag);
        }
        ft.commit();
        if (this.supportFMPrevCount > 1 && citFragment != null && !addToStack) {
            citFragment.addedToStack(false);
            this.getSupportFragmentManager().addOnBackStackChangedListener((FragmentManager.OnBackStackChangedListener)citFragment);
        }
    }

    public void pushInsideTab(@NonNull String layoutname, @Nullable Fragment fragment, Bundle bundleArguments, @Nullable String prevFragmentTag, boolean addToStack, boolean enableAnimation, String animationType) {
        try {
            if (this.getTabHost() != null && this.getListTabSpec() != null && !this.getListTabSpec().isEmpty()) {
                CITTabContainer citTabContainer = this.getTabContainer(this.getTabHost().getCurrentTab());
                FragmentManager childFragmentManager = this.getFragmentManagerCIT();
                if (citTabContainer != null) {
                    childFragmentManager = citTabContainer.getChildFragmentManager();
                }
                if (childFragmentManager != null) {
                    int[] animations;
                    if (citTabContainer != null) {
                        citTabContainer.setTabFMPrevCount(childFragmentManager.getBackStackEntryCount() + 1);
                    }
                    if (fragment == null) {
                        fragment = new CITFragment();
                    }
                    if (bundleArguments == null && fragment.getArguments() != null) {
                        bundleArguments = fragment.getArguments();
                    } else if (bundleArguments == null) {
                        bundleArguments = new Bundle();
                    }
                    bundleArguments.putString("layout_name", layoutname);
                    bundleArguments.putString("cit-screen-type", "cit-tab-content");
                    fragment.setArguments(bundleArguments);
                    FragmentTransaction ft = childFragmentManager.beginTransaction();
                    disableAnimation = false;
                    if (enableAnimation && (animations = CITNavigationConstants.getAnimation(animationType)) != null) {
                        ft.setCustomAnimations(animations[0], animations[1], animations[2], animations[3]);
                    }
                    ft.replace(R.id.cit_tab_container, fragment, layoutname);
                    CITFragment citFragment = null;
                    if (CITFragment.class.isInstance(this.getCurrentFragment())) {
                        citFragment = (CITFragment)this.getCurrentFragment();
                        if (!addToStack) {
                            citFragment.addedToStack(false);
                        }
                    }
                    if (childFragmentManager.getBackStackEntryCount() == 0) {
                        ft.addToBackStack(null);
                    } else {
                        ft.addToBackStack(prevFragmentTag);
                    }
                    ft.commit();
                    if (citTabContainer != null && citTabContainer.getTabFMPrevCount() > 1 && citFragment != null && !addToStack) {
                        citFragment.addedToStack(false);
                        childFragmentManager.addOnBackStackChangedListener((FragmentManager.OnBackStackChangedListener)citFragment);
                    }
                    this.setFragmentManagerCIT(childFragmentManager);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void pop(@Nullable String tag) {
        boolean done = false;
        if (this.getFragmentManagerCIT() != null) {
            done = this.getFragmentManagerCIT().popBackStackImmediate(tag, 1);
        }
        if (!done) {
            this.getSupportFragmentManager().popBackStackImmediate(tag, 1);
        }
    }

    public void pop() {
        this.getSupportFragmentManager().popBackStackImmediate(null, 1);
    }

    @Override
    public void setTabHost(@Nullable FragmentTabHost tabHost) {
        this.fragmentTabHost = tabHost;
    }

    @Override
    @Nullable
    public FragmentTabHost getTabHost() {
        return this.fragmentTabHost;
    }

    @Override
    public void setCurrentFragment(@NonNull Fragment currentFragment) {
        this.currentFragment = currentFragment;
    }

    @Override
    public void setRightSideFragment(@NonNull Fragment rightSideFragment) {
        this.rightSideFragment = rightSideFragment;
    }

    @Override
    public void setLeftSideFragment(@NonNull Fragment leftSideFragment) {
        this.leftSideFragment = leftSideFragment;
    }

    @Override
    @Nullable
    public Fragment getRightSideFragment() {
        return this.rightSideFragment;
    }

    @Override
    @Nullable
    public Fragment getLeftSideFragment() {
        return this.leftSideFragment;
    }

    @Override
    @NonNull
    public Fragment getCurrentFragment() {
        return this.currentFragment;
    }

    @Override
    @NonNull
    public CITActivity getActivityCIT() {
        return this;
    }

    @Override
    @Nullable
    public ArrayList<TabSpecDetails> getListTabSpec() {
        return this.listTabSpec;
    }

    @Override
    @Nullable
    public FragmentManager getFragmentManagerCIT() {
        String screenType = "";
        if (IFragmentDetails.class.isInstance(this.getCurrentFragment())) {
            IFragmentDetails fragmentDetails = (IFragmentDetails)this.getCurrentFragment();
            screenType = fragmentDetails.getFragmentScreenType();
        }
        if ("cit-tab-content".equalsIgnoreCase(screenType)) {
            CITTabContainer citTabContainer;
            int index;
            if (this.getTabHost() != null && this.getListTabSpec() != null && !this.getListTabSpec().isEmpty() && (index = this.getTabHost().getCurrentTab()) != -1 && (citTabContainer = this.getTabContainer(index)) != null) {
                this.tabFragmentManager = citTabContainer.getChildFragmentManager();
            }
        } else {
            this.tabFragmentManager = this.getSupportFragmentManager();
        }
        return this.tabFragmentManager;
    }

    protected void updateTabChildTabManager(int index, TabSpecDetails tabSpecDetails) {
        if (this.listTabSpec != null && index != -1) {
            this.listTabSpec.set(index, tabSpecDetails);
        }
    }

    @Override
    public void setFragmentManagerCIT(@NonNull FragmentManager tabFragmentManager) {
        this.tabFragmentManager = tabFragmentManager;
    }

    @Override
    @Nullable
    public SlidingMenu getSlidingMenu() {
        return this.menu;
    }

    @Override
    @Nullable
    public CITLeftSlideContainer getLeftSliderContainer() {
        Fragment fragment = this.getSupportFragmentManager().findFragmentByTag("cit_slide_left_container");
        if (fragment != null) {
            return (CITLeftSlideContainer)fragment;
        }
        return null;
    }

    @Override
    @Nullable
    public CITRightSlideContainer getRightSliderContainer() {
        Fragment fragment = this.getSupportFragmentManager().findFragmentByTag("cit_slide_right_container");
        if (fragment != null) {
            return (CITRightSlideContainer)fragment;
        }
        return null;
    }
}

