/*
 * Decompiled with CFR 0.152.
 */
package com.commonsense.android.kotlin.base.extensions.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000N\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a<\u0010\u0000\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00040\u00030\u0001\"\u0004\b\u0000\u0010\u0004*\b\u0012\u0004\u0012\u0002H\u00040\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u00020\u00020\u0006\u001aU\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00040\u00030\u0003\"\u0004\b\u0000\u0010\u0004*\b\u0012\u0004\u0012\u0002H\u00040\u00032,\b\u0001\u0010\b\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u00020\n0\u00060\t\"\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u00020\n0\u0006\u00a2\u0006\u0002\u0010\u000b\u001a6\u0010\f\u001a\u00020\r\"\u0004\b\u0000\u0010\u000e*\n\u0012\u0006\u0012\u0004\u0018\u0001H\u000e0\u000f2\u001c\u0010\u0010\u001a\u0018\u0012\u0004\u0012\u0002H\u000e\u0012\u0004\u0012\u00020\r0\u0006j\b\u0012\u0004\u0012\u0002H\u000e`\u0011\u001a%\u0010\u0012\u001a\u0004\u0018\u0001H\u0004\"\u0004\b\u0000\u0010\u0004*\b\u0012\u0004\u0012\u0002H\u00040\u00132\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016\u001a9\u0010\u0017\u001a\u00020\r\"\u0004\b\u0000\u0010\u000e*\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u0002H\u000e\u0012\u0004\u0012\u00020\r0\u0006j\b\u0012\u0004\u0012\u0002H\u000e`\u00110\u000f2\u0006\u0010\u0018\u001a\u0002H\u000e\u00a2\u0006\u0002\u0010\u0019\u001a\u0016\u0010\u001a\u001a\u00020\n*\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u0014\u001a\u00020\u0015\u001a\u0016\u0010\u001b\u001a\u00020\n*\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u0014\u001a\u00020\u0015\u001a\u0016\u0010\u001c\u001a\u00020\n*\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u001d\u001a\u00020\u001e\u001a$\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0003\"\u0004\b\u0000\u0010\u000e*\b\u0012\u0004\u0012\u0002H\u000e0\u00032\u0006\u0010 \u001a\u00020\u0015\u001a$\u0010!\u001a\b\u0012\u0004\u0012\u0002H\u00040\u0003\"\u0004\b\u0000\u0010\u0004*\b\u0012\u0004\u0012\u0002H\u00040\u00032\u0006\u0010\"\u001a\u00020\u0015\u001a)\u0010#\u001a\b\u0012\u0004\u0012\u0002H\u00040\u0003\"\u0006\b\u0000\u0010\u0004\u0018\u0001*\b\u0012\u0004\u0012\u0002H\u00040\u00032\u0006\u0010 \u001a\u00020\u0015H\u0086\b\u001a$\u0010$\u001a\b\u0012\u0004\u0012\u0002H\u00040\u0003\"\u0004\b\u0000\u0010\u0004*\b\u0012\u0004\u0012\u0002H\u00040\u00032\u0006\u0010\u001d\u001a\u00020\u001e\u00a8\u0006%"}, d2={"categorize", "", "", "", "T", "categorizer", "Lkotlin/Function1;", "categorizeInto", "filters", "", "", "(Ljava/util/List;[Lkotlin/jvm/functions/Function1;)Ljava/util/List;", "forEachNotNull", "", "E", "", "action", "Lcom/commonsense/android/kotlin/base/FunctionUnit;", "getSafe", "", "index", "", "(Ljava/util/Collection;I)Ljava/lang/Object;", "invokeEachWith", "element", "(Ljava/lang/Iterable;Ljava/lang/Object;)V", "isIndexValid", "isIndexValidForInsert", "isRangeValid", "intRange", "Lkotlin/ranges/IntRange;", "limitToSize", "size", "repeate", "repeateBy", "repeateToSize", "subList", "base_release"})
public final class CollectionExtensionsKt {
    public static final boolean isIndexValid(@NotNull Collection<?> $receiver, int index) {
        Collection<?> collection;
        int n;
        int n2;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return index >= 0 && (n2 = index) < (n = (collection = $receiver).size());
    }

    public static final boolean isIndexValidForInsert(@NotNull Collection<?> $receiver, int index) {
        Collection<?> collection;
        int n;
        int n2;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return index >= 0 && (n2 = index) <= (n = (collection = $receiver).size());
    }

    @Nullable
    public static final <T> T getSafe(@NotNull Collection<? extends T> $receiver, int index) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return (T)(CollectionExtensionsKt.isIndexValid($receiver, index) ? CollectionsKt.elementAt((Iterable)$receiver, (int)index) : null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T> List<List<T>> categorizeInto(@NotNull List<? extends T> $receiver, Function1<? super T, Boolean> ... filters) {
        void $receiver$iv$iv;
        Object $receiver$iv;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(filters, (String)"filters");
        Object object = $receiver$iv = (Object[])filters;
        Collection destination$iv$iv = new ArrayList(((Object[])$receiver$iv).length);
        for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
            void item$iv$iv = $receiver$iv$iv[i];
            Function1 function1 = (Function1)item$iv$iv;
            Collection collection = destination$iv$iv;
            List list = new ArrayList();
            collection.add(list);
        }
        List result = (List)destination$iv$iv;
        $receiver$iv = $receiver;
        object = $receiver$iv.iterator();
        while (object.hasNext()) {
            Object element$iv;
            Object it = element$iv = object.next();
            Object[] $receiver$iv2 = filters;
            int index$iv = 0;
            for (int i = 0; i < $receiver$iv2.length; ++i) {
                void filterAccepts;
                Object item$iv = $receiver$iv2[i];
                int n = index$iv++;
                Function1 $i$f$map = (Function1)item$iv;
                int index = n;
                boolean $receiver$iv3 = (Boolean)filterAccepts.invoke(it);
                if (!$receiver$iv3) continue;
                ((List)result.get(index)).add(it);
            }
        }
        return result;
    }

    @NotNull
    public static final <T> Map<String, List<T>> categorize(@NotNull List<? extends T> $receiver, @NotNull Function1<? super T, String> categorizer) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(categorizer, (String)"categorizer");
        SortedMap result = MapsKt.sortedMapOf((Pair[])new Pair[0]);
        Iterable $receiver$iv = $receiver;
        for (Object element$iv : $receiver$iv) {
            Object it = element$iv;
            String key = (String)categorizer.invoke(it);
            if (result.get(key) == null) {
                result.put(key, CollectionsKt.mutableListOf((Object[])new Object[]{it}));
                continue;
            }
            List list = (List)result.get(key);
            if (list == null) continue;
            list.add(it);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T> List<T> repeate(@NotNull List<? extends T> $receiver, int repeateBy) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        List resultList = CollectionsKt.toMutableList((Collection)$receiver);
        int n = 0;
        int n2 = repeateBy;
        while (n < n2) {
            void i;
            Collection collection = resultList;
            CollectionsKt.addAll((Collection)collection, (Iterable)$receiver);
            ++i;
        }
        return resultList;
    }

    private static final <T> List<T> repeateToSize(@NotNull List<? extends T> $receiver, int size) {
        Collection collection = $receiver;
        int n = size;
        int n2 = collection.size();
        int timesToRepeate = n / n2;
        Collection collection2 = $receiver;
        n = size;
        n2 = collection2.size();
        int missingItemsToCopy = n % n2;
        List<? extends T> resultList = CollectionExtensionsKt.repeate($receiver, timesToRepeate - 1);
        return CollectionsKt.plus((Collection)resultList, (Iterable)$receiver.subList(0, missingItemsToCopy));
    }

    public static final boolean isRangeValid(@NotNull Collection<?> $receiver, @NotNull IntRange intRange) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)intRange, (String)"intRange");
        return intRange.getStart() >= 0 && intRange.getEndInclusive() < $receiver.size();
    }

    @NotNull
    public static final <T> List<T> subList(@NotNull List<? extends T> $receiver, @NotNull IntRange intRange) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)intRange, (String)"intRange");
        return $receiver.subList(intRange.getStart(), intRange.getEndInclusive());
    }

    @NotNull
    public static final <E> List<E> limitToSize(@NotNull List<? extends E> $receiver, int size) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        int n = $receiver.size();
        int n2 = 0;
        List<E> list = $receiver;
        int n3 = Math.min(size, n);
        return list.subList(n2, n3);
    }

    public static final <E> void invokeEachWith(@NotNull Iterable<? extends Function1<? super E, Unit>> $receiver, E element) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Iterable<Function1<E, Unit>> $receiver$iv = $receiver;
        Iterator<Function1<E, Unit>> iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            Function1<? super E, Unit> element$iv;
            Function1<? super E, Unit> it = element$iv = iterator.next();
            it.invoke(element);
        }
    }

    public static final <E> void forEachNotNull(@NotNull Iterable<? extends E> $receiver, @NotNull Function1<? super E, Unit> action) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        Iterable<E> $receiver$iv = $receiver;
        for (E element$iv : $receiver$iv) {
            E e;
            E it = element$iv;
            if (it == null) continue;
            Function1<? super E, Unit> function1 = action;
            Unit cfr_ignored_0 = (Unit)function1.invoke(e);
        }
    }
}

